/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.DirectoryExtractor;
import ai.platon.pulsar.common.FileExtractor;
import ai.platon.pulsar.common.ResourceExtractor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u0007H\u0007J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u0005H\u0007J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/common/LinkExtractors;", "", "()V", "fromDirectory", "", "", "baseDir", "Ljava/nio/file/Path;", "filter", "Lkotlin/Function1;", "", "fromFile", "path", "fromResource", "resource", "pulsar-common"})
public final class LinkExtractors {
    @NotNull
    public static final LinkExtractors INSTANCE = new LinkExtractors();

    private LinkExtractors() {
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return new ResourceExtractor(resource, null, 2, null).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromResource(@NotNull String resource, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return new ResourceExtractor(resource, filter).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new FileExtractor(path, null, 2, null).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromFile(@NotNull Path path, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return new FileExtractor(path, filter).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return new FileExtractor(path2, null, 2, null).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromFile(@NotNull String path, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return new FileExtractor(path2, filter).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromDirectory(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        return new DirectoryExtractor(baseDir, null, 2, null).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromDirectory(@NotNull Path baseDir, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return new DirectoryExtractor(baseDir, filter).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromDirectory(@NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = Paths.get(baseDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new DirectoryExtractor(path, null, 2, null).extract();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> fromDirectory(@NotNull String baseDir, @NotNull Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Path path = Paths.get(baseDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new DirectoryExtractor(path, filter).extract();
    }
}

