/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SParser {
    public static final Logger LOG = LogsKt.getLogger(SParser.class);
    public static final Duration INVALID_DURATION = Duration.ofSeconds(Integer.MIN_VALUE);
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    private static final int MAX_SUBST = 20;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private String value;

    public SParser() {
        if (this.classLoader == null) {
            this.classLoader = SParser.class.getClassLoader();
        }
    }

    public SParser(String value) {
        if (this.classLoader == null) {
            this.classLoader = SParser.class.getClassLoader();
        }
        this.value = value;
    }

    public static SParser wrap(String value) {
        return new SParser(value);
    }

    public void set(String value) {
        this.value = value;
    }

    public synchronized void setIfUnset(String value) {
        if (this.value == null) {
            this.set(value);
        }
    }

    public String get() {
        return this.substituteVars(this.value);
    }

    public String getTrimmed() {
        if (null == this.value) {
            return null;
        }
        return this.value.trim();
    }

    public String getTrimmed(String defaultValue) {
        String ret = this.getTrimmed();
        return ret == null ? defaultValue : ret;
    }

    public String getRaw() {
        return this.value;
    }

    public String get(String defaultValue) {
        return this.value == null ? defaultValue : this.value;
    }

    public int getInt(int defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public int[] getInts() {
        String[] strings = this.getTrimmedStrings();
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public void setInt(int value) {
        this.set(Integer.toString(value));
    }

    public long getLong(long defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public long getLongBytes(long defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        return TraditionalBinaryPrefix.string2long(valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        Object hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + (String)hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(long value) {
        this.set(Long.toString(value));
    }

    public float getFloat(float defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        return Float.parseFloat(valueString);
    }

    public void setFloat(float value) {
        this.set(Float.toString(value));
    }

    public double getDouble(double defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        return Double.parseDouble(valueString);
    }

    public void setDouble(double value) {
        this.set(Double.toString(value));
    }

    public boolean getBoolean(boolean defaultValue) {
        String valueString = this.getTrimmed();
        if (null == valueString || valueString.isEmpty()) {
            return defaultValue;
        }
        if ("true".equals(valueString = valueString.toLowerCase())) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(boolean value) {
        this.set(Boolean.toString(value));
    }

    public void setBooleanIfUnset(boolean value) {
        this.setIfUnset(Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(T value) {
        this.set(value.toString());
    }

    public <T extends Enum<T>> T getEnum(T defaultValue) {
        return null == this.value ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), this.value);
    }

    public void setTimeDuration(long value, TimeUnit unit) {
        this.set(value + ParsedTimeDuration.unitFor(unit).suffix());
    }

    public long getTimeDuration(long defaultValue, TimeUnit unit) {
        if (null == this.value) {
            return defaultValue;
        }
        this.value = this.value.trim();
        ParsedTimeDuration vUnit = ParsedTimeDuration.unitFor(this.value);
        if (null == vUnit) {
            LOG.warn("No unit for (" + this.value + ") assuming " + String.valueOf((Object)unit));
            vUnit = ParsedTimeDuration.unitFor(unit);
        } else {
            this.value = this.value.substring(0, this.value.lastIndexOf(vUnit.suffix()));
        }
        return unit.convert(Long.parseLong(this.value), vUnit.unit());
    }

    public Pattern getPattern(Pattern defaultValue) {
        if (null == this.value || this.value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Pattern.compile(this.value);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn("Regular expression '" + this.value + "' for property '' not valid. Using default", (Throwable)pse);
            return defaultValue;
        }
    }

    public void setPattern(Pattern pattern) {
        if (null == pattern) {
            this.set(null);
        } else {
            this.set(pattern.pattern());
        }
    }

    public IntegerRanges getRange(String defaultValue) {
        return new IntegerRanges(this.get(defaultValue));
    }

    public Collection<String> getStringCollection() {
        return Strings.getStringCollection(this.value);
    }

    public Pair<String, String> getPair(Pair<String, String> defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        int pos = this.value.indexOf(":");
        if (pos > 0 && pos < this.value.length() - 1) {
            return Pair.of((Object)this.value.substring(0, pos), (Object)this.value.substring(pos));
        }
        return defaultValue;
    }

    public Map<String, String> getKvs() {
        return this.getKvs("[\\s+|,]", ":");
    }

    public Map<String, String> getKvs(String kvDelimeter) {
        return this.getKvs("[\\s+|,]", kvDelimeter);
    }

    public Map<String, String> getKvs(String pairDelimeterPattern, String kvDelimeter) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        if (this.value == null) {
            return kvs;
        }
        for (String s2 : this.value.split(pairDelimeterPattern)) {
            int pos = s2.indexOf(kvDelimeter);
            if (pos <= 0 || pos >= s2.length() - 1) continue;
            kvs.put(s2.substring(0, pos), s2.substring(pos + 1));
        }
        return kvs;
    }

    public String[] getStrings() {
        return Strings.getStrings(this.value);
    }

    public void setStrings(String ... values) {
        this.set(Strings.arrayToString(values));
    }

    public String[] getStrings(String ... defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        return Strings.getStrings(this.value);
    }

    public Collection<String> getTrimmedStringCollection() {
        if (null == this.value) {
            return Collections.emptyList();
        }
        return Strings.getTrimmedStringCollection(this.value);
    }

    public String[] getTrimmedStrings() {
        return Strings.getTrimmedStrings(this.value);
    }

    public String[] getTrimmedStrings(String ... defaultValue) {
        if (null == this.value) {
            return defaultValue;
        }
        return Strings.getTrimmedStrings(this.value);
    }

    public Integer getUint(int defaultValue) {
        int value = this.getInt(defaultValue);
        if (value < 0) {
            value = defaultValue;
        }
        return value;
    }

    public Long getUlong(long defaultValue) {
        Long value = this.getLong(defaultValue);
        if (value < 0L) {
            value = defaultValue;
        }
        return value;
    }

    public void setIfNotNull(String value) {
        if (value != null) {
            this.set(value);
        }
    }

    public void setIfNotEmpty(String value) {
        if (value != null && !value.isEmpty()) {
            this.set(value);
        }
    }

    public Duration getDuration(Duration defaultValue) {
        if (this.value == null || this.value.length() < 2) {
            return defaultValue;
        }
        String upperCase = this.value.toUpperCase();
        try {
            if (upperCase.startsWith("P") || upperCase.startsWith("-P")) {
                try {
                    return Duration.parse(upperCase);
                }
                catch (Throwable ignored) {
                    return defaultValue;
                }
            }
            long value = this.getTimeDuration(Integer.MIN_VALUE, TimeUnit.MILLISECONDS);
            if (value == Integer.MIN_VALUE) {
                return defaultValue;
            }
            return Duration.ofMillis(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public Duration getDuration() {
        return this.getDuration(INVALID_DURATION);
    }

    public Instant getInstant() {
        return this.getInstant(Instant.EPOCH);
    }

    public Instant getInstant(Instant defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        if (NumberUtils.isDigits((String)this.value)) {
            return Instant.ofEpochMilli(this.getLong(defaultValue.toEpochMilli()));
        }
        return DateTimes.parseBestInstant(this.value);
    }

    public Path getPath(Path defaultValue, boolean createDirectories) throws IOException {
        Path path;
        Path path2 = path = this.value != null ? Paths.get(this.value, new String[0]) : defaultValue;
        if (createDirectories) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return path;
    }

    public Path getPath(Path defaultValue) {
        try {
            Path path = this.value != null ? Paths.get(this.value, new String[0]) : defaultValue;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return path;
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    @Nullable
    public Path getPathOrNull() {
        try {
            if (this.value != null) {
                Path path = Paths.get(this.value, new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                return path;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = this.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name) {
        Map map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.computeIfAbsent(this.classLoader, k -> Collections.synchronizedMap(new WeakHashMap()));
        }
        Class<?> clazz = null;
        WeakReference ref = (WeakReference)map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                map.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public Class<?>[] getClasses(Class<?> ... defaultValue) {
        String[] classnames = this.getTrimmedStrings();
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(Class<?> defaultValue) {
        String valueString = this.getTrimmed();
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(String.valueOf(theClass) + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(String.valueOf(theClass) + " not " + xface.getName());
        }
        this.set(theClass.getName());
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource() {
        return this.classLoader.getResource(this.value);
    }

    public InputStream getResourceAsInputStream() {
        try {
            URL url = this.getResource();
            if (url == null) {
                LOG.info(this.value + " not found");
                return null;
            }
            LOG.info("found resource " + this.value + " at " + String.valueOf(url));
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getResourceAsReader() {
        try {
            URL url = this.getResource();
            if (url == null) {
                LOG.info(this.value + " not found");
                return null;
            }
            LOG.info("found resource " + this.value + " at " + String.valueOf(url));
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = VAR_PATTERN.matcher("");
        Object eval = expr;
        for (int s2 = 0; s2 < 20; ++s2) {
            match.reset((CharSequence)eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw();
            }
            if (val == null) {
                return eval;
            }
            eval = ((String)eval).substring(0, match.start()) + val + ((String)eval).substring(match.end());
        }
        throw new IllegalArgumentException("Variable substitution depth too large: 20 " + expr);
    }

    private static String format(String format, Object ... objects) {
        return String.format(Locale.ENGLISH, format, objects);
    }

    public static enum TraditionalBinaryPrefix {
        KILO(10),
        MEGA(TraditionalBinaryPrefix.KILO.bitShift + 10),
        GIGA(TraditionalBinaryPrefix.MEGA.bitShift + 10),
        TERA(TraditionalBinaryPrefix.GIGA.bitShift + 10),
        PETA(TraditionalBinaryPrefix.TERA.bitShift + 10),
        EXA(TraditionalBinaryPrefix.PETA.bitShift + 10);

        public final long value;
        public final char symbol;
        public final int bitShift;
        public final long bitMask;

        private TraditionalBinaryPrefix(int bitShift) {
            this.bitShift = bitShift;
            this.value = 1L << bitShift;
            this.bitMask = this.value - 1L;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s2) {
            long prefix;
            int lastpos;
            char lastchar = (s2 = s2.trim()).charAt(lastpos = s2.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s2);
            }
            try {
                prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s2 + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)");
            }
            long num = Long.parseLong(s2.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s2 + " does not fit in a Long");
            }
            return num * prefix;
        }

        public static String long2String(long n, String unit, int decimalPlaces) {
            int i;
            if (unit == null) {
                unit = "";
            }
            if (n == Long.MIN_VALUE) {
                return "-8 " + TraditionalBinaryPrefix.EXA.symbol + unit;
            }
            StringBuilder b = new StringBuilder();
            if (n < 0L) {
                b.append('-');
                n = -n;
            }
            if (n < TraditionalBinaryPrefix.KILO.value) {
                b.append(n);
                return (unit.isEmpty() ? b : b.append(" ").append(unit)).toString();
            }
            for (i = 0; i < TraditionalBinaryPrefix.values().length && n >= TraditionalBinaryPrefix.values()[i].value; ++i) {
            }
            TraditionalBinaryPrefix prefix = TraditionalBinaryPrefix.values()[i - 1];
            if ((n & prefix.bitMask) == 0L) {
                b.append(n >> prefix.bitShift);
            } else {
                String format = "%." + decimalPlaces + "f";
                String s2 = SParser.format(format, (double)n / (double)prefix.value);
                if (s2.startsWith("1024")) {
                    prefix = TraditionalBinaryPrefix.values()[i];
                    s2 = SParser.format(format, (double)n / (double)prefix.value);
                }
                b.append(s2);
            }
            return b.append(' ').append(prefix.symbol).append(unit).toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ParsedTimeDuration {
        NS{

            @Override
            TimeUnit unit() {
                return TimeUnit.NANOSECONDS;
            }

            @Override
            String suffix() {
                return "ns";
            }
        }
        ,
        US{

            @Override
            TimeUnit unit() {
                return TimeUnit.MICROSECONDS;
            }

            @Override
            String suffix() {
                return "us";
            }
        }
        ,
        MS{

            @Override
            TimeUnit unit() {
                return TimeUnit.MILLISECONDS;
            }

            @Override
            String suffix() {
                return "ms";
            }
        }
        ,
        S{

            @Override
            TimeUnit unit() {
                return TimeUnit.SECONDS;
            }

            @Override
            String suffix() {
                return "s";
            }
        }
        ,
        M{

            @Override
            TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            @Override
            String suffix() {
                return "m";
            }
        }
        ,
        H{

            @Override
            TimeUnit unit() {
                return TimeUnit.HOURS;
            }

            @Override
            String suffix() {
                return "h";
            }
        }
        ,
        D{

            @Override
            TimeUnit unit() {
                return TimeUnit.DAYS;
            }

            @Override
            String suffix() {
                return "d";
            }
        };


        static ParsedTimeDuration unitFor(String s2) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (!s2.endsWith(ptd.suffix())) continue;
                return ptd;
            }
            return null;
        }

        static ParsedTimeDuration unitFor(TimeUnit unit) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (ptd.unit() != unit) continue;
                return ptd;
            }
            return null;
        }

        abstract TimeUnit unit();

        abstract String suffix();
    }

    public static class IntegerRanges
    implements Iterable<Integer> {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.ranges == null || this.ranges.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeNumberIterator(this.ranges);
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }

        private static class RangeNumberIterator
        implements Iterator<Integer> {
            Iterator<Range> internal;
            int at;
            int end;

            public RangeNumberIterator(List<Range> ranges) {
                if (ranges != null) {
                    this.internal = ranges.iterator();
                }
                this.at = -1;
                this.end = -2;
            }

            @Override
            public boolean hasNext() {
                if (this.at <= this.end) {
                    return true;
                }
                if (this.internal != null) {
                    return this.internal.hasNext();
                }
                return false;
            }

            @Override
            public Integer next() {
                Range found;
                if (this.at <= this.end) {
                    ++this.at;
                    return this.at - 1;
                }
                if (this.internal != null && (found = this.internal.next()) != null) {
                    this.at = found.start;
                    this.end = found.end;
                    ++this.at;
                    return this.at - 1;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

