/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.code;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/code/ProjectUtils;", "", "()V", "findFile", "Ljava/nio/file/Path;", "fileName", "", "findProjectRootDir", "startDir", "walkToFindFile", "baseDir", "pulsar-common"})
public final class ProjectUtils {
    @NotNull
    public static final ProjectUtils INSTANCE = new ProjectUtils();

    private ProjectUtils() {
    }

    @Nullable
    public final Path findProjectRootDir() {
        Path path = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return this.findProjectRootDir(path);
    }

    @Nullable
    public final Path findProjectRootDir(@NotNull Path startDir) {
        Path projectRootDir;
        Intrinsics.checkNotNullParameter((Object)startDir, (String)"startDir");
        for (projectRootDir = startDir; projectRootDir != null; projectRootDir = projectRootDir.getParent()) {
            Path path;
            Intrinsics.checkNotNullExpressionValue((Object)projectRootDir.resolve("VERSION"), (String)"resolve(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break;
        }
        return projectRootDir;
    }

    @Nullable
    public final Path walkToFindFile(@NotNull String fileName, @NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Optional<Object> optional = Files.walk(baseDir, new FileVisitOption[0]).filter(arg_0 -> ProjectUtils.walkToFindFile$lambda$0((Function1)new Function1<Path, Boolean>(fileName){
            final /* synthetic */ String $fileName;
            {
                this.$fileName = $fileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)this.$fileName);
            }
        }, arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        return (Path)OptionalsKt.getOrNull(optional);
    }

    @Nullable
    public final Path findFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path projectRootDir = this.findProjectRootDir();
        return projectRootDir != null ? this.walkToFindFile(fileName, projectRootDir) : null;
    }

    private static final boolean walkToFindFile$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

