/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.urls.TenantedUrl;
import com.google.common.net.InternetDomainName;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0011J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0018\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0007J\u001c\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u0010$\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0014\u0010'\u001a\u0004\u0018\u00010\u00112\b\u0010(\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005H\u0007J\u0010\u0010.\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010/\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u00100\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u00101\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u000e\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u0005J\u0012\u00104\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u00105\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0011J'\u00106\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000508\"\u00020\u0005\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001c\u0010<\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010>\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020+H\u0007J\u001a\u0010@\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020+H\u0007J\u001e\u0010A\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010?\u001a\u00020+H\u0007J&\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050D2\b\b\u0002\u0010?\u001a\u00020+H\u0007J&\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050F2\u0006\u0010G\u001a\u00020\u00052\b\b\u0002\u0010H\u001a\u00020+H\u0007J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020;H\u0007J'\u0010K\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000508\"\u00020\u0005\u00a2\u0006\u0002\u00109J\u0018\u0010L\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u001c\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00052\n\u0010P\u001a\u00060Qj\u0002`RH\u0002J\u0010\u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005H\u0007J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0011H\u0007J\u0018\u0010U\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010V\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010W\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001a\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050Y2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050F2\u0006\u0010[\u001a\u00020\u0005H\u0007J\u0012\u0010\\\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0007J\u0018\u0010_\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0010\u0010_\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0012\u0010`\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u0005H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006a"}, d2={"Lai/platon/pulsar/common/urls/UrlUtils;", "", "()V", "INTERNAL_URLS", "", "", "getINTERNAL_URLS", "()Ljava/util/List;", "INTERNAL_URL_PREFIXES", "getINTERNAL_URL_PREFIXES", "browserURLToStandardURL", "url", "decodeKeyLowerBound", "startKey", "decodeKeyUpperBound", "endKey", "fixPureQueryTargets", "Ljava/net/URL;", "base", "targetUrl", "getDomainName", "getDomainNameOrNull", "getEndKey", "tenantId", "", "unreversedUrl", "getHostName", "defaultValue", "getHostNameOrNull", "getOrigin", "getOriginOrNull", "getPublicSuffix", "getQueryParameters", "parameterName", "getReversedHost", "reversedUrl", "getStartKey", "getTopPrivateDomain", "getTopPrivateDomainOrNull", "getURLOrNull", "spec", "getUrlWithoutParameters", "isAllowed", "", "str", "isBrowserURL", "isInternal", "isLocalFile", "isMappedBrowserURL", "isNotInternal", "isPublicSuffix", "domain", "isStandard", "isTopPrivateDomain", "keepQueryParameters", "parameterNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "localURLToPath", "Ljava/nio/file/Path;", "mergeUrlArgs", "args", "normalize", "ignoreQuery", "normalizeOrEmpty", "normalizeOrNull", "normalizeUrls", "urls", "", "normalizedUrlAndKey", "Lkotlin/Pair;", "originalUrl", "norm", "pathToLocalURL", "path", "removeQueryParameters", "resolveURL", "reverseAppendSplits", "", "string", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reverseHost", "hostName", "reverseUrl", "reverseUrlOrEmpty", "reverseUrlOrNull", "splitQueryParameters", "", "splitUrlArgs", "configuredUrl", "standardURLToBrowserURL", "unreverseHost", "reversedHostName", "unreverseUrl", "unreverseUrlOrNull", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlUtils.kt\nai/platon/pulsar/common/urls/UrlUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,997:1\n1747#2,3:998\n1603#2,9:1002\n1855#2:1011\n1856#2:1013\n1612#2:1014\n1179#2,2:1015\n1253#2,4:1017\n288#2,2:1021\n1#3:1001\n1#3:1012\n151#4,6:1023\n*S KotlinDebug\n*F\n+ 1 UrlUtils.kt\nai/platon/pulsar/common/urls/UrlUtils\n*L\n94#1:998,3\n297#1:1002,9\n297#1:1011\n297#1:1013\n297#1:1014\n308#1:1015,2\n308#1:1017,4\n320#1:1021,2\n297#1:1012\n417#1:1023,6\n*E\n"})
public final class UrlUtils {
    @NotNull
    public static final UrlUtils INSTANCE = new UrlUtils();
    @NotNull
    private static final List<String> INTERNAL_URL_PREFIXES;
    @NotNull
    private static final List<String> INTERNAL_URLS;

    private UrlUtils() {
    }

    @NotNull
    public final List<String> getINTERNAL_URL_PREFIXES() {
        return INTERNAL_URL_PREFIXES;
    }

    @NotNull
    public final List<String> getINTERNAL_URLS() {
        return INTERNAL_URLS;
    }

    @JvmStatic
    public static final boolean isInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://internal.pulsar.platon.ai", (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean isNotInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return !UrlUtils.isInternal(url);
    }

    @JvmStatic
    public static final boolean isLocalFile(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://localfile.org", (boolean)false, (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final String pathToLocalURL(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Base64.Encoder encoder = Base64.getUrlEncoder();
        Object object = ((Object)path).toString();
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = encoder.encode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        object = Charsets.UTF_8;
        String base64 = new String(byArray3, (Charset)object);
        String prefix = "http://localfile.org";
        return prefix + "?path=" + base64;
    }

    @JvmStatic
    @NotNull
    public static final Path localURLToPath(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String path = StringsKt.substringAfter$default((String)url, (String)"?path=", null, (int)2, null);
        byte[] byArray = Base64.getUrlDecoder().decode(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        String base64 = new String(byArray2, charset);
        Path path2 = Path.of(base64, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return path2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isBrowserURL(@NotNull String str) {
        String it;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (INTERNAL_URLS.contains(str)) return true;
        Iterable $this$any$iv = INTERNAL_URL_PREFIXES;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default((String)str, (String)it, (boolean)false, (int)2, null));
        return true;
    }

    @JvmStatic
    public static final boolean isMappedBrowserURL(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://browser-specific.org", (boolean)false, (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final String browserURLToStandardURL(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String encoded = URLEncoder.encode(url, Charsets.UTF_8);
        String prefix = "http://browser-specific.org";
        return prefix + "?url=" + encoded;
    }

    @JvmStatic
    @Nullable
    public static final String standardURLToBrowserURL(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String str = StringsKt.substringAfter$default((String)url, (String)"?url=", null, (int)2, null);
        if (StringsKt.isBlank((CharSequence)str) || Intrinsics.areEqual((Object)str, (Object)url)) {
            return null;
        }
        return URLDecoder.decode(str, Charsets.UTF_8);
    }

    @JvmStatic
    @Nullable
    public static final URL getURLOrNull(@Nullable String spec) {
        Object object = spec;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return null;
        }
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)new URL(spec));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (URL)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @JvmStatic
    public static final boolean isStandard(@Nullable String str) {
        return UrlUtils.getURLOrNull(str) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAllowed(@Nullable String str) {
        if (str == null) return false;
        if (UrlUtils.isInternal(str)) return true;
        if (!UrlUtils.isStandard(str)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final URL normalize(@NotNull String url, boolean ignoreQuery) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String url0 = (String)UrlUtils.splitUrlArgs(url).component1();
        URIBuilder uriBuilder = new URIBuilder(url0);
        uriBuilder.setFragment(null);
        if (ignoreQuery) {
            uriBuilder.removeQuery();
        }
        URL uRL = uriBuilder.build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    public static /* synthetic */ URL normalize$default(String string, boolean bl, int n, Object object) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalize(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeOrEmpty(@NotNull String url, boolean ignoreQuery) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrEmpty$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrEmpty(string, bl);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeOrNull(@Nullable String url, boolean ignoreQuery) {
        String string;
        if (url == null) {
            return null;
        }
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrNull$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrNull(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> normalizeUrls(@NotNull Iterable<String> urls, boolean ignoreQuery) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable<String> $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable<String> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UrlUtils.normalizeOrNull(it, ignoreQuery) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List normalizeUrls$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeUrls(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> splitQueryParameters(@NotNull String url) throws URISyntaxException {
        Map map;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        List list2 = new URIBuilder(url).getQueryParams();
        if (list2 != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = list2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                NameValuePair it = (NameValuePair)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getQueryParameters(@NotNull String url, @NotNull String parameterName) throws URISyntaxException {
        Object v2;
        List list2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            List list3 = new URIBuilder(url).getQueryParams();
            list2 = list3;
            if (list3 == null) return null;
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NameValuePair it = (NameValuePair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        NameValuePair nameValuePair = v2;
        list2 = nameValuePair;
        if (nameValuePair == null) return null;
        String string = list2.getValue();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$removeQueryParameters_u24lambda_u246;
        List list2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list3 = list2 = uriBuilder.getQueryParams();
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl = false;
        $this$removeQueryParameters_u24lambda_u246.removeIf(arg_0 -> UrlUtils.removeQueryParameters$lambda$6$lambda$5((Function1)new Function1<NameValuePair, Boolean>(parameterNames){
            final /* synthetic */ String[] $parameterNames;
            {
                this.$parameterNames = $parameterNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(NameValuePair it) {
                return ArraysKt.contains((Object[])this.$parameterNames, (Object)it.getName());
            }
        }, arg_0));
        uRIBuilder.setParameters(list2);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String keepQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$keepQueryParameters_u24lambda_u248;
        List list2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list3 = list2 = uriBuilder.getQueryParams();
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl = false;
        $this$keepQueryParameters_u24lambda_u248.removeIf(arg_0 -> UrlUtils.keepQueryParameters$lambda$8$lambda$7((Function1)new Function1<NameValuePair, Boolean>(parameterNames){
            final /* synthetic */ String[] $parameterNames;
            {
                this.$parameterNames = $parameterNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(NameValuePair it) {
                return !ArraysKt.contains((Object[])this.$parameterNames, (Object)it.getName());
            }
        }, arg_0));
        uRIBuilder.setParameters(list2);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final URL resolveURL(@NotNull URL base, @NotNull String targetUrl) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        String target = ((Object)StringsKt.trim((CharSequence)targetUrl)).toString();
        return StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null) ? INSTANCE.fixPureQueryTargets(base, target) : new URL(base, target);
    }

    private final URL fixPureQueryTargets(URL base, String targetUrl) {
        Object target = ((Object)StringsKt.trim((CharSequence)targetUrl)).toString();
        if (!StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            return new URL(base, (String)target);
        }
        String basePath = base.getPath();
        String baseRightMost = "";
        Intrinsics.checkNotNull((Object)basePath);
        int baseRightMostIdx = StringsKt.lastIndexOf$default((CharSequence)basePath, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (baseRightMostIdx != -1) {
            String string = basePath.substring(baseRightMostIdx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            baseRightMost = string;
        }
        if (StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            target = baseRightMost + (String)target;
        }
        return new URL(base, (String)target);
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> splitUrlArgs(@NotNull String configuredUrl) {
        int n;
        String url;
        block2: {
            Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)configuredUrl)).toString();
            Regex regex = new Regex("[\\r\\n\\t]");
            String string = "";
            url = regex.replace(charSequence, string);
            CharSequence $this$indexOfFirst$iv = url;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int pos = n;
        String args = "";
        if (pos >= 0) {
            String string = url.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            args = string;
            String string2 = url.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            url = string2;
        }
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)url)).toString(), (Object)((Object)StringsKt.trim((CharSequence)args)).toString());
    }

    @JvmStatic
    @NotNull
    public static final String mergeUrlArgs(@NotNull String url, @Nullable String args) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = args;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ((Object)StringsKt.trim((CharSequence)url)).toString() : ((Object)StringsKt.trim((CharSequence)url)).toString() + " " + ((Object)StringsKt.trim((CharSequence)args)).toString();
    }

    public static /* synthetic */ String mergeUrlArgs$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UrlUtils.mergeUrlArgs(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String getUrlWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(url);
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> normalizedUrlAndKey(@NotNull String originalUrl, boolean norm) {
        String string;
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        if (norm) {
            string = UrlUtils.normalizeOrNull$default(originalUrl, false, 2, null);
            if (string == null) {
                string = "";
            }
        } else {
            string = originalUrl;
        }
        String url = string;
        String key = UrlUtils.reverseUrlOrEmpty(url);
        return TuplesKt.to((Object)url, (Object)key);
    }

    public static /* synthetic */ Pair normalizedUrlAndKey$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizedUrlAndKey(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return UrlUtils.reverseUrl(new URL(url));
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrlOrEmpty(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String reverseUrlOrNull(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        String file = url.getFile();
        String protocol = url.getProtocol();
        int port = url.getPort();
        StringBuilder buf = new StringBuilder();
        Intrinsics.checkNotNull((Object)host);
        INSTANCE.reverseAppendSplits(host, buf);
        buf.append(':');
        buf.append(protocol);
        if (port != -1) {
            buf.append(':');
            buf.append(port);
        }
        Intrinsics.checkNotNull((Object)file);
        if (((CharSequence)file).length() > 0 && '/' != file.charAt(0)) {
            buf.append('/');
        }
        buf.append(file);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(int tenantId, @NotNull String unreversedUrl) {
        Intrinsics.checkNotNullParameter((Object)unreversedUrl, (String)"unreversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(unreversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.reverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        StringBuilder buf = new StringBuilder(reversedUrl.length() + 2);
        int pathBegin = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pathBegin == -1) {
            pathBegin = reversedUrl.length();
        }
        String string = reversedUrl.substring(0, pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String sub = string;
        String[] splits = StringUtils.splitPreserveAllTokens((String)sub, (char)':');
        buf.append(splits[1]);
        buf.append("://");
        String string2 = splits[0];
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        INSTANCE.reverseAppendSplits(string2, buf);
        if (splits.length == 3) {
            buf.append(':');
            buf.append(splits[2]);
        }
        String string3 = reversedUrl.substring(pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        buf.append(string3);
        String string4 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @JvmStatic
    @Nullable
    public static final String unreverseUrlOrNull(@NotNull String reversedUrl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)UrlUtils.unreverseUrl(reversedUrl));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(int tenantId, @NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(reversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.unreverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId);
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(endKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId + 1);
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, endKey);
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyLowerBound(@NotNull String startKey) {
        Intrinsics.checkNotNullParameter((Object)startKey, (String)"startKey");
        String startKey1 = startKey;
        CharSequence charSequence = startKey1;
        Regex regex = new Regex("\\\\u0001");
        String string = "\u0001";
        startKey1 = regex.replace(charSequence, string);
        charSequence = startKey1;
        regex = new Regex("\\u0001");
        string = "\u0001";
        startKey1 = regex.replace(charSequence, string);
        return startKey1;
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyUpperBound(@NotNull String endKey) {
        Intrinsics.checkNotNullParameter((Object)endKey, (String)"endKey");
        String endKey1 = endKey;
        CharSequence charSequence = endKey1;
        Regex regex = new Regex("\\\\uFFFF");
        String string = "\uffff";
        endKey1 = regex.replace(charSequence, string);
        charSequence = endKey1;
        regex = new Regex("\\uFFFF");
        string = "\uffff";
        endKey1 = regex.replace(charSequence, string);
        return endKey1;
    }

    @JvmStatic
    @NotNull
    public static final String getReversedHost(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        String string = reversedUrl.substring(0, StringsKt.indexOf$default((CharSequence)reversedUrl, (char)':', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseHost(@NotNull String hostName) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        StringBuilder buf = new StringBuilder();
        INSTANCE.reverseAppendSplits(hostName, buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String unreverseHost(@NotNull String reversedHostName) {
        Intrinsics.checkNotNullParameter((Object)reversedHostName, (String)"reversedHostName");
        return UrlUtils.reverseHost(reversedHostName);
    }

    public final boolean isPublicSuffix(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return InternetDomainName.from((String)domain).isPublicSuffix();
    }

    @Nullable
    public final String getPublicSuffix(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = this.getTopPrivateDomainOrNull(url);
        if (string == null) {
            return null;
        }
        String domain = string;
        InternetDomainName internetDomainName = InternetDomainName.from((String)domain).publicSuffix();
        return internetDomainName != null ? internetDomainName.toString() : null;
    }

    @Nullable
    public final String getPublicSuffix(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        InternetDomainName internetDomainName = InternetDomainName.from((String)url.getHost()).publicSuffix();
        return internetDomainName != null ? internetDomainName.toString() : null;
    }

    public final boolean isTopPrivateDomain(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return InternetDomainName.from((String)url.getHost()).isTopPrivateDomain();
    }

    @NotNull
    public final String getTopPrivateDomain(@NotNull URL url) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = InternetDomainName.from((String)url.getHost()).topPrivateDomain().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getTopPrivateDomain(@NotNull String url) throws IllegalStateException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL uRL = URI.create(url).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return this.getTopPrivateDomain(uRL);
    }

    @Nullable
    public final String getTopPrivateDomainOrNull(@NotNull String url) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)INSTANCE.getTopPrivateDomain(url));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Deprecated(message="Use getTopPrivateDomain instead", replaceWith=@ReplaceWith(expression="UrlUtils.getTopPrivateDomain(url)", imports={}))
    @NotNull
    public final String getDomainName(@NotNull String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getTopPrivateDomain(url);
    }

    @Deprecated(message="Use getTopPrivateDomainOrNull instead", replaceWith=@ReplaceWith(expression="UrlUtils.getTopPrivateDomainOrNull(url)", imports={}))
    @Nullable
    public final String getDomainNameOrNull(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getTopPrivateDomainOrNull(url);
    }

    @NotNull
    public final String getOrigin(@NotNull String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL u = URI.create(url).toURL();
        return u.getPort() == 80 ? u.getProtocol() + "://" + u.getHost() : u.getProtocol() + "://" + u.getHost() + ":" + u.getPort();
    }

    @Nullable
    public final String getOriginOrNull(@Nullable String url) {
        if (url == null) {
            return null;
        }
        try {
            return this.getOrigin(url);
        }
        catch (Throwable t) {
            String string = null;
            return string;
        }
    }

    @NotNull
    public final String getHostName(@NotNull String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = URI.create(url).getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    @Nullable
    public final String getHostNameOrNull(@Nullable String url) {
        String string;
        if (url == null) {
            return null;
        }
        try {
            String string2 = URI.create(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            string = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string = string3;
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String getHostName(@Nullable String url, @NotNull String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        if (url == null) {
            return defaultValue;
        }
        try {
            String string2 = URI.create(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            string = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string = string3;
        }
        catch (MalformedURLException e) {
            string = defaultValue;
        }
        return string;
    }

    private final void reverseAppendSplits(String string, StringBuilder buf) {
        String[] splits = StringUtils.split((String)string, (char)'.');
        Intrinsics.checkNotNull((Object)splits);
        if (!(splits.length == 0)) {
            for (int i = splits.length - 1; 0 < i; --i) {
                buf.append(splits[i]);
                buf.append('.');
            }
            buf.append(splits[0]);
        } else {
            buf.append(string);
        }
    }

    private static final boolean removeQueryParameters$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean keepQueryParameters$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"chrome://", "edge://", "brave://"};
        INTERNAL_URL_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
        INTERNAL_URLS = CollectionsKt.listOf((Object)"about:blank");
    }
}

