/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.MessageWriter;
import ai.platon.pulsar.common.MultiSinkWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rJ\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\u0016\u0010\u001a\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010\u001b\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\u0017\u001a\u00020\rJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\u0017\u001a\u00020\rJ\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\bH\u0007J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\bJ\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lai/platon/pulsar/common/MultiSinkWriter;", "Ljava/lang/AutoCloseable;", "()V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lorg/slf4j/Logger;", "reportDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDir", "()Ljava/nio/file/Path;", "timeIdent", "", "getTimeIdent", "()Ljava/lang/String;", "writers", "", "Lai/platon/pulsar/common/MessageWriter;", "getWriters", "()Ljava/util/Map;", "close", "", "filename", "closeIdleWriters", "flush", "getPath", "pathOf", "readAllLines", "", "write", "message", "path", "writeLineTo", "file", "writeTo", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nMultiSinkWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiSinkWriter.kt\nai/platon/pulsar/common/MultiSinkWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,92:1\n1855#2,2:93\n215#3:95\n216#3:97\n215#3,2:105\n215#3,2:107\n1#4:96\n526#5:98\n511#5,6:99\n*S KotlinDebug\n*F\n+ 1 MultiSinkWriter.kt\nai/platon/pulsar/common/MultiSinkWriter\n*L\n69#1:93,2\n74#1:95\n74#1:97\n83#1:105,2\n84#1:107,2\n82#1:98\n82#1:99,6\n*E\n"})
public class MultiSinkWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(MultiSinkWriter.class));
    @NotNull
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Path reportDir = AppPaths.INSTANCE.getREPORT_DIR().resolve(this.getTimeIdent());
    @NotNull
    private static final ConcurrentHashMap<Path, MessageWriter> _writers = new ConcurrentHashMap();

    public MultiSinkWriter() {
        Files.createDirectories(this.reportDir, new FileAttribute[0]);
    }

    private final String getTimeIdent() {
        return DateTimes.INSTANCE.formatNow("MMdd");
    }

    public final Path getReportDir() {
        return this.reportDir;
    }

    @NotNull
    public final Map<Path, MessageWriter> getWriters() {
        return _writers;
    }

    public final Path getPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.pathOf(filename);
    }

    public final Path pathOf(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.reportDir.resolve(filename);
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list2 = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
            return list2;
        }
        return CollectionsKt.emptyList();
    }

    public final void write(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        this.writeTo(message, path);
    }

    @Deprecated(message="Use writeTo instead", replaceWith=@ReplaceWith(expression="writeTo(message, path)", imports={}))
    public final void write(@NotNull String message, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.writeTo(message, path);
    }

    public final void writeTo(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        _writers.computeIfAbsent(file.toAbsolutePath(), arg_0 -> MultiSinkWriter.writeTo$lambda$0(writeTo.1.INSTANCE, arg_0)).write(message);
        this.closeIdleWriters();
    }

    public final void writeLineTo(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MessageWriter messageWriter = _writers.computeIfAbsent(file.toAbsolutePath(), arg_0 -> MultiSinkWriter.writeLineTo$lambda$1(writeLineTo.writer.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)messageWriter, (String)"computeIfAbsent(...)");
        MessageWriter writer2 = messageWriter;
        writer2.write(message);
        writer2.write("\n");
        this.closeIdleWriters();
    }

    public final void close(@NotNull String filename) {
        block0: {
            MessageWriter writer2;
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Path path = this.getPath(filename);
            MessageWriter messageWriter = writer2 = _writers.remove(path);
            if (messageWriter == null) break block0;
            messageWriter.close();
        }
    }

    public final void flush() {
        Collection<MessageWriter> collection = _writers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageWriter it = (MessageWriter)element$iv;
            boolean bl = false;
            it.flush();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Map $this$forEach$iv = _writers;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Object object2 = this;
                try {
                    MultiSinkWriter $this$close_u24lambda_u245_u24lambda_u243 = object2;
                    boolean bl2 = false;
                    ((MessageWriter)it.getValue()).close();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue;
                Object it2 = object = throwable;
                boolean bl3 = false;
                LogsKt.warnForClose(this, (Throwable)it2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeIdleWriters() {
        try {
            Map.Entry element$iv;
            Map idleWriters;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = _writers;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!((MessageWriter)it.getValue()).isIdle()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = idleWriters = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                _writers.remove(it.getKey());
            }
            $this$forEach$iv = idleWriters;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Object object2 = this;
                try {
                    MultiSinkWriter $this$closeIdleWriters_u24lambda_u2410_u24lambda_u248 = object2;
                    boolean bl2 = false;
                    ((MessageWriter)it.getValue()).close();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue;
                Object it2 = object = throwable;
                boolean bl3 = false;
                LogsKt.warnForClose(this, (Throwable)it2);
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception", (Throwable)e);
        }
    }

    private static final MessageWriter writeTo$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessageWriter)$tmp0.invoke(p0);
    }

    private static final MessageWriter writeLineTo$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessageWriter)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/MultiSinkWriter$Companion;", "", "()V", "_writers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lai/platon/pulsar/common/MessageWriter;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

