/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];

    public static <T> T newInstance(Class<T> theClass) {
        Object result;
        try {
            Constructor<Object> constructor = CONSTRUCTOR_CACHE.get(theClass);
            if (constructor == null) {
                constructor = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                constructor.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, constructor);
            }
            result = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T forName(@NotNull String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (className == null) {
            ReflectionUtils.$$$reportNull$$$0(0);
        }
        return (T)Class.forName(className).newInstance();
    }

    public static <T> T forNameOrNull(@NotNull String className) {
        if (className == null) {
            ReflectionUtils.$$$reportNull$$$0(1);
        }
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "className";
        objectArray2[1] = "ai/platon/pulsar/common/ReflectionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forNameOrNull";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

