/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.browser;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.browser.BrowserFiles;
import ai.platon.pulsar.common.browser.ContextGroup;
import ai.platon.pulsar.common.browser.Fingerprint;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J$\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0019J(\u0010(\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010)\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010*\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u0004J\u001a\u0010+\u001a\u00020\u000f2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0019J \u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u0010.\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010/\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0004J\u000e\u00100\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000fJ\u000e\u00101\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0004J/\u00102\u001a\u0002H3\"\u0004\b\u0000\u001032\u0006\u00104\u001a\u00020\u000f2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H306H\u0002\u00a2\u0006\u0002\u00107J/\u00108\u001a\u0002H3\"\u0004\b\u0000\u001032\u0006\u00104\u001a\u00020\u000f2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H306H\u0002\u00a2\u0006\u0002\u00107R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lai/platon/pulsar/common/browser/BrowserFiles;", "", "()V", "CONTEXT_DIR_PREFIX", "", "CONTEXT_LOCK_NAME", "PID_FILE_NAME", "PORT_FILE_NAME", "TEMPORARY_UDD_EXPIRY", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getTEMPORARY_UDD_EXPIRY", "()Ljava/time/Duration;", "cleanedUserDataDirs", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Ljava/nio/file/Path;", "contextGroups", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/common/browser/ContextGroup;", "logger", "Lorg/slf4j/Logger;", "cleanOldestContextTmpDirs", "", "expiry", "recentNToKeep", "", "cleanUpContextDir", "contextDir", "cleanUpContextTmpDir", "computeContextCount", "", "baseDir", "prefix", "channel", "Ljava/nio/channels/FileChannel;", "computeNextSequentialContextDir", "group", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "maxAgents", "computeNextSequentialContextDir0", "computeRandomContextDir0", "computeRandomTmpContextDir", "computeTestContextDir", "deleteTemporaryUserDataDir0", "userDataDir", "deleteTemporaryUserDataDirWithLock", "getContextGroupDirLockFile", "getContextGroupLockFileFromUserDataDir", "getTempContextGroupDirLockFile", "runWithFileLock0", "T", "lockFile", "supplier", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "runWithFileLockWithRetry", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nBrowserFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserFiles.kt\nai/platon/pulsar/common/browser/BrowserFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,464:1\n1054#2:465\n1855#2,2:466\n1549#2:469\n1620#2,3:470\n1549#2:473\n1620#2,3:474\n766#2:477\n857#2,2:478\n1855#2,2:480\n1#3:468\n*S KotlinDebug\n*F\n+ 1 BrowserFiles.kt\nai/platon/pulsar/common/browser/BrowserFiles\n*L\n125#1:465\n127#1:466,2\n351#1:469\n351#1:470,3\n352#1:473\n352#1:474,3\n353#1:477\n353#1:478,2\n353#1:480,2\n*E\n"})
public final class BrowserFiles {
    @NotNull
    public static final BrowserFiles INSTANCE = new BrowserFiles();
    @NotNull
    private static final Logger logger = LogsKt.getLogger(INSTANCE);
    @NotNull
    public static final String CONTEXT_DIR_PREFIX = "cx.";
    @NotNull
    public static final String PID_FILE_NAME = "launcher.pid";
    @NotNull
    public static final String PORT_FILE_NAME = "port";
    @NotNull
    public static final String CONTEXT_LOCK_NAME = "context.lock";
    private static final Duration TEMPORARY_UDD_EXPIRY = Duration.ofHours(12L);
    @NotNull
    private static final ConcurrentHashMap<String, ContextGroup> contextGroups = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentSkipListSet<Path> cleanedUserDataDirs = new ConcurrentSkipListSet();

    private BrowserFiles() {
    }

    public final Duration getTEMPORARY_UDD_EXPIRY() {
        return TEMPORARY_UDD_EXPIRY;
    }

    @NotNull
    public final synchronized Path computeTestContextDir(@NotNull Fingerprint fingerprint, int maxAgents) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        String group = "test";
        Path lockFile = this.getContextGroupDirLockFile(group);
        return (Path)this.runWithFileLockWithRetry(lockFile, (Function1)new Function1<FileChannel, Path>(group, fingerprint, maxAgents){
            final /* synthetic */ String $group;
            final /* synthetic */ Fingerprint $fingerprint;
            final /* synthetic */ int $maxAgents;
            {
                this.$group = $group;
                this.$fingerprint = $fingerprint;
                this.$maxAgents = $maxAgents;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                return BrowserFiles.access$computeNextSequentialContextDir0(BrowserFiles.INSTANCE, this.$group, this.$fingerprint, this.$maxAgents, channel);
            }
        });
    }

    public static /* synthetic */ Path computeTestContextDir$default(BrowserFiles browserFiles, Fingerprint fingerprint, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            fingerprint = Fingerprint.Companion.getDEFAULT();
        }
        if ((n2 & 2) != 0) {
            n = 10;
        }
        return browserFiles.computeTestContextDir(fingerprint, n);
    }

    @NotNull
    public final synchronized Path computeNextSequentialContextDir(@NotNull String group, @NotNull Fingerprint fingerprint, int maxAgents) throws IOException {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Path lockFile = this.getContextGroupDirLockFile(group);
        return (Path)this.runWithFileLockWithRetry(lockFile, (Function1)new Function1<FileChannel, Path>(group, fingerprint, maxAgents){
            final /* synthetic */ String $group;
            final /* synthetic */ Fingerprint $fingerprint;
            final /* synthetic */ int $maxAgents;
            {
                this.$group = $group;
                this.$fingerprint = $fingerprint;
                this.$maxAgents = $maxAgents;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                return BrowserFiles.access$computeNextSequentialContextDir0(BrowserFiles.INSTANCE, this.$group, this.$fingerprint, this.$maxAgents, channel);
            }
        });
    }

    public static /* synthetic */ Path computeNextSequentialContextDir$default(BrowserFiles browserFiles, String string, Fingerprint fingerprint, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            string = "default";
        }
        if ((n2 & 2) != 0) {
            fingerprint = Fingerprint.Companion.getDEFAULT();
        }
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return browserFiles.computeNextSequentialContextDir(string, fingerprint, n);
    }

    @NotNull
    public final synchronized Path computeRandomTmpContextDir(@NotNull String group) throws IOException {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Path lockFile = this.getTempContextGroupDirLockFile(group);
        return (Path)this.runWithFileLockWithRetry(lockFile, (Function1)new Function1<FileChannel, Path>(group){
            final /* synthetic */ String $group;
            {
                this.$group = $group;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                return BrowserFiles.access$computeRandomContextDir0(BrowserFiles.INSTANCE, this.$group, channel);
            }
        });
    }

    public static /* synthetic */ Path computeRandomTmpContextDir$default(BrowserFiles browserFiles, String string, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = "rand";
        }
        return browserFiles.computeRandomTmpContextDir(string);
    }

    public final void cleanOldestContextTmpDirs(@NotNull Duration expiry, int recentNToKeep) throws IOException {
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        List<Object> list2 = Files.walk(AppPaths.INSTANCE.getCONTEXT_TMP_DIR(), 3, new FileVisitOption[0]).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$0(cleanOldestContextTmpDirs.1.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$1(cleanOldestContextTmpDirs.2.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$2(cleanOldestContextTmpDirs.3.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanOldestContextTmpDirs$lambda$3(cleanOldestContextTmpDirs.4.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        Iterable $this$sortedByDescending$iv = CollectionsKt.toSet((Iterable)list2);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)b;
                boolean bl = false;
                Comparable comparable = Files.getLastModifiedTime(it, new LinkOption[0]);
                it = (Path)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Files.getLastModifiedTime(it, new LinkOption[0]));
            }
        }), (int)recentNToKeep);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.cleanUpContextDir(it, expiry);
        }
    }

    public static /* synthetic */ void cleanOldestContextTmpDirs$default(BrowserFiles browserFiles, Duration duration, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        browserFiles.cleanOldestContextTmpDirs(duration, n);
    }

    public final void cleanUpContextTmpDir(@NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Files.walk(AppPaths.INSTANCE.getCONTEXT_TMP_DIR(), 3, new FileVisitOption[0]).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$6(cleanUpContextTmpDir.1.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$7(cleanUpContextTmpDir.2.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$8(cleanUpContextTmpDir.3.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$9(cleanUpContextTmpDir.4.INSTANCE, arg_0)).forEach(arg_0 -> BrowserFiles.cleanUpContextTmpDir$lambda$10((Function1)new Function1<Path, Unit>(expiry){
            final /* synthetic */ Duration $expiry;
            {
                this.$expiry = $expiry;
                super(1);
            }

            public final void invoke(Path path) {
                Intrinsics.checkNotNull((Object)path);
                BrowserFiles.INSTANCE.cleanUpContextDir(path, this.$expiry);
            }
        }, arg_0));
    }

    public final void cleanUpContextDir(@NotNull Path contextDir, @NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        if (!StringsKt.startsWith$default((String)((Object)contextDir.getFileName()).toString(), (String)CONTEXT_DIR_PREFIX, (boolean)false, (int)2, null)) {
            logger.info("Not a context directory | {}", (Object)contextDir);
            return;
        }
        String groupName = ((Object)contextDir.getParent().getFileName()).toString();
        Files.list(contextDir).filter(arg_0 -> BrowserFiles.cleanUpContextDir$lambda$11(cleanUpContextDir.1.INSTANCE, arg_0)).forEach(arg_0 -> BrowserFiles.cleanUpContextDir$lambda$12((Function1)new Function1<Path, Unit>(groupName, expiry){
            final /* synthetic */ String $groupName;
            final /* synthetic */ Duration $expiry;
            {
                this.$groupName = $groupName;
                this.$expiry = $expiry;
                super(1);
            }

            public final void invoke(Path dirToDelete) {
                Intrinsics.checkNotNull((Object)dirToDelete);
                BrowserFiles.INSTANCE.deleteTemporaryUserDataDirWithLock(this.$groupName, dirToDelete, this.$expiry);
            }
        }, arg_0));
    }

    public final synchronized void deleteTemporaryUserDataDirWithLock(@NotNull String group, @NotNull Path userDataDir, @NotNull Duration expiry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Path lockFile = this.getTempContextGroupDirLockFile(group);
        this.runWithFileLockWithRetry(lockFile, (Function1)new Function1<FileChannel, Unit>(userDataDir, expiry){
            final /* synthetic */ Path $userDataDir;
            final /* synthetic */ Duration $expiry;
            {
                this.$userDataDir = $userDataDir;
                this.$expiry = $expiry;
                super(1);
            }

            public final void invoke(@NotNull FileChannel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                BrowserFiles.access$deleteTemporaryUserDataDir0(BrowserFiles.INSTANCE, this.$userDataDir, this.$expiry, channel);
            }
        });
    }

    private final synchronized <T> T runWithFileLockWithRetry(Path lockFile, Function1<? super FileChannel, ? extends T> supplier) throws OverlappingFileLockException, IOException {
        Object $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$result$22;
        int retryCount = 0;
        try {
            boolean $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$result$22 = false;
            $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$result$22 = Result.constructor-impl(INSTANCE.runWithFileLock0(lockFile, supplier));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$result$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result = $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$result$22;
        while (Result.isFailure-impl((Object)result) && ++retryCount <= 3) {
            Object $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$22;
            LangKt.sleepSeconds(1L);
            try {
                boolean $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$22 = false;
                $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$22 = Result.constructor-impl(INSTANCE.runWithFileLock0(lockFile, supplier));
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            result = $i$a$-runCatching-BrowserFiles$runWithFileLockWithRetry$22;
        }
        if (Result.isFailure-impl((Object)result)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable);
            Throwable e = throwable;
            if (e instanceof IOException) {
                throw e;
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable2);
            throw new IOException("runWithFileLockWithRetry", throwable2);
        }
        Object object = result;
        ResultKt.throwOnFailure((Object)object);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized <T> T runWithFileLock0(Path lockFile, Function1<? super FileChannel, ? extends T> supplier) throws OverlappingFileLockException, IOException {
        Object object = new OpenOption[]{StandardOpenOption.APPEND};
        FileChannel channel = FileChannel.open(lockFile, object);
        object = channel;
        Throwable throwable = null;
        try {
            Object object2;
            FileChannel it = (FileChannel)object;
            boolean bl = false;
            FileLock lock = it.lock();
            try {
                Intrinsics.checkNotNull((Object)it);
                object2 = supplier.invoke((Object)it);
            }
            catch (Throwable throwable2) {
                try {
                    lock.release();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            lock.release();
            Object object3 = object2;
            return (T)object3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void deleteTemporaryUserDataDir0(Path userDataDir, Duration expiry, FileChannel channel) {
        if (!channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22 = false;
            String $i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$deleteTemporaryUserDataDir0$22.toString());
        }
        Path dirToDelete = userDataDir;
        if (!Files.exists(dirToDelete, new LinkOption[0])) {
            return;
        }
        boolean cleanedUp = cleanedUserDataDirs.contains(dirToDelete);
        if (cleanedUp) {
            return;
        }
        boolean isTemporary = dirToDelete.startsWith(AppPaths.INSTANCE.getCONTEXT_TMP_DIR());
        if (!isTemporary) {
            logger.error("Not a temporary user data dir | {}", (Object)dirToDelete);
            return;
        }
        Instant lastModifiedTime = Files.getLastModifiedTime(dirToDelete, new LinkOption[0]).toInstant();
        Intrinsics.checkNotNull((Object)lastModifiedTime);
        boolean isExpired = DateTimes.INSTANCE.isExpired(lastModifiedTime, expiry);
        if (!isExpired) {
            return;
        }
        boolean hasSiblingPidFile = Files.exists(dirToDelete.resolveSibling(PID_FILE_NAME), new LinkOption[0]);
        if (!hasSiblingPidFile) {
            return;
        }
        try {
            FileUtils.deleteQuietly((File)dirToDelete.toFile());
        }
        catch (IOException e) {
            logger.warn("Failed to delete directory | {} | {}", (Object)e.getMessage(), (Object)dirToDelete);
        }
        if (Files.exists(dirToDelete, new LinkOption[0])) {
            logger.error("Browser data dir not deleted | {}", (Object)dirToDelete);
        } else {
            cleanedUserDataDirs.add(dirToDelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Path computeNextSequentialContextDir0(String group, Fingerprint fingerprint, int maxAgents, FileChannel channel) throws IOException {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (!channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22 = false;
            String $i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$computeNextSequentialContextDir0$22.toString());
        }
        String prefix = CONTEXT_DIR_PREFIX;
        Path contextBaseDir = AppPaths.INSTANCE.getContextBaseDir(group, fingerprint.getBrowserType());
        Iterable iterable = (Iterable)new IntRange(1, maxAgents);
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            String string = "%s%s";
            Object[] objectArray = new Object[]{prefix, (int)it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            collection.add(string2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(contextBaseDir.resolve(it));
        }
        List expectedContextPaths = (List)destination$iv$iv;
        Iterable $this$filter$iv = expectedContextPaths;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        ContextGroup contextGroup2 = contextGroups.computeIfAbsent(group, arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$22((Function1)new Function1<String, ContextGroup>(group){
            final /* synthetic */ String $group;
            {
                this.$group = $group;
                super(1);
            }

            @NotNull
            public final ContextGroup invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ContextGroup(this.$group);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)contextGroup2, (String)"computeIfAbsent(...)");
        ContextGroup contextGroup3 = contextGroup2;
        Files.list(contextBaseDir).filter(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$23(computeNextSequentialContextDir0.4.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$24((Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }, arg_0)).filter(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$25((Function1)new Function1<Path, Boolean>((List<? extends Path>)expectedContextPaths){
            final /* synthetic */ List<Path> $expectedContextPaths;
            {
                this.$expectedContextPaths = $expectedContextPaths;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return this.$expectedContextPaths.contains(it);
            }
        }, arg_0)).forEach(arg_0 -> BrowserFiles.computeNextSequentialContextDir0$lambda$26((Function1)new Function1<Path, Unit>(contextGroup3){
            final /* synthetic */ ContextGroup $contextGroup;
            {
                this.$contextGroup = $contextGroup;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNull((Object)it);
                this.$contextGroup.add(it);
            }
        }, arg_0));
        return contextGroup3.getIterator().next();
    }

    private final Path computeRandomContextDir0(String group, FileChannel channel) throws IOException {
        if (channel != null && !channel.isOpen()) {
            boolean $i$a$-require-BrowserFiles$computeRandomContextDir0$22 = false;
            String $i$a$-require-BrowserFiles$computeRandomContextDir0$22 = "The lock file channel is closed";
            throw new IllegalArgumentException($i$a$-require-BrowserFiles$computeRandomContextDir0$22.toString());
        }
        String prefix = CONTEXT_DIR_PREFIX;
        MonthDay monthDay = MonthDay.now();
        int monthValue = monthDay.getMonthValue();
        int dayOfMonth = monthDay.getDayOfMonth();
        Path baseDir = AppPaths.INSTANCE.getTmpContextGroupDir(group);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        String rand = RandomStringUtils.randomAlphanumeric((int)5);
        Intrinsics.checkNotNull((Object)baseDir);
        long contextCount = this.computeContextCount(baseDir, prefix, channel);
        String string = "%s%02d%02d%s%s";
        Object[] objectArray = new Object[]{prefix, monthValue, dayOfMonth, rand, contextCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String fileName = string2;
        Path path = baseDir.resolve(fileName);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    static /* synthetic */ Path computeRandomContextDir0$default(BrowserFiles browserFiles, String string, FileChannel fileChannel, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            fileChannel = null;
        }
        return browserFiles.computeRandomContextDir0(string, fileChannel);
    }

    @NotNull
    public final Path getContextGroupDirLockFile(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Path lockFile = AppPaths.INSTANCE.getContextGroupDir(group).resolve(CONTEXT_LOCK_NAME);
        Intrinsics.checkNotNull((Object)lockFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(lockFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(lockFile.getParent(), new FileAttribute[0]);
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        return lockFile;
    }

    @NotNull
    public final Path getTempContextGroupDirLockFile(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Path lockFile = AppPaths.INSTANCE.getTmpContextGroupDir(group).resolve(CONTEXT_LOCK_NAME);
        Intrinsics.checkNotNull((Object)lockFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(lockFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(lockFile.getParent(), new FileAttribute[0]);
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        return lockFile;
    }

    @NotNull
    public final Path getContextGroupLockFileFromUserDataDir(@NotNull Path userDataDir) {
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Path contextBaseDir = userDataDir.getParent();
        Path groupDir = contextBaseDir.getParent();
        Path lockFile = groupDir.resolveSibling(CONTEXT_LOCK_NAME);
        Intrinsics.checkNotNull((Object)lockFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(lockFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(lockFile.getParent(), new FileAttribute[0]);
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        return lockFile;
    }

    private final long computeContextCount(Path baseDir, String prefix, FileChannel channel) {
        if (channel != null && !channel.isOpen()) {
            boolean bl = false;
            String string = "The lock file channel is closed";
            throw new IllegalArgumentException(string.toString());
        }
        return 1L + Files.list(baseDir).filter(arg_0 -> BrowserFiles.computeContextCount$lambda$29(computeContextCount.2.INSTANCE, arg_0)).filter(arg_0 -> BrowserFiles.computeContextCount$lambda$30((Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return StringsKt.contains$default((CharSequence)((Object)it).toString(), (CharSequence)this.$prefix, (boolean)false, (int)2, null);
            }
        }, arg_0)).count();
    }

    static /* synthetic */ long computeContextCount$default(BrowserFiles browserFiles, Path path, String string, FileChannel fileChannel, int n, Object object) {
        if ((n & 4) != 0) {
            fileChannel = null;
        }
        return browserFiles.computeContextCount(path, string, fileChannel);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanOldestContextTmpDirs$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextTmpDir$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanUpContextTmpDir$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean cleanUpContextDir$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanUpContextDir$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ContextGroup computeNextSequentialContextDir0$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ContextGroup)$tmp0.invoke(p0);
    }

    private static final boolean computeNextSequentialContextDir0$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean computeNextSequentialContextDir0$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean computeNextSequentialContextDir0$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void computeNextSequentialContextDir0$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean computeContextCount$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean computeContextCount$lambda$30(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$computeNextSequentialContextDir0(BrowserFiles $this, String group, Fingerprint fingerprint, int maxAgents, FileChannel channel) {
        return $this.computeNextSequentialContextDir0(group, fingerprint, maxAgents, channel);
    }

    public static final /* synthetic */ Path access$computeRandomContextDir0(BrowserFiles $this, String group, FileChannel channel) {
        return $this.computeRandomContextDir0(group, channel);
    }

    public static final /* synthetic */ ConcurrentSkipListSet access$getCleanedUserDataDirs$p() {
        return cleanedUserDataDirs;
    }

    public static final /* synthetic */ void access$deleteTemporaryUserDataDir0(BrowserFiles $this, Path userDataDir, Duration expiry, FileChannel channel) {
        $this.deleteTemporaryUserDataDir0(userDataDir, expiry, channel);
    }
}

