/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.browser;

import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.WebsiteAccount;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001=B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000H\u0096\u0002J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JM\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u00101\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u000102H\u0096\u0002J\u0006\u00103\u001a\u00020\u0017J\b\u00104\u001a\u00020)H\u0016J\u000e\u00105\u001a\u0002062\u0006\u0010\b\u001a\u00020\tJ*\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\b\u00109\u001a\u0004\u0018\u00010\u00052\b\u0010:\u001a\u0004\u0018\u00010\u0005J\b\u0010;\u001a\u00020\u0005H\u0016J\u0006\u0010<\u001a\u000206R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u0005 \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\t8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006>"}, d2={"Lai/platon/pulsar/common/browser/Fingerprint;", "", "browserType", "Lai/platon/pulsar/common/browser/BrowserType;", "proxyURI", "", "userAgent", "(Lai/platon/pulsar/common/browser/BrowserType;Ljava/lang/String;Ljava/lang/String;)V", "proxy", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "(Lai/platon/pulsar/common/browser/BrowserType;Lai/platon/pulsar/common/proxy/ProxyEntry;Ljava/lang/String;)V", "Ljava/net/URI;", "websiteAccounts", "", "Lai/platon/pulsar/common/browser/WebsiteAccount;", "source", "(Lai/platon/pulsar/common/browser/BrowserType;Ljava/net/URI;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getBrowserType", "()Lai/platon/pulsar/common/browser/BrowserType;", "comp", "Ljava/util/Comparator;", "kotlin.jvm.PlatformType", "isLoaded", "", "()Z", "proxyEntry", "getProxyEntry", "()Lai/platon/pulsar/common/proxy/ProxyEntry;", "getProxyURI", "()Ljava/net/URI;", "setProxyURI", "(Ljava/net/URI;)V", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "getUserAgent", "setUserAgent", "getWebsiteAccounts", "()Ljava/util/Map;", "compareTo", "", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "hasProxy", "hashCode", "setProxy", "", "protocol", "hostPort", "username", "password", "toString", "unsetProxy", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nFingerprint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fingerprint.kt\nai/platon/pulsar/common/browser/Fingerprint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1855#3,2:147\n1726#3,3:149\n*S KotlinDebug\n*F\n+ 1 Fingerprint.kt\nai/platon/pulsar/common/browser/Fingerprint\n*L\n106#1:147,2\n126#1:149,3\n*E\n"})
public final class Fingerprint
implements Comparable<Fingerprint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserType browserType;
    @Nullable
    private URI proxyURI;
    @Nullable
    private String userAgent;
    @NotNull
    private final Map<String, WebsiteAccount> websiteAccounts;
    @Nullable
    private String source;
    private final Comparator<String> comp;
    @NotNull
    private static final Fingerprint DEFAULT = new Fingerprint(BrowserType.PULSAR_CHROME, null, null, null, null, 30, null);
    @NotNull
    private static final String EXAMPLE_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3";
    @NotNull
    private static final Fingerprint EXAMPLE = new Fingerprint(BrowserType.PULSAR_CHROME, new URI("http://localhost:8080"), EXAMPLE_USER_AGENT, null, null, 24, null);

    public Fingerprint(@NotNull BrowserType browserType, @Nullable URI proxyURI, @Nullable String userAgent, @NotNull Map<String, WebsiteAccount> websiteAccounts, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)browserType), (String)"browserType");
        Intrinsics.checkNotNullParameter(websiteAccounts, (String)"websiteAccounts");
        this.browserType = browserType;
        this.proxyURI = proxyURI;
        this.userAgent = userAgent;
        this.websiteAccounts = websiteAccounts;
        this.source = source;
        this.comp = ComparatorUtils.nullLowComparator(Fingerprint::comp$lambda$0);
    }

    public /* synthetic */ Fingerprint(BrowserType browserType, URI uRI, String string, Map map, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(browserType, uRI, string, map, string2);
    }

    @NotNull
    public final BrowserType getBrowserType() {
        return this.browserType;
    }

    @Nullable
    public final URI getProxyURI() {
        return this.proxyURI;
    }

    public final void setProxyURI(@Nullable URI uRI) {
        this.proxyURI = uRI;
    }

    @Nullable
    public final String getUserAgent() {
        return this.userAgent;
    }

    public final void setUserAgent(@Nullable String string) {
        this.userAgent = string;
    }

    @NotNull
    public final Map<String, WebsiteAccount> getWebsiteAccounts() {
        return this.websiteAccounts;
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    public final void setSource(@Nullable String string) {
        this.source = string;
    }

    @JsonIgnore
    public final boolean isLoaded() {
        return this.source != null;
    }

    @JsonIgnore
    @Nullable
    public final ProxyEntry getProxyEntry() {
        ProxyEntry proxyEntry;
        URI uRI = this.proxyURI;
        if (uRI != null) {
            URI it = uRI;
            boolean bl = false;
            proxyEntry = ProxyEntry.Companion.fromURI(it);
        } else {
            proxyEntry = null;
        }
        return proxyEntry;
    }

    public Fingerprint(@NotNull BrowserType browserType, @NotNull String proxyURI, @Nullable String userAgent) {
        Intrinsics.checkNotNullParameter((Object)((Object)browserType), (String)"browserType");
        Intrinsics.checkNotNullParameter((Object)proxyURI, (String)"proxyURI");
        this(browserType, new URI(proxyURI), userAgent, null, null, 24, null);
    }

    public /* synthetic */ Fingerprint(BrowserType browserType, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(browserType, string, string2);
    }

    public Fingerprint(@NotNull BrowserType browserType, @NotNull ProxyEntry proxy, @Nullable String userAgent) {
        Intrinsics.checkNotNullParameter((Object)((Object)browserType), (String)"browserType");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this(browserType, proxy.toURI(), userAgent, null, null, 24, null);
    }

    public /* synthetic */ Fingerprint(BrowserType browserType, ProxyEntry proxyEntry, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(browserType, proxyEntry, string);
    }

    public final boolean hasProxy() {
        return this.proxyURI != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProxy(@NotNull String protocol, @NotNull String hostPort, @Nullable String username, @Nullable String password) {
        void $this$setProxy_u24lambda_u242;
        URIBuilder uRIBuilder;
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        URIBuilder uRIBuilder2 = uRIBuilder = new URIBuilder();
        Fingerprint fingerprint = this;
        boolean bl = false;
        $this$setProxy_u24lambda_u242.setScheme(protocol);
        $this$setProxy_u24lambda_u242.setHost(hostPort);
        if (username != null && password != null) {
            $this$setProxy_u24lambda_u242.setUserInfo(username + ":" + password);
        }
        fingerprint.proxyURI = uRIBuilder.build();
    }

    public final void setProxy(@NotNull ProxyEntry proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.setProxy(proxy.getProtocol(), proxy.getHostPort(), proxy.getUsername(), proxy.getPassword());
    }

    public final void unsetProxy() {
        this.proxyURI = null;
    }

    @Override
    public int compareTo(@NotNull Fingerprint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int r = 0;
        Object[] objectArray = new Pair[3];
        objectArray[0] = TuplesKt.to((Object)this.browserType.name(), (Object)other.browserType.name());
        URI uRI = this.proxyURI;
        URI uRI2 = other.proxyURI;
        objectArray[1] = TuplesKt.to((Object)(uRI != null ? uRI.toString() : null), (Object)(uRI2 != null ? uRI2.toString() : null));
        objectArray[2] = TuplesKt.to((Object)this.userAgent, (Object)other.userAgent);
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            r = this.comp.compare((String)it.getFirst(), (String)it.getSecond());
            if (r == 0) continue;
            return r;
        }
        return r;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Pair it;
        if (!(other instanceof Fingerprint)) return false;
        Object[] objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)((Object)this.browserType), (Object)((Object)((Fingerprint)other).browserType));
        URI uRI = this.proxyURI;
        URI uRI2 = ((Fingerprint)other).proxyURI;
        objectArray[1] = TuplesKt.to((Object)(uRI != null ? uRI.toString() : null), (Object)(uRI2 != null ? uRI2.toString() : null));
        Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()));
        return false;
    }

    @NotNull
    public String toString() {
        Object[] objectArray = new Object[]{this.browserType, this.proxyURI};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public final BrowserType component1() {
        return this.browserType;
    }

    @Nullable
    public final URI component2() {
        return this.proxyURI;
    }

    @Nullable
    public final String component3() {
        return this.userAgent;
    }

    @NotNull
    public final Map<String, WebsiteAccount> component4() {
        return this.websiteAccounts;
    }

    @Nullable
    public final String component5() {
        return this.source;
    }

    @NotNull
    public final Fingerprint copy(@NotNull BrowserType browserType, @Nullable URI proxyURI, @Nullable String userAgent, @NotNull Map<String, WebsiteAccount> websiteAccounts, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)browserType), (String)"browserType");
        Intrinsics.checkNotNullParameter(websiteAccounts, (String)"websiteAccounts");
        return new Fingerprint(browserType, proxyURI, userAgent, websiteAccounts, source);
    }

    public static /* synthetic */ Fingerprint copy$default(Fingerprint fingerprint, BrowserType browserType, URI uRI, String string, Map map, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            browserType = fingerprint.browserType;
        }
        if ((n & 2) != 0) {
            uRI = fingerprint.proxyURI;
        }
        if ((n & 4) != 0) {
            string = fingerprint.userAgent;
        }
        if ((n & 8) != 0) {
            map = fingerprint.websiteAccounts;
        }
        if ((n & 0x10) != 0) {
            string2 = fingerprint.source;
        }
        return fingerprint.copy(browserType, uRI, string, map, string2);
    }

    private static final int comp$lambda$0(String o1, String o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return o1.compareTo(o2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/common/browser/Fingerprint$Companion;", "", "()V", "DEFAULT", "Lai/platon/pulsar/common/browser/Fingerprint;", "getDEFAULT", "()Lai/platon/pulsar/common/browser/Fingerprint;", "EXAMPLE", "getEXAMPLE", "EXAMPLE_USER_AGENT", "", "getEXAMPLE_USER_AGENT", "()Ljava/lang/String;", "fromJson", "json", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Fingerprint getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final String getEXAMPLE_USER_AGENT() {
            return EXAMPLE_USER_AGENT;
        }

        @NotNull
        public final Fingerprint getEXAMPLE() {
            return EXAMPLE;
        }

        @NotNull
        public final Fingerprint fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object = JacksonKt.pulsarObjectMapper().readValue(json, Fingerprint.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (Fingerprint)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

