/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.DelayUrl;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.UrlAware;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0016J\u0016\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020207H\u0016J\u001e\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0016072\u0006\u00103\u001a\u000204H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0000H\u0002J\b\u0010;\u001a\u000200H\u0016J\b\u0010<\u001a\u000209H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0014\u0010!\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0014\u0010'\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\nR\u0014\u0010)\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006="}, d2={"Lai/platon/pulsar/common/collect/AbstractUrlPool;", "Lai/platon/pulsar/common/collect/UrlPool;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "higher2Cache", "Lai/platon/pulsar/common/collect/UrlCache;", "getHigher2Cache", "()Lai/platon/pulsar/common/collect/UrlCache;", "higher3Cache", "getHigher3Cache", "higher4Cache", "getHigher4Cache", "higher5Cache", "getHigher5Cache", "higherCache", "getHigherCache", "highestCache", "getHighestCache", "id", "", "getId", "()Ljava/lang/String;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "lower2Cache", "getLower2Cache", "lower3Cache", "getLower3Cache", "lower4Cache", "getLower4Cache", "lower5Cache", "getLower5Cache", "lowerCache", "getLowerCache", "lowestCache", "getLowestCache", "normalCache", "getNormalCache", "totalCount", "", "getTotalCount", "()I", "add", "", "url", "Lai/platon/pulsar/common/urls/UrlAware;", "priority", "Lai/platon/pulsar/common/Priority13;", "addAll", "urls", "", "clear", "", "ensureInitialized", "hasMore", "removeDeceased", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPool.kt\nai/platon/pulsar/common/collect/AbstractUrlPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1#2:290\n1549#3:291\n1620#3,3:292\n1855#3,2:295\n1855#3,2:297\n1855#3,2:299\n*S KotlinDebug\n*F\n+ 1 UrlPool.kt\nai/platon/pulsar/common/collect/AbstractUrlPool\n*L\n210#1:291\n210#1:292,3\n215#1:295,2\n227#1:297,2\n228#1:299,2\n*E\n"})
public abstract class AbstractUrlPool
implements UrlPool {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final String id;

    public AbstractUrlPool(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.initialized = new AtomicBoolean();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    protected final AtomicBoolean getInitialized() {
        return this.initialized;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public int getTotalCount() {
        int n;
        UrlCache it;
        int n2;
        Iterable iterable = this.ensureInitialized().getOrderedCaches().values();
        int n3 = 0;
        for (Object t : iterable) {
            UrlCache urlCache2 = (UrlCache)t;
            n2 = n3;
            boolean bl = false;
            n = it.getSize();
            n3 = n2 + n;
        }
        int a = n3;
        iterable = this.getUnorderedCaches();
        n2 = a + this.getRealTimeCache().getSize() + this.getDelayCache().size();
        n3 = 0;
        for (Object t : iterable) {
            it = (UrlCache)t;
            n = n3;
            boolean bl = false;
            int n4 = it.getSize();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    @Override
    @NotNull
    public UrlCache getLowestCache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWEST.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getLower5Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWER5.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getLower4Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWER4.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getLower3Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWER3.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getLower2Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWER2.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getLowerCache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.LOWER.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getNormalCache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.NORMAL.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHigherCache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHER.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHigher2Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHER2.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHigher3Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHER3.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHigher4Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHER4.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHigher5Cache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHER5.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    @NotNull
    public UrlCache getHighestCache() {
        UrlCache urlCache2 = this.ensureInitialized().getOrderedCaches().get(Priority13.HIGHEST.getValue());
        Intrinsics.checkNotNull((Object)urlCache2);
        return urlCache2;
    }

    @Override
    public boolean add(@NotNull String url, @NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Hyperlink link = new Hyperlink(url, "", 0, null, null, null, priority.getValue(), null, null, null, 0, 0, 4028, null);
        return this.add(link);
    }

    @Override
    public boolean add(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int priority = Priority13.Companion.lowerPriority(url.getPriority()).getValue();
        Object object = this.getOrderedCaches().get(priority);
        Boolean added = object != null && (object = object.getReentrantQueue()) != null ? Boolean.valueOf(object.add(url)) : null;
        return Intrinsics.areEqual((Object)added, (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(@NotNull Iterable<String> urls, @NotNull Priority13 priority) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Iterable<String> iterable = urls;
        AbstractUrlPool abstractUrlPool = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Hyperlink((String)it));
        }
        return abstractUrlPool.addAll((List)destination$iv$iv);
    }

    @Override
    public boolean addAll(@NotNull Iterable<? extends UrlAware> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        int count2 = 0;
        Iterable<? extends UrlAware> $this$forEach$iv = urls;
        boolean $i$f$forEach = false;
        Iterator<? extends UrlAware> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            UrlAware element$iv;
            UrlAware it = element$iv = iterator.next();
            boolean bl = false;
            int priority = Priority13.Companion.lowerPriority(it.getPriority()).getValue();
            Object object = this.getOrderedCaches().get(priority);
            Boolean added = object != null && (object = object.getReentrantQueue()) != null ? Boolean.valueOf(object.add(it)) : null;
            if (!Intrinsics.areEqual((Object)added, (Object)true)) continue;
            ++count2;
        }
        return count2 > 0;
    }

    @Override
    public void removeDeceased() {
        UrlCache it;
        this.ensureInitialized();
        Iterable $this$forEach$iv = this.getOrderedCaches().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (UrlCache)element$iv;
            boolean bl = false;
            it.removeDeceased();
        }
        $this$forEach$iv = this.getUnorderedCaches();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (UrlCache)element$iv;
            boolean bl = false;
            it.removeDeceased();
        }
        Instant now = Instant.now();
        this.getDelayCache().removeIf(arg_0 -> AbstractUrlPool.removeDeceased$lambda$6((Function1)new Function1<DelayUrl, Boolean>(now){
            final /* synthetic */ Instant $now;
            {
                this.$now = $now;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DelayUrl it) {
                return it.getUrl().getDeadline().compareTo(this.$now) < 0;
            }
        }, arg_0));
    }

    @Override
    public void clear() {
        this.getOrderedCaches().clear();
        this.getUnorderedCaches().clear();
        this.getRealTimeCache().clear();
        this.getDelayCache().clear();
    }

    @Override
    public boolean hasMore() {
        return this.getTotalCount() > 0;
    }

    private final AbstractUrlPool ensureInitialized() {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
        return this;
    }

    private static final boolean removeDeceased$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

