/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001%BK\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010!\u001a\u00020\u001dJ\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0096\u0002J\u0006\u0010$\u001a\u00020\u001dR2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00018\u00008\u0000 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006&"}, d2={"Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable;", "E", "", "regularCollector", "Lai/platon/pulsar/common/collect/collector/DataCollector;", "realTimeCollector", "delayCollector", "lowerCacheSize", "", "upperCacheSize", "(Lai/platon/pulsar/common/collect/collector/DataCollector;Lai/platon/pulsar/common/collect/collector/DataCollector;Lai/platon/pulsar/common/collect/collector/DataCollector;II)V", "cache", "", "kotlin.jvm.PlatformType", "", "cacheSize", "getCacheSize", "()I", "getDelayCollector", "()Lai/platon/pulsar/common/collect/collector/DataCollector;", "estimatedSize", "getEstimatedSize", "getLowerCacheSize", "getRealTimeCollector", "getRegularCollector", "size", "getSize", "getUpperCacheSize", "addFirst", "", "e", "(Ljava/lang/Object;)V", "addLast", "clear", "iterator", "Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable$LoadingIterator;", "shuffle", "LoadingIterator", "pulsar-common"})
public class ConcurrentLoadingIterable<E>
implements Iterable<E>,
KMappedMarker {
    @NotNull
    private final DataCollector<E> regularCollector;
    @Nullable
    private final DataCollector<E> realTimeCollector;
    @Nullable
    private final DataCollector<E> delayCollector;
    private final int lowerCacheSize;
    private final int upperCacheSize;
    private final List<E> cache;

    public ConcurrentLoadingIterable(@NotNull DataCollector<E> regularCollector, @Nullable DataCollector<E> realTimeCollector, @Nullable DataCollector<E> delayCollector, int lowerCacheSize, int upperCacheSize) {
        Intrinsics.checkNotNullParameter(regularCollector, (String)"regularCollector");
        this.regularCollector = regularCollector;
        this.realTimeCollector = realTimeCollector;
        this.delayCollector = delayCollector;
        this.lowerCacheSize = lowerCacheSize;
        this.upperCacheSize = upperCacheSize;
        this.cache = Collections.synchronizedList(new LinkedList());
    }

    public /* synthetic */ ConcurrentLoadingIterable(DataCollector dataCollector, DataCollector dataCollector2, DataCollector dataCollector3, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            dataCollector2 = null;
        }
        if ((n3 & 4) != 0) {
            dataCollector3 = null;
        }
        if ((n3 & 8) != 0) {
            n = 20;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 1000000;
        }
        this(dataCollector, dataCollector2, dataCollector3, n, n2);
    }

    @NotNull
    public final DataCollector<E> getRegularCollector() {
        return this.regularCollector;
    }

    @Nullable
    public final DataCollector<E> getRealTimeCollector() {
        return this.realTimeCollector;
    }

    @Nullable
    public final DataCollector<E> getDelayCollector() {
        return this.delayCollector;
    }

    public final int getLowerCacheSize() {
        return this.lowerCacheSize;
    }

    public final int getUpperCacheSize() {
        return this.upperCacheSize;
    }

    public final int getCacheSize() {
        return this.cache.size();
    }

    public final int getSize() {
        DataCollector<E> dataCollector = this.realTimeCollector;
        DataCollector<E> dataCollector2 = this.delayCollector;
        return this.regularCollector.getSize() + (dataCollector != null ? dataCollector.getSize() : 0) + (dataCollector2 != null ? dataCollector2.getSize() : 0) + this.getCacheSize();
    }

    public final int getEstimatedSize() {
        DataCollector<E> dataCollector = this.realTimeCollector;
        DataCollector<E> dataCollector2 = this.delayCollector;
        return this.regularCollector.getEstimatedSize() + (dataCollector != null ? dataCollector.getEstimatedSize() : 0) + (dataCollector2 != null ? dataCollector2.getEstimatedSize() : 0) + this.getCacheSize();
    }

    @Override
    @NotNull
    public LoadingIterator<E> iterator() {
        return new LoadingIterator(this);
    }

    public final void addFirst(E e) {
        this.cache.add(0, e);
    }

    public final void addLast(E e) {
        this.cache.add(e);
    }

    public final void shuffle() {
        List<E> list2 = this.cache;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"cache");
        Collections.shuffle(list2);
    }

    public final void clear() {
        DataCollector<E> dataCollector = this.realTimeCollector;
        if (dataCollector != null) {
            dataCollector.clear();
        }
        DataCollector<E> dataCollector2 = this.delayCollector;
        if (dataCollector2 != null) {
            dataCollector2.clear();
        }
        this.regularCollector.clear();
        this.cache.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R2\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00018\u0001 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00018\u0001\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable$LoadingIterator;", "E", "", "iterable", "Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable;", "(Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable;)V", "cache", "", "kotlin.jvm.PlatformType", "", "delayCollector", "Lai/platon/pulsar/common/collect/collector/DataCollector;", "realTimeCollector", "regularCollector", "hasNext", "", "next", "()Ljava/lang/Object;", "tryLoad", "", "pulsar-common"})
    public static final class LoadingIterator<E>
    implements Iterator<E>,
    KMappedMarker {
        @NotNull
        private final ConcurrentLoadingIterable<E> iterable;
        @NotNull
        private final DataCollector<E> regularCollector;
        @Nullable
        private final DataCollector<E> realTimeCollector;
        @Nullable
        private final DataCollector<E> delayCollector;
        private final List<E> cache;

        public LoadingIterator(@NotNull ConcurrentLoadingIterable<E> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            this.iterable = iterable;
            this.regularCollector = this.iterable.getRegularCollector();
            this.realTimeCollector = this.iterable.getRealTimeCollector();
            this.delayCollector = this.iterable.getDelayCollector();
            this.cache = ((ConcurrentLoadingIterable)this.iterable).cache;
        }

        public final synchronized void tryLoad() {
            if (this.regularCollector.hasMore() && this.cache.size() < this.iterable.getLowerCacheSize()) {
                List<E> list2 = this.cache;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"cache");
                this.regularCollector.collectTo(list2);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            try {
                if (this.realTimeCollector != null && this.realTimeCollector.hasMore()) {
                    List<E> list2 = this.cache;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"cache");
                    this.realTimeCollector.collectTo(0, list2);
                }
                if (this.delayCollector != null && this.delayCollector.hasMore()) {
                    List<E> list3 = this.cache;
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"cache");
                    this.delayCollector.collectTo(0, list3);
                }
                while (this.cache.isEmpty() && this.regularCollector.hasMore()) {
                    this.tryLoad();
                }
                List<E> list4 = this.cache;
                Intrinsics.checkNotNullExpressionValue(list4, (String)"cache");
                return !((Collection)list4).isEmpty();
            }
            catch (Throwable e) {
                LogsKt.getLogger(this).warn("[Unexpected]", e);
                return false;
            }
        }

        @Override
        public synchronized E next() {
            E e = this.cache.remove(0);
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

