/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.measure.ByteUnit;
import java.awt.Dimension;
import java.time.Duration;
import java.time.Instant;

public interface AppConstants {
    public static final String PULSAR_CONTEXT_CONFIG_LOCATION = "classpath*:/pulsar-beans/app-context.xml";
    public static final String SCENT_CONTEXT_CONFIG_LOCATION = "classpath*:/scent-beans/app-context.xml";
    public static final String YES_STRING = "y";
    public static final String CACHING_FORBIDDEN_CONTENT = "content";
    public static final String ALL_BATCHES = "all";
    public static final String ALL_BATCH_ID_STR = "-all";
    public static final Character UNICODE_FIRST_CODE_POINT = Character.valueOf('\u0001');
    public static final Character UNICODE_LAST_CODE_POINT = Character.valueOf('\uffff');
    public static final String SHORTEST_VALID_URL = "http://t.tt";
    public static final int SHORTEST_VALID_URL_LENGTH = "http://t.tt".length();
    public static final String EXAMPLE_URL = "http://example.com";
    public static final String INTERNAL_URL_PREFIX = "http://internal.pulsar.platon.ai";
    public static final String EMPTY_PAGE_URL = "http://internal.pulsar.platon.ai/empty";
    public static final String NIL_PAGE_URL = "http://internal.pulsar.platon.ai/nil";
    public static final String SEED_HOME_URL = "http://internal.pulsar.platon.ai/seeds";
    public static final String SEED_PAGE_1_URL = "http://internal.pulsar.platon.ai/seeds/1";
    public static final String URL_TRACKER_HOME_URL = "http://internal.pulsar.platon.ai/url/tracker";
    public static final String MEM_STORE_CLASS = "org.apache.gora.memory.store.MemStore";
    public static final String FILE_BACKEND_STORE_CLASS = "ai.platon.pulsar.persist.gora.FileBackendPageStore";
    public static final String MONGO_STORE_CLASS = "org.apache.gora.mongodb.store.MongoStore";
    public static final String HBASE_STORE_CLASS = "org.apache.gora.hbase.store.HBaseStore";
    public static final String WEBPAGE_SCHEMA = "webpage120";
    public static final int DISTANCE_INFINITE = 10000;
    public static final int FETCH_PRIORITY_MIN = -100000;
    public static final int FETCH_PRIORITY_DEFAULT = 10000;
    public static final int FETCH_PRIORITY_DEPTH_BASE = 20000;
    public static final Duration FETCH_TASK_TIMEOUT_DEFAULT = Duration.ofMinutes(10L);
    public static final int PERM_REFRESH_TIME = 5;
    public static final Instant TCP_IP_STANDARDIZED_TIME = Instant.parse("1982-01-01T00:00:00Z");
    public static final Instant MIN_ARTICLE_PUBLISH_TIME = Instant.parse("1995-01-01T00:00:00Z");
    public static final Duration DEFAULT_MAX_PARSE_TIME = Duration.ofSeconds(60L);
    public static final int MAX_LIVE_LINK_PER_PAGE = 1000;
    public static final int MAX_LINK_PER_PAGE = 4000;
    public static final String CMD_FORCE_GENERATE_SEEDS = "force-generate-seeds";
    public static final String CMD_PROXY_POOL_DUMP = "dump-proxy-pool";
    public static final String CMD_PROXY_FORCE_IDLE = "IPS-force-idle";
    public static final String CMD_PROXY_RECONNECT = "IPS-reconnect";
    public static final String CMD_PROXY_DISCONNECT = "IPS-disconnect";
    public static final int DEFAULT_BROWSER_MAX_ACTIVE_TABS = 8;
    public static final double BROWSER_TAB_REQUIRED_MEMORY = ByteUnit.GIB.toBytes(1.5);
    public static final double DEFAULT_BROWSER_RESERVED_MEMORY = ByteUnit.GIB.toBytes(2.0);
    public static final double DEFAULT_BROWSER_RESERVED_MEMORY_MIB = ByteUnit.BYTE.toMiB(DEFAULT_BROWSER_RESERVED_MEMORY);
    public static final Dimension DEFAULT_VIEW_PORT = new Dimension(1920, 1080);
    public static final String PULSAR_META_INFORMATION_ID = "PulsarMetaInformation";
    public static final String PULSAR_META_INFORMATION_SELECTOR = "#PulsarMetaInformation";
    public static final String PULSAR_SCRIPT_SECTION_ID = "PulsarScriptSection";
    public static final String PULSAR_SCRIPT_SECTION_SELECTOR = "#PulsarScriptSection";
    public static final String PULSAR_DOCUMENT_NORMALIZED_URI = "normalizedURI";
    public static final String PULSAR_ATTR_HIDDEN = "_h";
    public static final String PULSAR_ATTR_OVERFLOW_HIDDEN = "_oh";
    public static final String PULSAR_ATTR_OVERFLOW_VISIBLE = "_visible";
    public static final String PULSAR_ATTR_ELEMENT_NODE_VI = "vi";
    public static final String PULSAR_ATTR_TEXT_NODE_VI = "tv";
    @Deprecated
    public static final String PULSAR_ATTR_ELEMENT_NODE_STYLE = "st";
    public static final String PULSAR_ATTR_COMPUTED_STYLE = "cs";
    public static final String CLIENT_JS_PROPERTY_NAMES = "font-size, color, background-color";
    public static final String DEFAULT_METRICS_NAME = "pulsar";
    public static final String H2_SESSION_FACTORY = "ai.platon.pulsar.ql.h2.H2SessionFactory";
    public static final String LOCAL_FILE_BASE_URL = "http://localfile.org";
    @Deprecated
    public static final String LOCAL_FILE_SERVE_PREFIX = "http://localfile.org";
    public static final String BROWSER_SPECIFIC_URL_PREFIX = "http://browser-specific.org";
}

