/*
 * Decompiled with CFR 0.152.
 */
package org.h2.api;

import java.io.Serializable;
import org.h2.util.DateTimeUtils;

public class TimestampWithTimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4413229090646777107L;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    public TimestampWithTimeZone(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
        this.timeZoneOffsetMins = timeZoneOffsetMins;
    }

    public long getYMD() {
        return this.dateValue;
    }

    public int getYear() {
        return DateTimeUtils.yearFromDateValue(this.dateValue);
    }

    public int getMonth() {
        return DateTimeUtils.monthFromDateValue(this.dateValue);
    }

    public int getDay() {
        return DateTimeUtils.dayFromDateValue(this.dateValue);
    }

    public long getNanosSinceMidnight() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    public String toString() {
        return DateTimeUtils.timestampTimeZoneToString(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.dateValue ^ this.dateValue >>> 32);
        result = 31 * result + (int)(this.timeNanos ^ this.timeNanos >>> 32);
        result = 31 * result + this.timeZoneOffsetMins;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampWithTimeZone other = (TimestampWithTimeZone)obj;
        if (this.dateValue != other.dateValue) {
            return false;
        }
        if (this.timeNanos != other.timeNanos) {
            return false;
        }
        return this.timeZoneOffsetMins == other.timeZoneOffsetMins;
    }
}

