/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.util.New;

public abstract class CommandWithColumns
extends SchemaCommand {
    private ArrayList<DefineCommand> constraintCommands;
    private IndexColumn[] pkColumns;

    protected CommandWithColumns(Session session, Schema schema) {
        super(session, schema);
    }

    public abstract void addColumn(Column var1);

    public void addConstraintCommand(DefineCommand command) {
        if (command instanceof CreateIndex) {
            this.getConstraintCommands().add(command);
        } else {
            AlterTableAddConstraint con = (AlterTableAddConstraint)command;
            boolean alreadySet = con.getType() == 6 ? this.setPrimaryKeyColumns(con.getIndexColumns()) : false;
            if (!alreadySet) {
                this.getConstraintCommands().add(command);
            }
        }
    }

    protected void changePrimaryKeysToNotNull(ArrayList<Column> columns) {
        if (this.pkColumns != null) {
            for (Column c : columns) {
                for (IndexColumn idxCol : this.pkColumns) {
                    if (!c.getName().equals(idxCol.columnName)) continue;
                    c.setNullable(false);
                }
            }
        }
    }

    protected void createConstraints() {
        if (this.constraintCommands != null) {
            for (DefineCommand command : this.constraintCommands) {
                command.setTransactional(this.transactional);
                command.update();
            }
        }
    }

    protected ArrayList<Sequence> generateSequences(ArrayList<Column> columns, boolean temporary) {
        ArrayList<Sequence> sequences = New.arrayList();
        if (columns != null) {
            for (Column c : columns) {
                Sequence seq;
                if (c.isAutoIncrement()) {
                    int objId = this.getObjectId();
                    c.convertAutoIncrementToSequence(this.session, this.getSchema(), objId, temporary);
                    if (!"''".equals(this.session.getDatabase().getCluster())) {
                        throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
                    }
                }
                if ((seq = c.getSequence()) == null) continue;
                sequences.add(seq);
            }
        }
        return sequences;
    }

    private ArrayList<DefineCommand> getConstraintCommands() {
        if (this.constraintCommands == null) {
            this.constraintCommands = New.arrayList();
        }
        return this.constraintCommands;
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] columns) {
        if (this.pkColumns != null) {
            int len = columns.length;
            if (len != this.pkColumns.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < len; ++i) {
                if (columns[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.pkColumns = columns;
        return false;
    }
}

