/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean orReplace;
    private boolean force;
    private boolean isTableExpression;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public void setSelect(Query select) {
        this.select = select;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }

    public void setColumnNames(String[] cols) {
        this.columnNames = cols;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setTableExpression(boolean isTableExpression) {
        this.isTableExpression = isTableExpression;
    }

    @Override
    public int update() {
        String querySQL;
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        TableView view = null;
        Table old = this.getSchema().findTableOrView(this.session, this.viewName);
        if (old != null) {
            if (this.ifNotExists) {
                return 0;
            }
            if (!this.orReplace || TableType.VIEW != old.getTableType()) {
                throw DbException.get(90038, this.viewName);
            }
            view = (TableView)old;
        }
        int id = this.getObjectId();
        if (this.select == null) {
            querySQL = this.selectSQL;
        } else {
            ArrayList<Parameter> params = this.select.getParameters();
            if (params != null && !params.isEmpty()) {
                throw DbException.getUnsupportedException("parameters in views");
            }
            querySQL = this.select.getPlanSQL();
        }
        Column[] columnTemplatesAsUnknowns = null;
        Column[] columnTemplatesAsStrings = null;
        if (this.columnNames != null) {
            columnTemplatesAsUnknowns = new Column[this.columnNames.length];
            columnTemplatesAsStrings = new Column[this.columnNames.length];
            for (int i = 0; i < this.columnNames.length; ++i) {
                columnTemplatesAsUnknowns[i] = new Column(this.columnNames[i], -1);
                columnTemplatesAsStrings[i] = new Column(this.columnNames[i], 13);
            }
        }
        if (view == null) {
            view = this.isTableExpression ? TableView.createTableViewMaybeRecursive(this.getSchema(), id, this.viewName, querySQL, null, columnTemplatesAsStrings, this.session, false, this.isTableExpression, true, db) : new TableView(this.getSchema(), id, this.viewName, querySQL, null, columnTemplatesAsUnknowns, this.session, false, false, this.isTableExpression, true);
        } else {
            view.replace(querySQL, columnTemplatesAsUnknowns, this.session, false, this.force, false);
            view.setModified();
        }
        if (this.comment != null) {
            view.setComment(this.comment);
        }
        if (old == null) {
            db.addSchemaObject(this.session, view);
            db.unlockMeta(this.session);
        } else {
            db.updateMeta(this.session, view);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 34;
    }
}

