/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private TableFilter sourceTableFilter;
    private Expression limitExpr;
    private final ArrayList<Column> columns = New.arrayList();
    private final HashMap<Column, Expression> expressionMap = new HashMap();

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.expressionMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.columns.add(column);
        this.expressionMap.put(column, expression);
        if (expression instanceof Parameter) {
            Parameter p = (Parameter)expression;
            p.setColumn(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        try (RowList rows = new RowList(this.session);){
            Value v;
            Table table = this.targetTableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            int columnCount = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int count = 0;
            Column[] columns = table.getColumns();
            int limitRows = -1;
            if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                limitRows = v.getInt();
            }
            while (this.targetTableFilter.next()) {
                int i;
                this.setCurrentRowNumber(count + 1);
                if (limitRows >= 0 && count >= limitRows) break;
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                Row oldRow = this.targetTableFilter.get();
                Row newRow = table.getTemplateRow();
                boolean setOnUpdate = false;
                for (i = 0; i < columnCount; ++i) {
                    Value newValue;
                    Expression newExpr = this.expressionMap.get(columns[i]);
                    Column column = table.getColumn(i);
                    if (newExpr == null) {
                        if (column.getOnUpdateExpression() != null) {
                            setOnUpdate = true;
                        }
                        newValue = oldRow.getValue(i);
                    } else {
                        newValue = newExpr == ValueExpression.getDefault() ? table.getDefaultValue(this.session, column) : column.convert(newExpr.getValue(this.session));
                    }
                    newRow.setValue(i, newValue);
                }
                if (setOnUpdate) {
                    setOnUpdate = false;
                    for (i = 0; i < columnCount; ++i) {
                        if (Objects.equals(oldRow.getValue(i), newRow.getValue(i))) continue;
                        setOnUpdate = true;
                        break;
                    }
                    if (setOnUpdate) {
                        for (i = 0; i < columnCount; ++i) {
                            Column column;
                            if (this.expressionMap.get(columns[i]) != null || (column = table.getColumn(i)).getOnUpdateExpression() == null) continue;
                            newRow.setValue(i, table.getOnUpdateValue(this.session, column));
                        }
                    }
                }
                table.validateConvertUpdateSequence(this.session, newRow);
                boolean done = false;
                if (table.fireRow()) {
                    done = table.fireBeforeRow(this.session, oldRow, newRow);
                }
                if (!done) {
                    rows.add(oldRow);
                    rows.add(newRow);
                }
                ++count;
            }
            table.updateRows(this, this.session, rows);
            if (table.fireRow()) {
                rows.invalidateCache();
                rows.reset();
                while (rows.hasNext()) {
                    Row o = rows.next();
                    Row n = rows.next();
                    table.fireAfterRow(this.session, o, n, false);
                }
            }
            table.fire(this.session, 2, false);
            int n = count;
            return n;
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.targetTableFilter.getPlanSQL(false)).append("\nSET\n    ");
        for (Column c : this.columns) {
            Expression e = this.expressionMap.get(c);
            buff.appendExceptFirst(",\n    ");
            buff.append(c.getName()).append(" = ").append(e.getSQL());
        }
        if (this.condition != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            buff.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        for (Column c : this.columns) {
            Expression e = this.expressionMap.get(c);
            e.mapColumns(this.targetTableFilter, 0);
            if (this.sourceTableFilter != null) {
                e.mapColumns(this.sourceTableFilter, 0);
            }
            this.expressionMap.put(c, e.optimize(this.session));
        }
        TableFilter[] filters = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, ExpressionVisitor.allColumnsForTableFilters(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }
}

