/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Role
extends RightOwner {
    private final boolean system;

    public Role(Database database, int id, String roleName, boolean system) {
        super(database, id, roleName, 13);
        this.system = system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL(boolean ifNotExists) {
        if (this.system) {
            return null;
        }
        StringBuilder buff = new StringBuilder("CREATE ROLE ");
        if (ifNotExists) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(this.getSQL());
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        Right right;
        for (User user : this.database.getAllUsers()) {
            right = user.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        for (Role r2 : this.database.getAllRoles()) {
            right = r2.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        for (Right right2 : this.database.getAllRights()) {
            if (right2.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right2);
        }
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }
}

