/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueEnum;
import org.h2.value.ValueNull;

public class ExpressionColumn
extends Expression {
    private final Database database;
    private final String schemaName;
    private final String tableAlias;
    private String columnName;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
        this.schemaName = null;
        this.tableAlias = null;
        this.columnName = null;
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias, String columnName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
    }

    @Override
    public String getSQL() {
        String sql;
        boolean quote = this.database.getSettings().databaseToUpper;
        if (this.column != null) {
            sql = this.column.getSQL();
        } else {
            String string = sql = quote ? Parser.quoteIdentifier(this.columnName) : this.columnName;
        }
        if (this.tableAlias != null) {
            String a = quote ? Parser.quoteIdentifier(this.tableAlias) : this.tableAlias;
            sql = a + "." + sql;
        }
        if (this.schemaName != null) {
            String s = quote ? Parser.quoteIdentifier(this.schemaName) : this.schemaName;
            sql = s + "." + sql;
        }
        return sql;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        Column col;
        if (this.tableAlias != null && !this.database.equalsIdentifiers(this.tableAlias, resolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.database.equalsIdentifiers(this.schemaName, resolver.getSchemaName())) {
            return;
        }
        for (Column col2 : resolver.getColumns()) {
            String n = resolver.getDerivedColumnName(col2);
            if (n == null) {
                n = col2.getName();
            }
            if (!this.database.equalsIdentifiers(this.columnName, n)) continue;
            this.mapColumn(resolver, col2, level);
            return;
        }
        if (this.database.equalsIdentifiers("_ROWID_", this.columnName) && (col = resolver.getRowIdColumn()) != null) {
            this.mapColumn(resolver, col, level);
            return;
        }
        Column[] columns = resolver.getSystemColumns();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            Column col3 = columns[i];
            if (!this.database.equalsIdentifiers(this.columnName, col3.getName())) continue;
            this.mapColumn(resolver, col3, level);
            return;
        }
    }

    private void mapColumn(ColumnResolver resolver, Column col, int level) {
        if (this.columnResolver == null) {
            this.queryLevel = level;
            this.column = col;
            this.columnResolver = resolver;
        } else if (this.queryLevel == level && this.columnResolver != resolver && !(resolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.columnResolver == null) {
            Constant constant;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (constant = schema.findConstant(this.columnName)) != null) {
                return constant.getValue();
            }
            String name = this.columnName;
            if (this.tableAlias != null) {
                name = this.tableAlias + "." + name;
                if (this.schemaName != null) {
                    name = this.schemaName + "." + name;
                }
            }
            throw DbException.get(42122, name);
        }
        return this.columnResolver.optimize(this, this.column);
    }

    @Override
    public void updateAggregate(Session session) {
        Value now = this.columnResolver.getValue(this.column);
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL());
        }
        HashMap<Expression, Object> values = select.getCurrentGroup();
        if (values == null) {
            return;
        }
        Value v = (Value)values.get(this);
        if (v == null) {
            values.put(this, now);
        } else if (!this.database.areEqual(now, v)) {
            throw DbException.get(90016, this.getSQL());
        }
    }

    @Override
    public Value getValue(Session session) {
        Value v;
        HashMap<Expression, Object> values;
        Select select = this.columnResolver.getSelect();
        if (select != null && (values = select.getCurrentGroup()) != null && (v = (Value)values.get(this)) != null) {
            return v;
        }
        Value value = this.columnResolver.getValue(this.column);
        if (value == null) {
            if (select == null) {
                throw DbException.get(23502, this.getSQL());
            }
            throw DbException.get(90016, this.getSQL());
        }
        if (this.column.getEnumerators() != null && value != ValueNull.INSTANCE) {
            return ValueEnum.get(this.column.getEnumerators(), value.getInt());
        }
        return value;
    }

    @Override
    public int getType() {
        return this.column.getType();
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    public int getScale() {
        return this.column.getScale();
    }

    @Override
    public long getPrecision() {
        return this.column.getPrecision();
    }

    @Override
    public int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    @Override
    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    @Override
    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    @Override
    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    @Override
    public String getAlias() {
        if (this.column != null) {
            String name;
            if (this.columnResolver != null && (name = this.columnResolver.getDerivedColumnName(this.column)) != null) {
                return name;
            }
            return this.column.getName();
        }
        if (this.tableAlias != null) {
            return this.tableAlias + "." + this.columnName;
        }
        return this.columnName;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    @Override
    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: {
                return true;
            }
            case 0: {
                return this.queryLevel < visitor.getQueryLevel();
            }
            case 3: {
                if (visitor.getQueryLevel() < this.queryLevel) {
                    return true;
                }
                if (this.getTableFilter() == null) {
                    return false;
                }
                return this.getTableFilter().isEvaluatable();
            }
            case 4: {
                visitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != visitor.getResolver();
            }
            case 7: {
                if (this.column != null) {
                    visitor.addDependency(this.column.getTable());
                }
                return true;
            }
            case 9: {
                visitor.addColumn(this.column);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        TableFilter tf = this.getTableFilter();
        if (filter == tf && this.column.getType() == 1) {
            IndexCondition cond = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.TRUE));
            filter.addIndexCondition(cond);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }
}

