/*
 * Decompiled with CFR 0.152.
 */
package org.h2.ext.pulsar;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.UserAggregate;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;

public class PulsarExtension {
    public static SessionFactory sessionFactory;

    public static Class<?> getEngineImplementation() {
        String className = Utils.getProperty("h2.sessionFactory", "org.h2.engine.Engine");
        return JdbcUtils.loadUserClass(className);
    }

    public static SessionInterface createSession(ConnectionInfo ci) throws Exception {
        if (sessionFactory == null) {
            Class<?> engine = PulsarExtension.getEngineImplementation();
            System.err.println("H2 Engine implementation is: " + engine);
            sessionFactory = (SessionFactory)engine.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        return sessionFactory.createSession(ci);
    }

    public static void closeSession(Session session) throws Exception {
        sessionFactory.closeSession(session.getSerialId());
    }

    public static void shutdownSessionFactory() {
        Optional<Method> shutdownNow = Arrays.stream(sessionFactory.getClass().getMethods()).filter(method -> method.getName().equals("shutdownNow")).findFirst();
        if (shutdownNow.isPresent()) {
            try {
                shutdownNow.get().invoke((Object)sessionFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException var2) {
                var2.printStackTrace();
            }
        }
    }

    public static FunctionAlias findFunction(ConcurrentHashMap<String, FunctionAlias> functions, String functionAlias) {
        FunctionAlias f = functions.get(functionAlias);
        if (f != null) {
            return f;
        }
        functionAlias = functionAlias.replaceAll("_", "");
        return functions.get(functionAlias);
    }

    public static UserAggregate findAggregate(HashMap<String, UserAggregate> aggregates, String name) {
        UserAggregate agg = aggregates.get(name);
        if (agg != null) {
            return agg;
        }
        name = name.replaceAll("_", "");
        return aggregates.get(name);
    }
}

