/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.AbstractFunctionCursor;
import org.h2.index.FunctionIndex;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.DataType;
import org.h2.value.Value;

public class FunctionCursorResultSet
extends AbstractFunctionCursor {
    private final ResultSet result;
    private final ResultSetMetaData meta;

    FunctionCursorResultSet(FunctionIndex index, SearchRow first, SearchRow last, Session session, ResultSet result) {
        super(index, first, last, session);
        this.result = result;
        try {
            this.meta = result.getMetaData();
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    boolean nextImpl() {
        this.row = null;
        try {
            if (this.result != null && this.result.next()) {
                int columnCount = this.meta.getColumnCount();
                this.values = new Value[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    int type = DataType.getValueTypeFromResultSet(this.meta, i + 1);
                    this.values[i] = DataType.readValue(this.session, this.result, i + 1, type);
                }
            } else {
                this.values = null;
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        return this.values != null;
    }
}

