/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private final JdbcPreparedStatement prep;
    private final int paramCount;
    private final ArrayList<? extends ParameterInterface> parameters;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement prep, CommandInterface command, int id) {
        this.setTrace(trace, 11, id);
        this.prep = prep;
        this.parameters = command.getParameters();
        this.paramCount = this.parameters.size();
    }

    @Override
    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", param);
            this.getParameter(param);
            return 1;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", param);
            ParameterInterface p = this.getParameter(param);
            int type = p.getType();
            if (type == -1) {
                type = 13;
            }
            return DataType.getDataType((int)type).sqlType;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", param);
            ParameterInterface p = this.getParameter(param);
            return MathUtils.convertLongToInt(p.getPrecision());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getScale(int param) throws SQLException {
        try {
            this.debugCodeCall("getScale", param);
            ParameterInterface p = this.getParameter(param);
            return p.getScale();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        try {
            this.debugCodeCall("isNullable", param);
            return this.getParameter(param).getNullable();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        try {
            this.debugCodeCall("isSigned", param);
            this.getParameter(param);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", param);
            ParameterInterface p = this.getParameter(param);
            int type = p.getType();
            if (type == -1) {
                type = 13;
            }
            return DataType.getTypeClassName(type);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", param);
            ParameterInterface p = this.getParameter(param);
            int type = p.getType();
            if (type == -1) {
                type = 13;
            }
            return DataType.getDataType((int)type).name;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private ParameterInterface getParameter(int param) {
        this.checkClosed();
        if (param < 1 || param > this.paramCount) {
            throw DbException.getInvalidValueException("param", param);
        }
        return this.parameters.get(param - 1);
    }

    private void checkClosed() {
        this.prep.checkClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }
}

