/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.h2.api.TimestampWithTimeZone;
import org.h2.command.CommandInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSetBackwardsCompat;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.LocalDateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcResultSet
extends TraceObject
implements ResultSet,
JdbcResultSetBackwardsCompat {
    private final boolean closeStatement;
    private final boolean scrollable;
    private final boolean updatable;
    private ResultInterface result;
    private JdbcConnection conn;
    private JdbcStatement stat;
    private int columnCount;
    private boolean wasNull;
    private Value[] insertRow;
    private Value[] updateRow;
    private HashMap<String, Integer> columnLabelMap;
    private HashMap<Integer, Value[]> patchedRows;
    private JdbcPreparedStatement preparedStatement;
    private final CommandInterface command;

    JdbcResultSet(JdbcConnection conn, JdbcStatement stat, CommandInterface command, ResultInterface result, int id, boolean closeStatement, boolean scrollable, boolean updatable) {
        this.setTrace(conn.getSession().getTrace(), 4, id);
        this.conn = conn;
        this.stat = stat;
        this.command = command;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
        this.closeStatement = closeStatement;
        this.scrollable = scrollable;
        this.updatable = updatable;
    }

    JdbcResultSet(JdbcConnection conn, JdbcPreparedStatement preparedStatement, CommandInterface command, ResultInterface result, int id, boolean closeStatement, boolean scrollable, boolean updatable, HashMap<String, Integer> columnLabelMap) {
        this(conn, preparedStatement, command, result, id, closeStatement, scrollable, updatable);
        this.columnLabelMap = columnLabelMap;
        this.preparedStatement = preparedStatement;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.nextRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, id, "getMetaData()");
            }
            this.checkClosed();
            String catalog = this.conn.getCatalog();
            return new JdbcResultSetMetaData(this, null, this.result, catalog, this.conn.getSession().getTrace(), id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("findColumn", columnLabel);
            return this.getColumnIndex(columnLabel);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    void closeInternal() throws SQLException {
        if (this.result != null) {
            try {
                if (this.result.isLazy()) {
                    this.stat.onLazyResultSetClose(this.command, this.preparedStatement == null);
                }
                this.result.close();
                if (this.closeStatement && this.stat != null) {
                    this.stat.close();
                }
            }
            finally {
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            if (this.closeStatement) {
                return null;
            }
            return this.stat;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getString", columnIndex);
            return this.get(columnIndex).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getString", columnLabel);
            return this.get(columnLabel).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnIndex);
            return this.get(columnIndex).getInt();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnLabel);
            return this.get(columnLabel).getInt();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnIndex);
            return this.get(columnIndex).getBigDecimal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnIndex);
            return this.get(columnIndex).getDate();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnIndex);
            return this.get(columnIndex).getTime();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnIndex);
            return this.get(columnIndex).getTimestamp();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnLabel);
            return this.get(columnLabel).getBigDecimal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnLabel);
            return this.get(columnLabel).getDate();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnLabel);
            return this.get(columnLabel).getTime();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnLabel);
            return this.get(columnLabel).getTimestamp();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnIndex);
            Value v = this.get(columnIndex);
            return this.conn.convertToDefaultObject(v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnLabel);
            Value v = this.get(columnLabel);
            return this.conn.convertToDefaultObject(v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnIndex);
            return this.get(columnIndex).getBoolean();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnLabel);
            return this.get(columnLabel).getBoolean();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnIndex);
            return this.get(columnIndex).getByte();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnLabel);
            return this.get(columnLabel).getByte();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnIndex);
            return this.get(columnIndex).getShort();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnLabel);
            return this.get(columnLabel).getShort();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnIndex);
            return this.get(columnIndex).getLong();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnLabel);
            return this.get(columnLabel).getLong();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnIndex);
            return this.get(columnIndex).getFloat();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnLabel);
            return this.get(columnLabel).getFloat();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnIndex);
            return this.get(columnIndex).getDouble();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnLabel);
            return this.get(columnLabel).getDouble();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + StringUtils.quoteJavaString(columnLabel) + ", " + scale + ");");
            }
            if (scale < 0) {
                throw DbException.getInvalidValueException("scale", scale);
            }
            BigDecimal bd = this.get(columnLabel).getBigDecimal();
            return bd == null ? null : ValueDecimal.setScale(bd, scale);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + columnIndex + ", " + scale + ");");
            }
            if (scale < 0) {
                throw DbException.getInvalidValueException("scale", scale);
            }
            BigDecimal bd = this.get(columnIndex).getBigDecimal();
            return bd == null ? null : ValueDecimal.setScale(bd, scale);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + columnIndex + ", calendar)");
            }
            return DateTimeUtils.convertDate(this.get(columnIndex), calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + StringUtils.quoteJavaString(columnLabel) + ", calendar)");
            }
            return DateTimeUtils.convertDate(this.get(columnLabel), calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + columnIndex + ", calendar)");
            }
            return DateTimeUtils.convertTime(this.get(columnIndex), calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + StringUtils.quoteJavaString(columnLabel) + ", calendar)");
            }
            return DateTimeUtils.convertTime(this.get(columnLabel), calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + columnIndex + ", calendar)");
            }
            Value value = this.get(columnIndex);
            return DateTimeUtils.convertTimestamp(value, calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + StringUtils.quoteJavaString(columnLabel) + ", calendar)");
            }
            Value value = this.get(columnLabel);
            return DateTimeUtils.convertTimestamp(value, calendar);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(9);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Blob", 9, id, "getBlob(" + columnIndex + ")");
            }
            return (v = this.get(columnIndex)) == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(9);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Blob", 9, id, "getBlob(" + JdbcResultSet.quote(columnLabel) + ")");
            }
            return (v = this.get(columnLabel)) == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnIndex);
            return this.get(columnIndex).getBytes();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnLabel);
            return this.get(columnLabel).getBytes();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnIndex);
            return this.get(columnIndex).getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnLabel);
            return this.get(columnLabel).getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Clob", 10, id, "getClob(" + columnIndex + ")");
            }
            return (v = this.get(columnIndex)) == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Clob", 10, id, "getClob(" + JdbcResultSet.quote(columnLabel) + ")");
            }
            return (v = this.get(columnLabel)) == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(16);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Array", 16, id, "getArray(" + columnIndex + ")");
            }
            return (v = this.get(columnIndex)) == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(16);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Array", 16, id, "getArray(" + JdbcResultSet.quote(columnLabel) + ")");
            }
            return (v = this.get(columnLabel)) == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnIndex);
            String s = this.get(columnIndex).getString();
            return s == null ? null : IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnLabel);
            String s = this.get(columnLabel).getString();
            return IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnIndex);
            return this.get(columnIndex).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnLabel);
            return this.get(columnLabel).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnIndex);
            this.update(columnIndex, (Value)ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnLabel);
            this.update(columnLabel, (Value)ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + JdbcResultSet.quote(columnLabel) + ", " + x + ");");
            }
            this.update(columnLabel, (Value)ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueByte.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + columnLabel + ", " + x + ");");
            }
            this.update(columnLabel, (Value)ValueByte.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueBytes.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueBytes.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + columnIndex + ", (short) " + x + ");");
            }
            this.update(columnIndex, (Value)ValueShort.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + JdbcResultSet.quote(columnLabel) + ", (short) " + x + ");");
            }
            this.update(columnLabel, (Value)ValueShort.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueInt.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + JdbcResultSet.quote(columnLabel) + ", " + x + ");");
            }
            this.update(columnLabel, (Value)ValueInt.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + columnIndex + ", " + x + "L);");
            }
            this.update(columnIndex, (Value)ValueLong.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + JdbcResultSet.quote(columnLabel) + ", " + x + "L);");
            }
            this.update(columnLabel, (Value)ValueLong.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + columnIndex + ", " + x + "f);");
            }
            this.update(columnIndex, (Value)ValueFloat.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + JdbcResultSet.quote(columnLabel) + ", " + x + "f);");
            }
            this.update(columnLabel, (Value)ValueFloat.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + columnIndex + ", " + x + "d);");
            }
            this.update(columnIndex, (Value)ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + JdbcResultSet.quote(columnLabel) + ", " + x + "d);");
            }
            this.update(columnLabel, (Value)ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + columnIndex + ", " + JdbcResultSet.quoteBigDecimal(x) + ");");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueDecimal.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quoteBigDecimal(x) + ");");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueDecimal.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + columnIndex + ", " + JdbcResultSet.quote(x) + ");");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quote(x) + ");");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueDate.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueDate.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueTime.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueTime.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(columnIndex, x, -1);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(columnLabel, x, (long)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(columnLabel, x, -1);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(columnLabel, x, -1);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnLabel, x, (long)length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.updateCharacterStream(columnLabel, x, (long)length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateCharacterStream(columnLabel, x, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x, " + scale + ");");
            }
            this.update(columnIndex, this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x, " + scale + ");");
            }
            this.update(columnLabel, this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x);");
            }
            this.update(columnIndex, this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.update(columnLabel, this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.updateBlob(columnIndex, x, -1L);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + columnIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this.updateBlob(columnLabel, x, -1L);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, -1L);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + columnIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.updateClob(columnIndex, x, -1L);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(columnLabel) + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        this.updateClob(columnLabel, x, -1L);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.unsupported("setArray");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.unsupported("cursorName");
    }

    @Override
    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            if (this.result.isAfterLast()) {
                return 0;
            }
            int rowId = this.result.getRowId();
            return rowId + 1;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            if (!this.updatable) {
                return 1007;
            }
            UpdatableRow row = new UpdatableRow(this.conn, this.result);
            return row.isUpdatable() ? 1008 : 1007;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.result.getFetchSize();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", rows);
            this.checkClosed();
            if (rows < 0) {
                throw DbException.getInvalidValueException("rows", rows);
            }
            if (rows > 0) {
                int maxRows;
                if (this.stat != null && (maxRows = this.stat.getMaxRows()) > 0 && rows > maxRows) {
                    throw DbException.getInvalidValueException("rows", rows);
                }
            } else {
                rows = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.result.setFetchSize(rows);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.debugCodeCall("setFetchDirection", direction);
        if (direction != 1000) {
            throw this.unsupported("setFetchDirection");
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.stat == null ? 1003 : this.stat.resultSetType;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            return this.result.getRowId() < 0 && this.result.hasNext();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            return this.result.getRowId() > 0 && this.result.isAfterLast();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            return this.result.getRowId() == 0 && !this.result.isAfterLast();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            int rowId = this.result.getRowId();
            return rowId >= 0 && !this.result.isAfterLast() && !this.result.hasNext();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            if (this.result.getRowId() >= 0) {
                this.resetResult();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.nextRow()) {
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            if (this.result.getRowId() >= 0) {
                this.resetResult();
            }
            return this.nextRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            if (this.result.isAfterLast()) {
                this.resetResult();
            }
            while (this.result.hasNext()) {
                this.nextRow();
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean absolute(int rowNumber) throws SQLException {
        try {
            this.debugCodeCall("absolute", rowNumber);
            this.checkClosed();
            if (rowNumber < 0) {
                rowNumber = this.result.getRowCount() + rowNumber + 1;
            }
            if (--rowNumber < this.result.getRowId()) {
                this.resetResult();
            }
            while (this.result.getRowId() < rowNumber) {
                if (this.nextRow()) continue;
                return false;
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean relative(int rowCount) throws SQLException {
        try {
            this.debugCodeCall("relative", rowCount);
            this.checkClosed();
            if (rowCount < 0) {
                rowCount = this.result.getRowId() + rowCount + 1;
                this.resetResult();
            }
            for (int i = 0; i < rowCount; ++i) {
                if (this.nextRow()) continue;
                return false;
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.checkUpdatable();
            this.insertRow = new Value[this.columnCount];
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.checkUpdatable();
            this.insertRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.checkUpdatable();
            if (this.insertRow == null) {
                throw DbException.get(90029);
            }
            this.getUpdatableRow().insertRow(this.insertRow);
            this.insertRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            if (this.updateRow != null) {
                int i;
                UpdatableRow row = this.getUpdatableRow();
                Value[] current = new Value[this.columnCount];
                for (i = 0; i < this.updateRow.length; ++i) {
                    current[i] = this.get(i + 1);
                }
                row.updateRow(current, this.updateRow);
                for (i = 0; i < this.updateRow.length; ++i) {
                    if (this.updateRow[i] != null) continue;
                    this.updateRow[i] = current[i];
                }
                Value[] patch = row.readRow(this.updateRow);
                this.patchCurrentRow(patch);
                this.updateRow = null;
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().deleteRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.checkOnValidRow();
            this.patchCurrentRow(this.getUpdatableRow().readRow(this.result.currentRow()));
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private UpdatableRow getUpdatableRow() throws SQLException {
        UpdatableRow row = new UpdatableRow(this.conn, this.result);
        if (!row.isUpdatable()) {
            throw DbException.get(90127);
        }
        return row;
    }

    private int getColumnIndex(String columnLabel) {
        this.checkClosed();
        if (columnLabel == null) {
            throw DbException.getInvalidValueException("columnLabel", null);
        }
        if (this.columnCount >= 3) {
            Integer index;
            if (this.columnLabelMap == null) {
                int i;
                HashMap<String, Integer> map = new HashMap<String, Integer>(this.columnCount);
                for (i = 0; i < this.columnCount; ++i) {
                    String c = StringUtils.toUpperEnglish(this.result.getAlias(i));
                    JdbcResultSet.mapColumn(map, c, i);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    String colName = this.result.getColumnName(i);
                    if (colName == null) continue;
                    colName = StringUtils.toUpperEnglish(colName);
                    JdbcResultSet.mapColumn(map, colName, i);
                    String tabName = this.result.getTableName(i);
                    if (tabName == null) continue;
                    colName = StringUtils.toUpperEnglish(tabName) + "." + colName;
                    JdbcResultSet.mapColumn(map, colName, i);
                }
                this.columnLabelMap = map;
                if (this.preparedStatement != null) {
                    this.preparedStatement.setCachedColumnLabelMap(this.columnLabelMap);
                }
            }
            if ((index = this.columnLabelMap.get(StringUtils.toUpperEnglish(columnLabel))) == null) {
                throw DbException.get(42122, columnLabel);
            }
            return index + 1;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnLabel.equalsIgnoreCase(this.result.getAlias(i))) continue;
            return i + 1;
        }
        int idx = columnLabel.indexOf(46);
        if (idx > 0) {
            String table = columnLabel.substring(0, idx);
            String col = columnLabel.substring(idx + 1);
            for (int i = 0; i < this.columnCount; ++i) {
                if (!table.equalsIgnoreCase(this.result.getTableName(i)) || !col.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!columnLabel.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        }
        throw DbException.get(42122, columnLabel);
    }

    private static void mapColumn(HashMap<String, Integer> map, String label, int index) {
        Integer old = map.put(label, index);
        if (old != null) {
            map.put(label, old);
        }
    }

    private void checkColumnIndex(int columnIndex) {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", columnIndex);
        }
    }

    void checkClosed() {
        if (this.result == null) {
            throw DbException.get(90007);
        }
        if (this.stat != null) {
            this.stat.checkClosed();
        }
        if (this.conn != null) {
            this.conn.checkClosed();
        }
    }

    private boolean isOnValidRow() {
        return this.result.getRowId() >= 0 && !this.result.isAfterLast();
    }

    private void checkOnValidRow() {
        if (!this.isOnValidRow()) {
            throw DbException.get(2000);
        }
    }

    public Value get(int columnIndex) {
        Value[] list;
        this.checkColumnIndex(columnIndex);
        this.checkOnValidRow();
        if (this.patchedRows == null) {
            list = this.result.currentRow();
        } else {
            list = this.patchedRows.get(this.result.getRowId());
            if (list == null) {
                list = this.result.currentRow();
            }
        }
        Value value = list[columnIndex - 1];
        this.wasNull = value == ValueNull.INSTANCE;
        return value;
    }

    private Value get(String columnLabel) {
        int columnIndex = this.getColumnIndex(columnLabel);
        return this.get(columnIndex);
    }

    private void update(String columnLabel, Value v) {
        int columnIndex = this.getColumnIndex(columnLabel);
        this.update(columnIndex, v);
    }

    private void update(int columnIndex, Value v) {
        this.checkUpdatable();
        this.checkColumnIndex(columnIndex);
        if (this.insertRow != null) {
            this.insertRow[columnIndex - 1] = v;
        } else {
            if (this.updateRow == null) {
                this.updateRow = new Value[this.columnCount];
            }
            this.updateRow[columnIndex - 1] = v;
        }
    }

    private boolean nextRow() {
        if (this.result.isLazy() && this.stat.isCancelled()) {
            throw DbException.get(57014);
        }
        boolean next = this.result.next();
        if (!next && !this.scrollable) {
            this.result.close();
        }
        return next;
    }

    private void resetResult() {
        if (!this.scrollable) {
            throw DbException.get(90128);
        }
        this.result.reset();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.conn.getHoldability();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.result == null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + columnIndex + ", " + JdbcResultSet.quote(x) + ");");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quote(x) + ");");
            }
            this.update(columnLabel, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        throw this.unsupported("NClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        this.updateClob(columnIndex, x, -1L);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this.updateClob(columnIndex, x, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        this.updateClob(columnLabel, x, -1L);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateClob(columnLabel, x, length);
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        throw this.unsupported("NClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("NClob", 10, id, "getNClob(" + columnIndex + ")");
            }
            return (v = this.get(columnIndex)) == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("NClob", 10, id, "getNClob(" + columnLabel + ")");
            }
            return (v = this.get(columnLabel)) == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, v, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnIndex);
            return this.get(columnIndex).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnLabel);
            return this.get(columnLabel).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnIndex);
            return this.get(columnIndex).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnLabel);
            return this.get(columnLabel).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateNCharacterStream(columnIndex, x, -1L);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + columnIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateNCharacterStream(columnLabel, x, -1L);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnLabel, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            if (type == null) {
                throw DbException.getInvalidValueException("type", type);
            }
            this.debugCodeCall("getObject", columnIndex);
            Value value = this.get(columnIndex);
            return this.extractObjectOfType(type, value);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        try {
            if (type == null) {
                throw DbException.getInvalidValueException("type", type);
            }
            this.debugCodeCall("getObject", columnName);
            Value value = this.get(columnName);
            return this.extractObjectOfType(type, value);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private <T> T extractObjectOfType(Class<T> type, Value value) throws SQLException {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        if (type == BigDecimal.class) {
            return type.cast(value.getBigDecimal());
        }
        if (type == BigInteger.class) {
            return type.cast(value.getBigDecimal().toBigInteger());
        }
        if (type == String.class) {
            return type.cast(value.getString());
        }
        if (type == Boolean.class) {
            return type.cast(value.getBoolean());
        }
        if (type == Byte.class) {
            return type.cast(value.getByte());
        }
        if (type == Short.class) {
            return type.cast(value.getShort());
        }
        if (type == Integer.class) {
            return type.cast(value.getInt());
        }
        if (type == Long.class) {
            return type.cast(value.getLong());
        }
        if (type == Float.class) {
            return type.cast(Float.valueOf(value.getFloat()));
        }
        if (type == Double.class) {
            return type.cast(value.getDouble());
        }
        if (type == Date.class) {
            return type.cast(value.getDate());
        }
        if (type == Time.class) {
            return type.cast(value.getTime());
        }
        if (type == Timestamp.class) {
            return type.cast(value.getTimestamp());
        }
        if (type == java.util.Date.class) {
            return type.cast(new java.util.Date(value.getTimestamp().getTime()));
        }
        if (type == Calendar.class) {
            GregorianCalendar calendar = DateTimeUtils.createGregorianCalendar();
            calendar.setTime(value.getTimestamp());
            return type.cast(calendar);
        }
        if (type == UUID.class) {
            return type.cast(value.getObject());
        }
        if (type == byte[].class) {
            return type.cast(value.getBytes());
        }
        if (type == Array.class) {
            int id = JdbcResultSet.getNextId(16);
            return type.cast(value == ValueNull.INSTANCE ? null : new JdbcArray(this.conn, value, id));
        }
        if (type == Blob.class) {
            int id = JdbcResultSet.getNextId(9);
            return type.cast(value == ValueNull.INSTANCE ? null : new JdbcBlob(this.conn, value, id));
        }
        if (type == Clob.class) {
            int id = JdbcResultSet.getNextId(10);
            return type.cast(value == ValueNull.INSTANCE ? null : new JdbcClob(this.conn, value, id));
        }
        if (type == TimestampWithTimeZone.class) {
            return type.cast(value.getObject());
        }
        if (DataType.isGeometryClass(type)) {
            return type.cast(value.getObject());
        }
        if (type == LocalDateTimeUtils.LOCAL_DATE) {
            return type.cast(LocalDateTimeUtils.valueToLocalDate(value));
        }
        if (type == LocalDateTimeUtils.LOCAL_TIME) {
            return type.cast(LocalDateTimeUtils.valueToLocalTime(value));
        }
        if (type == LocalDateTimeUtils.LOCAL_DATE_TIME) {
            return type.cast(LocalDateTimeUtils.valueToLocalDateTime(value));
        }
        if (type == LocalDateTimeUtils.INSTANT) {
            return type.cast(LocalDateTimeUtils.valueToInstant(value));
        }
        if (type == LocalDateTimeUtils.OFFSET_DATE_TIME) {
            return type.cast(LocalDateTimeUtils.valueToOffsetDateTime(value));
        }
        throw this.unsupported(type.getName());
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.result;
    }

    private void patchCurrentRow(Value[] row) {
        boolean changed = false;
        Value[] current = this.result.currentRow();
        CompareMode mode = this.conn.getCompareMode();
        for (int i = 0; i < row.length; ++i) {
            if (row[i].compareTo(current[i], mode) == 0) continue;
            changed = true;
            break;
        }
        if (this.patchedRows == null) {
            this.patchedRows = new HashMap();
        }
        Integer rowId = this.result.getRowId();
        if (!changed) {
            this.patchedRows.remove(rowId);
        } else {
            this.patchedRows.put(rowId, row);
        }
    }

    private Value convertToUnknownValue(Object x) {
        this.checkClosed();
        return DataType.convertToValue(this.conn.getSession(), x, -1);
    }

    private void checkUpdatable() {
        this.checkClosed();
        if (!this.updatable) {
            throw DbException.get(90140);
        }
    }
}

