/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.h2.util.StringUtils;

public class FunctionsMySQL {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};

    public static void register(Connection conn) throws SQLException {
        String[] init = new String[]{"UNIX_TIMESTAMP", "unixTimestamp", "FROM_UNIXTIME", "fromUnixTime", "DATE", "date"};
        Statement stat = conn.createStatement();
        for (int i = 0; i < init.length; i += 2) {
            String alias = init[i];
            String method = init[i + 1];
            stat.execute("CREATE ALIAS IF NOT EXISTS " + alias + " FOR \"" + FunctionsMySQL.class.getName() + "." + method + "\"");
        }
    }

    public static int unixTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int unixTimestamp(Timestamp timestamp) {
        return (int)(timestamp.getTime() / 1000L);
    }

    public static String fromUnixTime(int seconds) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    public static String fromUnixTime(int seconds, String format) {
        format = FunctionsMySQL.convertToSimpleDateFormat(format);
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    private static String convertToSimpleDateFormat(String format) {
        String[] replace = FORMAT_REPLACE;
        for (int i = 0; i < replace.length; i += 2) {
            format = StringUtils.replaceAll(format, replace[i], replace[i + 1]);
        }
        return format;
    }

    public static String date(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        int index = dateTime.indexOf(32);
        if (index != -1) {
            return dateTime.substring(0, index);
        }
        return dateTime;
    }
}

