/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;

public class WriteBuffer {
    private static final int MAX_REUSE_CAPACITY = 0x400000;
    private static final int MIN_GROW = 0x100000;
    private ByteBuffer reuse;
    private ByteBuffer buff;

    public WriteBuffer(int initialSize) {
        this.buff = this.reuse = ByteBuffer.allocate(initialSize);
    }

    public WriteBuffer() {
        this(0x100000);
    }

    public WriteBuffer putVarInt(int x) {
        DataUtils.writeVarInt(this.ensureCapacity(5), x);
        return this;
    }

    public WriteBuffer putVarLong(long x) {
        DataUtils.writeVarLong(this.ensureCapacity(10), x);
        return this;
    }

    public WriteBuffer putStringData(String s, int len) {
        ByteBuffer b = this.ensureCapacity(3 * len);
        DataUtils.writeStringData(b, s, len);
        return this;
    }

    public WriteBuffer put(byte x) {
        this.ensureCapacity(1).put(x);
        return this;
    }

    public WriteBuffer putChar(char x) {
        this.ensureCapacity(2).putChar(x);
        return this;
    }

    public WriteBuffer putShort(short x) {
        this.ensureCapacity(2).putShort(x);
        return this;
    }

    public WriteBuffer putInt(int x) {
        this.ensureCapacity(4).putInt(x);
        return this;
    }

    public WriteBuffer putLong(long x) {
        this.ensureCapacity(8).putLong(x);
        return this;
    }

    public WriteBuffer putFloat(float x) {
        this.ensureCapacity(4).putFloat(x);
        return this;
    }

    public WriteBuffer putDouble(double x) {
        this.ensureCapacity(8).putDouble(x);
        return this;
    }

    public WriteBuffer put(byte[] bytes) {
        this.ensureCapacity(bytes.length).put(bytes);
        return this;
    }

    public WriteBuffer put(byte[] bytes, int offset, int length) {
        this.ensureCapacity(length).put(bytes, offset, length);
        return this;
    }

    public WriteBuffer put(ByteBuffer src) {
        this.ensureCapacity(src.remaining()).put(src);
        return this;
    }

    public WriteBuffer limit(int newLimit) {
        this.ensureCapacity(newLimit - this.buff.position()).limit(newLimit);
        return this;
    }

    public int capacity() {
        return this.buff.capacity();
    }

    public WriteBuffer position(int newPosition) {
        this.buff.position(newPosition);
        return this;
    }

    public int limit() {
        return this.buff.limit();
    }

    public int position() {
        return this.buff.position();
    }

    public WriteBuffer get(byte[] dst) {
        this.buff.get(dst);
        return this;
    }

    public WriteBuffer putInt(int index, int value) {
        this.buff.putInt(index, value);
        return this;
    }

    public WriteBuffer putShort(int index, short value) {
        this.buff.putShort(index, value);
        return this;
    }

    public WriteBuffer clear() {
        if (this.buff.limit() > 0x400000) {
            this.buff = this.reuse;
        } else if (this.buff != this.reuse) {
            this.reuse = this.buff;
        }
        this.buff.clear();
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buff;
    }

    private ByteBuffer ensureCapacity(int len) {
        if (this.buff.remaining() < len) {
            this.grow(len);
        }
        return this.buff;
    }

    private void grow(int additional) {
        ByteBuffer temp = this.buff;
        int needed = additional - temp.remaining();
        long grow = Math.max(needed, 0x100000);
        grow = Math.max((long)(temp.capacity() / 2), grow);
        int newCapacity = (int)Math.min(Integer.MAX_VALUE, (long)temp.capacity() + grow);
        if (newCapacity < needed) {
            throw new OutOfMemoryError("Capacity: " + newCapacity + " needed: " + needed);
        }
        try {
            this.buff = ByteBuffer.allocate(newCapacity);
        }
        catch (OutOfMemoryError e) {
            throw new OutOfMemoryError("Capacity: " + newCapacity);
        }
        temp.flip();
        this.buff.put(temp);
        if (newCapacity <= 0x400000) {
            this.reuse = this.buff;
        }
    }
}

