/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.result.ResultExternal;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private final boolean distinct;
    private final SortOrder sort;
    private Index index;
    private final Session session;
    private Table table;
    private Cursor resultCursor;
    private int rowCount;
    private final int columnCount;
    private final ResultTempTable parent;
    private boolean closed;
    private int childCount;
    private final boolean containsLob;

    ResultTempTable(Session session, Expression[] expressions, boolean distinct, SortOrder sort) {
        this.session = session;
        this.distinct = distinct;
        this.sort = sort;
        this.columnCount = expressions.length;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        CreateTableData data = new CreateTableData();
        boolean b = false;
        for (int i = 0; i < expressions.length; ++i) {
            int type = expressions[i].getType();
            Column col = new Column(COLUMN_NAME + i, type);
            if (type == 16 || type == 15) {
                b = true;
            }
            data.columns.add(col);
        }
        this.containsLob = b;
        data.id = session.getDatabase().allocateObjectId();
        data.tableName = "TEMP_RESULT_SET_" + data.id;
        data.temporary = true;
        data.persistIndexes = false;
        data.persistData = true;
        data.create = true;
        data.session = session;
        this.table = schema.createTable(data);
        if (sort != null || distinct) {
            this.createIndex();
        }
        this.parent = null;
    }

    private ResultTempTable(ResultTempTable parent) {
        this.parent = parent;
        this.columnCount = parent.columnCount;
        this.distinct = parent.distinct;
        this.session = parent.session;
        this.table = parent.table;
        this.index = parent.index;
        this.rowCount = parent.rowCount;
        this.sort = parent.sort;
        this.containsLob = parent.containsLob;
        this.reset();
    }

    private void createIndex() {
        IndexColumn[] indexCols = null;
        if (this.sort != null && !this.distinct) {
            int[] colIndex = this.sort.getQueryColumnIndexes();
            indexCols = new IndexColumn[colIndex.length];
            for (int i = 0; i < colIndex.length; ++i) {
                IndexColumn indexColumn = new IndexColumn();
                indexColumn.column = this.table.getColumn(colIndex[i]);
                indexColumn.sortType = this.sort.getSortTypes()[i];
                indexColumn.columnName = COLUMN_NAME + i;
                indexCols[i] = indexColumn;
            }
        } else {
            indexCols = new IndexColumn[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                IndexColumn indexColumn = new IndexColumn();
                indexColumn.column = this.table.getColumn(i);
                indexColumn.columnName = COLUMN_NAME + i;
                indexCols[i] = indexColumn;
            }
        }
        String indexName = this.table.getSchema().getUniqueIndexName(this.session, this.table, "INDEX_");
        int indexId = this.session.getDatabase().allocateObjectId();
        IndexType indexType = IndexType.createNonUnique(true);
        this.index = this.table.addIndex(this.session, indexName, indexId, indexCols, indexType, true, null);
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new ResultTempTable(this);
    }

    @Override
    public int removeRow(Value[] values) {
        Row row = this.convertToRow(values);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
            --this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public boolean contains(Value[] values) {
        return this.find(this.convertToRow(values)) != null;
    }

    @Override
    public int addRow(Value[] values) {
        Row row = this.convertToRow(values);
        if (this.distinct) {
            Cursor cursor = this.find(row);
            if (cursor == null) {
                this.table.addRow(this.session, row);
                ++this.rowCount;
            }
        } else {
            this.table.addRow(this.session, row);
            ++this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public int addRows(ArrayList<Value[]> rows) {
        if (this.sort != null) {
            this.sort.sort(rows);
        }
        for (Value[] values : rows) {
            this.addRow(values);
        }
        return this.rowCount;
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.dropTable();
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.childCount == 0) {
            this.dropTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable() {
        block21: {
            if (this.table == null) {
                return;
            }
            if (this.containsLob) {
                return;
            }
            try {
                Object object;
                Database database = this.session.getDatabase();
                Session session = this.session;
                synchronized (session) {
                    object = database;
                    synchronized (object) {
                        this.table.truncate(this.session);
                    }
                }
                if (database.isSysTableLocked()) break block21;
                Session sysSession = database.getSystemSession();
                this.table.removeChildrenAndResources(sysSession);
                if (this.index != null) {
                    this.session.removeLocalTempTableIndex(this.index);
                }
                object = this.session;
                synchronized (object) {
                    Session session2 = sysSession;
                    synchronized (session2) {
                        Database database2 = database;
                        synchronized (database2) {
                            sysSession.commit(false);
                        }
                    }
                }
            }
            finally {
                this.table = null;
            }
        }
    }

    @Override
    public void done() {
    }

    @Override
    public Value[] next() {
        if (this.resultCursor == null) {
            Index idx = this.distinct || this.sort != null ? this.index : this.table.getScanIndex(this.session);
            this.resultCursor = this.session.getDatabase().getMvStore() != null ? (idx.getRowCount(this.session) == 0L && this.rowCount > 0 ? idx.find((Session)null, null, null) : idx.find(this.session, null, null)) : idx.find(this.session, null, null);
        }
        if (!this.resultCursor.next()) {
            return null;
        }
        Row row = this.resultCursor.get();
        return row.getValueList();
    }

    @Override
    public void reset() {
        this.resultCursor = null;
    }

    private Row convertToRow(Value[] values) {
        if (values.length < this.columnCount) {
            Value[] v2 = Arrays.copyOf(values, this.columnCount);
            for (int i = values.length; i < this.columnCount; ++i) {
                v2[i] = ValueNull.INSTANCE;
            }
            values = v2;
        }
        return this.session.createRow(values, -1);
    }

    private Cursor find(Row row) {
        if (this.index == null) {
            this.createIndex();
        }
        Cursor cursor = this.index.find(this.session, (SearchRow)row, (SearchRow)row);
        while (cursor.next()) {
            SearchRow found = cursor.getSearchRow();
            boolean ok = true;
            Database db = this.session.getDatabase();
            for (int i = 0; i < row.getColumnCount(); ++i) {
                if (db.areEqual(row.getValue(i), found.getValue(i))) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return cursor;
        }
        return null;
    }
}

