/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.h2.compress.CompressLZF;
import org.h2.util.MathUtils;

class FileNioMemData {
    private static final int CACHE_MIN_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private static final ByteBuffer COMPRESSED_EMPTY_BLOCK;
    private static final ThreadLocal<CompressLZF> LZF_THREAD_LOCAL;
    private static final ThreadLocal<byte[]> COMPRESS_OUT_BUF_THREAD_LOCAL;
    final int nameHashCode;
    private final CompressLaterCache<CompressItem, CompressItem> compressLaterCache = new CompressLaterCache(8);
    private String name;
    private final boolean compress;
    private final float compressLaterCachePercent;
    private long length;
    private AtomicReference<ByteBuffer>[] buffers;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    FileNioMemData(String name, boolean compress, float compressLaterCachePercent) {
        this.name = name;
        this.nameHashCode = name.hashCode();
        this.compress = compress;
        this.compressLaterCachePercent = compressLaterCachePercent;
        this.buffers = new AtomicReference[0];
        this.lastModified = System.currentTimeMillis();
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    private void addToCompressLaterCache(int page) {
        CompressItem c = new CompressItem(this, page);
        this.compressLaterCache.put(c, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer expandPage(int page) {
        ByteBuffer d = this.buffers[page].get();
        if (d.capacity() == 65536) {
            return d;
        }
        ByteBuffer byteBuffer = d;
        synchronized (byteBuffer) {
            if (d.capacity() == 65536) {
                return d;
            }
            ByteBuffer out = ByteBuffer.allocateDirect(65536);
            if (d != COMPRESSED_EMPTY_BLOCK) {
                d.position(0);
                CompressLZF.expand(d, out);
            }
            this.buffers[page].compareAndSet(d, out);
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compressPage(int page) {
        ByteBuffer d;
        ByteBuffer byteBuffer = d = this.buffers[page].get();
        synchronized (byteBuffer) {
            if (d.capacity() != 65536) {
                return;
            }
            byte[] compressOutputBuffer = COMPRESS_OUT_BUF_THREAD_LOCAL.get();
            int len = LZF_THREAD_LOCAL.get().compress(d, 0, compressOutputBuffer, 0);
            ByteBuffer out = ByteBuffer.allocateDirect(len);
            out.put(compressOutputBuffer, 0, len);
            this.buffers[page].compareAndSet(d, out);
        }
    }

    void touch(boolean openReadOnly) throws IOException {
        if (this.isReadOnly || openReadOnly) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncate(long newLength) {
        this.rwLock.writeLock().lock();
        try {
            this.changeLength(newLength);
            long end = MathUtils.roundUpLong(newLength, 65536L);
            if (end != newLength) {
                int lastPage = (int)(newLength >>> 16);
                ByteBuffer d = this.expandPage(lastPage);
                for (int i = (int)(newLength & 0xFFFFL); i < 65536; ++i) {
                    d.put(i, (byte)0);
                }
                if (this.compress) {
                    this.addToCompressLaterCache(lastPage);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void changeLength(long len) {
        this.length = len;
        int blocks = (int)((len = MathUtils.roundUpLong(len, 65536L)) >>> 16);
        if (blocks != this.buffers.length) {
            AtomicReference[] newBuffers = new AtomicReference[blocks];
            System.arraycopy(this.buffers, 0, newBuffers, 0, Math.min(this.buffers.length, newBuffers.length));
            for (int i = this.buffers.length; i < blocks; ++i) {
                newBuffers[i] = new AtomicReference<ByteBuffer>(COMPRESSED_EMPTY_BLOCK);
            }
            this.buffers = newBuffers;
        }
        this.compressLaterCache.setCacheSize(Math.max(8, (int)((float)blocks * this.compressLaterCachePercent / 100.0f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readWrite(long pos, ByteBuffer b, int off, int len, boolean write) {
        Lock lock = write ? this.rwLock.writeLock() : this.rwLock.readLock();
        lock.lock();
        try {
            long end = pos + (long)len;
            if (end > this.length) {
                if (write) {
                    this.changeLength(end);
                } else {
                    len = (int)(this.length - pos);
                }
            }
            while (len > 0) {
                int l = (int)Math.min((long)len, 65536L - (pos & 0xFFFFL));
                int page = (int)(pos >>> 16);
                ByteBuffer block = this.expandPage(page);
                int blockOffset = (int)(pos & 0xFFFFL);
                if (write) {
                    ByteBuffer srcTmp = b.slice();
                    ByteBuffer dstTmp = block.duplicate();
                    srcTmp.position(off);
                    srcTmp.limit(off + l);
                    dstTmp.position(blockOffset);
                    dstTmp.put(srcTmp);
                } else {
                    ByteBuffer tmp = block.duplicate();
                    tmp.position(blockOffset);
                    tmp.limit(l + blockOffset);
                    int oldPosition = b.position();
                    b.position(off);
                    b.put(tmp);
                    b.position(oldPosition);
                }
                if (this.compress) {
                    this.addToCompressLaterCache(page);
                }
                off += l;
                pos += (long)l;
                len -= l;
            }
            long l = pos;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        LZF_THREAD_LOCAL = new ThreadLocal<CompressLZF>(){

            @Override
            protected CompressLZF initialValue() {
                return new CompressLZF();
            }
        };
        COMPRESS_OUT_BUF_THREAD_LOCAL = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[131072];
            }
        };
        byte[] n = new byte[65536];
        byte[] output = new byte[131072];
        int len = new CompressLZF().compress(n, 65536, output, 0);
        COMPRESSED_EMPTY_BLOCK = ByteBuffer.allocateDirect(len);
        COMPRESSED_EMPTY_BLOCK.put(output, 0, len);
    }

    static class CompressItem {
        public final FileNioMemData data;
        public final int page;

        public CompressItem(FileNioMemData data, int page) {
            this.data = data;
            this.page = page;
        }

        public int hashCode() {
            return this.page ^ this.data.nameHashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof CompressItem) {
                CompressItem c = (CompressItem)o;
                return c.data == this.data && c.page == this.page;
            }
            return false;
        }
    }

    static class CompressLaterCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int size;

        CompressLaterCache(int size) {
            super(size, 0.75f, true);
            this.size = size;
        }

        @Override
        public synchronized V put(K key, V value) {
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem c = (CompressItem)eldest.getKey();
            c.data.compressPage(c.page);
            return true;
        }

        public void setCacheSize(int size) {
            this.size = size;
        }
    }
}

