/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.Collections;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.DbSettings;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public abstract class TableBase
extends Table {
    private final String tableEngine;
    private final List<String> tableEngineParams;
    private final boolean globalTemporary;

    public TableBase(CreateTableData data) {
        super(data.schema, data.id, data.tableName, data.persistIndexes, data.persistData);
        this.tableEngine = data.tableEngine;
        this.globalTemporary = data.globalTemporary;
        this.tableEngineParams = data.tableEngineParams != null ? data.tableEngineParams : Collections.emptyList();
        this.setTemporary(data.temporary);
        Column[] cols = data.columns.toArray(new Column[0]);
        this.setColumns(cols);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQL() {
        Database db = this.getDatabase();
        if (db == null) {
            return null;
        }
        StatementBuilder buff = new StatementBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.isGlobalTemporary()) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        if (this.isHidden) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append("(\n    ");
        for (Column column : this.columns) {
            buff.appendExceptFirst(",\n    ");
            buff.append(column.getCreateSQL());
        }
        buff.append("\n)");
        if (this.tableEngine != null) {
            DbSettings s = db.getSettings();
            String d = s.defaultTableEngine;
            if (d == null && s.mvStore) {
                d = MVTableEngine.class.getName();
            }
            if (d == null || !this.tableEngine.endsWith(d)) {
                buff.append("\nENGINE ");
                buff.append(StringUtils.quoteIdentifier(this.tableEngine));
            }
        }
        if (!this.tableEngineParams.isEmpty()) {
            buff.append("\nWITH ");
            buff.resetCount();
            for (String parameter : this.tableEngineParams) {
                buff.appendExceptFirst(", ");
                buff.append(StringUtils.quoteIdentifier(parameter));
            }
        }
        if (!this.isPersistIndexes() && !this.isPersistData()) {
            buff.append("\nNOT PERSISTENT");
        }
        if (this.isHidden) {
            buff.append("\nHIDDEN");
        }
        return buff.toString();
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }
}

