/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Restore
extends Tool {
    public static void main(String ... args) throws SQLException {
        new Restore().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-file")) {
                zipFileName = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-quiet")) continue;
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        Restore.execute(zipFileName, dir, db);
    }

    private static String getOriginalDbName(String fileName, String db) throws IOException {
        try (InputStream in = FileUtils.newInputStream(fileName);){
            ZipEntry entry;
            ZipInputStream zipIn = new ZipInputStream(in);
            String originalDbName = null;
            boolean multiple = false;
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                zipIn.closeEntry();
                String name = Restore.getDatabaseNameFromFileName(entryName);
                if (name == null) continue;
                if (db.equals(name)) {
                    originalDbName = name;
                    break;
                }
                if (originalDbName == null) {
                    originalDbName = name;
                    continue;
                }
                multiple = true;
            }
            zipIn.close();
            if (multiple && !db.equals(originalDbName)) {
                throw new IOException("Multiple databases found, but not " + db);
            }
            String string = originalDbName;
            return string;
        }
    }

    private static String getDatabaseNameFromFileName(String fileName) {
        if (fileName.endsWith(".h2.db")) {
            return fileName.substring(0, fileName.length() - ".h2.db".length());
        }
        if (fileName.endsWith(".mv.db")) {
            return fileName.substring(0, fileName.length() - ".mv.db".length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String zipFileName, String directory, String db) {
        InputStream in = null;
        try {
            if (!FileUtils.exists(zipFileName)) {
                throw new IOException("File not found: " + zipFileName);
            }
            String originalDbName = null;
            int originalDbLen = 0;
            if (db != null) {
                originalDbName = Restore.getOriginalDbName(zipFileName, db);
                if (originalDbName == null) {
                    throw new IOException("No database named " + db + " found");
                }
                if (originalDbName.startsWith(SysProperties.FILE_SEPARATOR)) {
                    originalDbName = originalDbName.substring(1);
                }
                originalDbLen = originalDbName.length();
            }
            in = FileUtils.newInputStream(zipFileName);
            try (ZipInputStream zipIn = new ZipInputStream(in);){
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    String fileName = entry.getName();
                    fileName = fileName.replace('\\', SysProperties.FILE_SEPARATOR.charAt(0));
                    if ((fileName = fileName.replace('/', SysProperties.FILE_SEPARATOR.charAt(0))).startsWith(SysProperties.FILE_SEPARATOR)) {
                        fileName = fileName.substring(1);
                    }
                    boolean copy = false;
                    if (db == null) {
                        copy = true;
                    } else if (fileName.startsWith(originalDbName + ".")) {
                        fileName = db + fileName.substring(originalDbLen);
                        copy = true;
                    }
                    if (copy) {
                        OutputStream o = null;
                        try {
                            o = FileUtils.newOutputStream(directory + SysProperties.FILE_SEPARATOR + fileName, false);
                            IOUtils.copy(zipIn, o);
                            o.close();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeSilently(o);
                            throw throwable;
                        }
                        IOUtils.closeSilently(o);
                    }
                    zipIn.closeEntry();
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException e) {
            try {
                throw DbException.convertIOException(e, zipFileName);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(in);
                throw throwable;
            }
        }
        IOUtils.closeSilently(in);
    }
}

