/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class AbbaDetector {
    private static final boolean TRACE = false;
    private static final ThreadLocal<Deque<Object>> STACK = new ThreadLocal<Deque<Object>>(){

        @Override
        protected Deque<Object> initialValue() {
            return new ArrayDeque<Object>();
        }
    };
    private static final Map<Object, Map<Object, Exception>> LOCK_ORDERING = new WeakHashMap<Object, Map<Object, Exception>>();
    private static final Set<String> KNOWN_DEADLOCKS = new HashSet<String>();

    public static Object begin(Object o) {
        Deque<Object> stack;
        if (o == null) {
            o = new SecurityManager(){
                Class<?> clazz = this.getClassContext()[2];
            }.clazz;
        }
        if (!(stack = STACK.get()).isEmpty()) {
            Object last;
            if (stack.contains(o)) {
                return o;
            }
            while (!stack.isEmpty() && !Thread.holdsLock(last = stack.peek())) {
                stack.pop();
            }
        }
        if (!stack.isEmpty()) {
            AbbaDetector.markHigher(o, stack);
        }
        stack.push(o);
        return o;
    }

    private static Object getTest(Object o) {
        return o;
    }

    private static String getObjectName(Object o) {
        return o.getClass().getSimpleName() + "@" + System.identityHashCode(o);
    }

    private static synchronized void markHigher(Object o, Deque<Object> older) {
        Object test = AbbaDetector.getTest(o);
        Map<Object, Exception> map = LOCK_ORDERING.get(test);
        if (map == null) {
            map = new WeakHashMap<Object, Exception>();
            LOCK_ORDERING.put(test, map);
        }
        Exception oldException = null;
        for (Object old : older) {
            String deadlockType;
            Exception e;
            Object oldTest = AbbaDetector.getTest(old);
            if (oldTest == test) continue;
            Map<Object, Exception> oldMap = LOCK_ORDERING.get(oldTest);
            if (oldMap != null && (e = oldMap.get(test)) != null && !KNOWN_DEADLOCKS.contains(deadlockType = test.getClass() + " " + oldTest.getClass())) {
                String message = AbbaDetector.getObjectName(test) + " synchronized after \n " + AbbaDetector.getObjectName(oldTest) + ", but in the past before";
                RuntimeException ex = new RuntimeException(message);
                ex.initCause(e);
                ex.printStackTrace(System.out);
                KNOWN_DEADLOCKS.add(deadlockType);
            }
            if (map.containsKey(oldTest)) continue;
            if (oldException == null) {
                oldException = new Exception("Before");
            }
            map.put(oldTest, oldException);
        }
    }
}

