/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public final class DateTimeFunctions {
    private static final HashMap<String, Integer> DATE_PART = new HashMap();
    private static volatile String[][] MONTHS_AND_WEEKS;

    public static Value dateadd(String part, long count, Value v) {
        int field = DateTimeFunctions.getDatePart(part);
        if (field != 126 && field != 128 && field != 129 && (count > Integer.MAX_VALUE || count < Integer.MIN_VALUE)) {
            throw DbException.getInvalidValueException("DATEADD count", count);
        }
        boolean withDate = !(v instanceof ValueTime);
        boolean withTime = !(v instanceof ValueDate);
        boolean forceTimestamp = false;
        long[] a = DateTimeUtils.dateAndTimeFromValue(v);
        long dateValue = a[0];
        long timeNanos = a[1];
        switch (field) {
            case 113: {
                count *= 3L;
            }
            case 110: 
            case 116: {
                if (!withDate) {
                    throw DbException.getInvalidValueException("DATEADD time part", part);
                }
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                long month = DateTimeUtils.monthFromDateValue(dateValue);
                int day = DateTimeUtils.dayFromDateValue(dateValue);
                if (field == 116) {
                    year += count;
                } else {
                    month += count;
                }
                dateValue = DateTimeUtils.dateValueFromDenormalizedDate(year, month, day);
                return DateTimeUtils.dateTimeToValue(v, dateValue, timeNanos, forceTimestamp);
            }
            case 115: 
            case 124: {
                count *= 7L;
            }
            case 105: 
            case 106: 
            case 107: 
            case 125: {
                if (!withDate) {
                    throw DbException.getInvalidValueException("DATEADD time part", part);
                }
                dateValue = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) + count);
                return DateTimeUtils.dateTimeToValue(v, dateValue, timeNanos, forceTimestamp);
            }
            case 108: {
                count *= 3600000000000L;
                break;
            }
            case 109: {
                count *= 60000000000L;
                break;
            }
            case 114: 
            case 127: {
                count *= 1000000000L;
                break;
            }
            case 126: {
                count *= 1000000L;
                break;
            }
            case 128: {
                count *= 1000L;
                break;
            }
            case 129: {
                break;
            }
            case 130: {
                count *= 60L;
            }
            case 131: {
                if (!(v instanceof ValueTimestampTimeZone)) {
                    throw DbException.getUnsupportedException("DATEADD " + part);
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, (short)(count += (long)((ValueTimestampTimeZone)v).getTimeZoneOffsetMins()));
            }
            default: {
                throw DbException.getUnsupportedException("DATEADD " + part);
            }
        }
        if (!withTime) {
            forceTimestamp = true;
        }
        if ((timeNanos += count) >= 86400000000000L || timeNanos < 0L) {
            long d = timeNanos >= 86400000000000L ? timeNanos / 86400000000000L : (timeNanos - 86400000000000L + 1L) / 86400000000000L;
            return DateTimeUtils.dateTimeToValue(v, DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) + d), timeNanos -= d * 86400000000000L, forceTimestamp);
        }
        return DateTimeUtils.dateTimeToValue(v, dateValue, timeNanos, forceTimestamp);
    }

    public static long datediff(String part, Value v1, Value v2) {
        int field = DateTimeFunctions.getDatePart(part);
        long[] a1 = DateTimeUtils.dateAndTimeFromValue(v1);
        long dateValue1 = a1[0];
        long absolute1 = DateTimeUtils.absoluteDayFromDateValue(dateValue1);
        long[] a2 = DateTimeUtils.dateAndTimeFromValue(v2);
        long dateValue2 = a2[0];
        long absolute2 = DateTimeUtils.absoluteDayFromDateValue(dateValue2);
        switch (field) {
            case 108: 
            case 109: 
            case 114: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                long timeNanos1 = a1[1];
                long timeNanos2 = a2[1];
                switch (field) {
                    case 129: {
                        return (absolute2 - absolute1) * 86400000000000L + (timeNanos2 - timeNanos1);
                    }
                    case 128: {
                        return (absolute2 - absolute1) * 86400000000L + (timeNanos2 / 1000L - timeNanos1 / 1000L);
                    }
                    case 126: {
                        return (absolute2 - absolute1) * 86400000L + (timeNanos2 / 1000000L - timeNanos1 / 1000000L);
                    }
                    case 114: 
                    case 127: {
                        return (absolute2 - absolute1) * 86400L + (timeNanos2 / 1000000000L - timeNanos1 / 1000000000L);
                    }
                    case 109: {
                        return (absolute2 - absolute1) * 1440L + (timeNanos2 / 60000000000L - timeNanos1 / 60000000000L);
                    }
                    case 108: {
                        return (absolute2 - absolute1) * 24L + (timeNanos2 / 3600000000000L - timeNanos1 / 3600000000000L);
                    }
                }
            }
            case 105: 
            case 106: 
            case 107: 
            case 125: {
                return absolute2 - absolute1;
            }
            case 115: {
                return DateTimeFunctions.weekdiff(absolute1, absolute2, 0);
            }
            case 124: {
                return DateTimeFunctions.weekdiff(absolute1, absolute2, 1);
            }
            case 110: {
                return (DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1)) * 12 + DateTimeUtils.monthFromDateValue(dateValue2) - DateTimeUtils.monthFromDateValue(dateValue1);
            }
            case 113: {
                return (DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1)) * 4 + (DateTimeUtils.monthFromDateValue(dateValue2) - 1) / 3 - (DateTimeUtils.monthFromDateValue(dateValue1) - 1) / 3;
            }
            case 116: {
                return DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1);
            }
            case 130: 
            case 131: {
                int offsetMinutes1 = v1 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)v1).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, dateValue1, a1[1]);
                int offsetMinutes2 = v2 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)v2).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, dateValue2, a2[1]);
                if (field == 130) {
                    return offsetMinutes2 / 60 - offsetMinutes1 / 60;
                }
                return offsetMinutes2 - offsetMinutes1;
            }
        }
        throw DbException.getUnsupportedException("DATEDIFF " + part);
    }

    public static Value extract(String part, Value value) {
        Value result;
        int field = DateTimeFunctions.getDatePart(part);
        if (field != 127) {
            result = ValueInt.get(DateTimeFunctions.getIntDatePart(value, field));
        } else {
            long[] a = DateTimeUtils.dateAndTimeFromValue(value);
            long dateValue = a[0];
            long timeNanos = a[1];
            BigDecimal timeNanosBigDecimal = new BigDecimal(timeNanos);
            BigDecimal numberOfDays = new BigDecimal(DateTimeUtils.absoluteDayFromDateValue(dateValue));
            BigDecimal nanosSeconds = new BigDecimal(1000000000);
            BigDecimal secondsPerDay = new BigDecimal(86400L);
            if (value instanceof ValueTime) {
                result = ValueDecimal.get(timeNanosBigDecimal.divide(nanosSeconds));
            } else if (value instanceof ValueDate) {
                result = ValueDecimal.get(numberOfDays.multiply(secondsPerDay));
            } else if (value instanceof ValueTimestampTimeZone) {
                ValueTimestampTimeZone v = (ValueTimestampTimeZone)value;
                BigDecimal timeZoneOffsetSeconds = new BigDecimal(v.getTimeZoneOffsetMins() * 60);
                result = ValueDecimal.get(timeNanosBigDecimal.divide(nanosSeconds).add(numberOfDays.multiply(secondsPerDay)).subtract(timeZoneOffsetSeconds));
            } else {
                result = ValueDecimal.get(timeNanosBigDecimal.divide(nanosSeconds).add(numberOfDays.multiply(secondsPerDay)));
            }
        }
        return result;
    }

    public static Value truncateDate(String datePartStr, Value valueDate) {
        Value result;
        long timeNanos;
        int timeUnit = DateTimeFunctions.getDatePart(datePartStr);
        long[] fieldDateAndTime = DateTimeUtils.dateAndTimeFromValue(valueDate);
        long dateValue = fieldDateAndTime[0];
        long timeNanosRetrieved = fieldDateAndTime[1];
        switch (timeUnit) {
            case 128: {
                long nanoInMicroSecond = 1000L;
                long microseconds = timeNanosRetrieved / nanoInMicroSecond;
                timeNanos = microseconds * nanoInMicroSecond;
                break;
            }
            case 126: {
                long nanoInMilliSecond = 1000000L;
                long milliseconds = timeNanosRetrieved / nanoInMilliSecond;
                timeNanos = milliseconds * nanoInMilliSecond;
                break;
            }
            case 114: {
                long nanoInSecond = 1000000000L;
                long seconds = timeNanosRetrieved / nanoInSecond;
                timeNanos = seconds * nanoInSecond;
                break;
            }
            case 109: {
                long nanoInMinute = 60000000000L;
                long minutes = timeNanosRetrieved / nanoInMinute;
                timeNanos = minutes * nanoInMinute;
                break;
            }
            case 108: {
                long nanoInHour = 3600000000000L;
                long hours = timeNanosRetrieved / nanoInHour;
                timeNanos = hours * nanoInHour;
                break;
            }
            case 105: {
                timeNanos = 0L;
                break;
            }
            case 115: {
                long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(dateValue);
                int dayOfWeek = DateTimeUtils.getDayOfWeekFromAbsolute(absoluteDay, 1);
                if (dayOfWeek != 1) {
                    dateValue = DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay - (long)dayOfWeek + 1L);
                }
                timeNanos = 0L;
                break;
            }
            case 110: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                int month = DateTimeUtils.monthFromDateValue(dateValue);
                dateValue = DateTimeUtils.dateValue(year, month, 1);
                timeNanos = 0L;
                break;
            }
            case 113: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                int month = DateTimeUtils.monthFromDateValue(dateValue);
                month = (month - 1) / 3 * 3 + 1;
                dateValue = DateTimeUtils.dateValue(year, month, 1);
                timeNanos = 0L;
                break;
            }
            case 116: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            case 132: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                year = year / 10L * 10L;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            case 133: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                year = (year - 1L) / 100L * 100L + 1L;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            case 134: {
                long year = DateTimeUtils.yearFromDateValue(dateValue);
                year = (year - 1L) / 1000L * 1000L + 1L;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(datePartStr);
            }
        }
        if (valueDate instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone vTmp = (ValueTimestampTimeZone)valueDate;
            result = ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, vTmp.getTimeZoneOffsetMins());
        } else {
            result = ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String format, String locale, String timeZone) {
        SimpleDateFormat dateFormat;
        SimpleDateFormat simpleDateFormat = dateFormat = DateTimeFunctions.getDateFormat(format, locale, timeZone);
        synchronized (simpleDateFormat) {
            return dateFormat.format(date);
        }
    }

    private static SimpleDateFormat getDateFormat(String format, String locale, String timeZone) {
        try {
            SimpleDateFormat df;
            if (locale == null) {
                df = new SimpleDateFormat(format);
            } else {
                Locale l = new Locale(locale);
                df = new SimpleDateFormat(format, l);
            }
            if (timeZone != null) {
                df.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return df;
        }
        catch (Exception e) {
            throw DbException.get(90014, e, format + "/" + locale + "/" + timeZone);
        }
    }

    private static int getDatePart(String part) {
        Integer p = DATE_PART.get(StringUtils.toUpperEnglish(part));
        if (p == null) {
            throw DbException.getInvalidValueException("date part", part);
        }
        return p;
    }

    public static int getIntDatePart(Value date, int field) {
        long[] a = DateTimeUtils.dateAndTimeFromValue(date);
        long dateValue = a[0];
        long timeNanos = a[1];
        switch (field) {
            case 116: {
                return DateTimeUtils.yearFromDateValue(dateValue);
            }
            case 110: {
                return DateTimeUtils.monthFromDateValue(dateValue);
            }
            case 105: {
                return DateTimeUtils.dayFromDateValue(dateValue);
            }
            case 108: {
                return (int)(timeNanos / 3600000000000L % 24L);
            }
            case 109: {
                return (int)(timeNanos / 60000000000L % 60L);
            }
            case 114: {
                return (int)(timeNanos / 1000000000L % 60L);
            }
            case 126: {
                return (int)(timeNanos / 1000000L % 1000L);
            }
            case 128: {
                return (int)(timeNanos / 1000L % 1000000L);
            }
            case 129: {
                return (int)(timeNanos % 1000000000L);
            }
            case 107: {
                return DateTimeUtils.getDayOfYear(dateValue);
            }
            case 106: {
                return DateTimeUtils.getSundayDayOfWeek(dateValue);
            }
            case 115: {
                GregorianCalendar gc = DateTimeUtils.getCalendar();
                return DateTimeUtils.getWeekOfYear(dateValue, gc.getFirstDayOfWeek() - 1, gc.getMinimalDaysInFirstWeek());
            }
            case 113: {
                return (DateTimeUtils.monthFromDateValue(dateValue) - 1) / 3 + 1;
            }
            case 123: {
                return DateTimeUtils.getIsoWeekYear(dateValue);
            }
            case 124: {
                return DateTimeUtils.getIsoWeekOfYear(dateValue);
            }
            case 125: {
                return DateTimeUtils.getIsoDayOfWeek(dateValue);
            }
            case 130: 
            case 131: {
                int offsetMinutes = date instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)date).getTimeZoneOffsetMins() : DateTimeUtils.getTimeZoneOffsetMillis(null, dateValue, timeNanos);
                if (field == 130) {
                    return offsetMinutes / 60;
                }
                return offsetMinutes % 60;
            }
        }
        throw DbException.getUnsupportedException("getDatePart(" + date + ", " + field + ')');
    }

    public static String[] getMonthsAndWeeks(int field) {
        String[][] result = MONTHS_AND_WEEKS;
        if (result == null) {
            result = new String[2][];
            DateFormatSymbols dfs = DateFormatSymbols.getInstance(Locale.ENGLISH);
            result[0] = dfs.getMonths();
            result[1] = dfs.getWeekdays();
            MONTHS_AND_WEEKS = result;
        }
        return result[field];
    }

    public static boolean isDatePart(String part) {
        return DATE_PART.containsKey(StringUtils.toUpperEnglish(part));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String date, String format, String locale, String timeZone) {
        SimpleDateFormat dateFormat = DateTimeFunctions.getDateFormat(format, locale, timeZone);
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                return dateFormat.parse(date);
            }
        }
        catch (Exception e) {
            throw DbException.get(90014, e, date);
        }
    }

    private static long weekdiff(long absolute1, long absolute2, int firstDayOfWeek) {
        long r1 = (absolute1 += (long)(4 - firstDayOfWeek)) / 7L;
        if (absolute1 < 0L && r1 * 7L != absolute1) {
            --r1;
        }
        long r2 = (absolute2 += (long)(4 - firstDayOfWeek)) / 7L;
        if (absolute2 < 0L && r2 * 7L != absolute2) {
            --r2;
        }
        return r2 - r1;
    }

    private DateTimeFunctions() {
    }

    static {
        DATE_PART.put("SQL_TSI_YEAR", 116);
        DATE_PART.put("YEAR", 116);
        DATE_PART.put("YYYY", 116);
        DATE_PART.put("YY", 116);
        DATE_PART.put("SQL_TSI_MONTH", 110);
        DATE_PART.put("MONTH", 110);
        DATE_PART.put("MM", 110);
        DATE_PART.put("M", 110);
        DATE_PART.put("QUARTER", 113);
        DATE_PART.put("SQL_TSI_WEEK", 115);
        DATE_PART.put("WW", 115);
        DATE_PART.put("WK", 115);
        DATE_PART.put("WEEK", 115);
        DATE_PART.put("ISO_WEEK", 124);
        DATE_PART.put("DAY", 105);
        DATE_PART.put("DD", 105);
        DATE_PART.put("D", 105);
        DATE_PART.put("SQL_TSI_DAY", 105);
        DATE_PART.put("DAY_OF_WEEK", 106);
        DATE_PART.put("DAYOFWEEK", 106);
        DATE_PART.put("DOW", 106);
        DATE_PART.put("ISO_DAY_OF_WEEK", 125);
        DATE_PART.put("DAYOFYEAR", 107);
        DATE_PART.put("DAY_OF_YEAR", 107);
        DATE_PART.put("DY", 107);
        DATE_PART.put("DOY", 107);
        DATE_PART.put("SQL_TSI_HOUR", 108);
        DATE_PART.put("HOUR", 108);
        DATE_PART.put("HH", 108);
        DATE_PART.put("SQL_TSI_MINUTE", 109);
        DATE_PART.put("MINUTE", 109);
        DATE_PART.put("MI", 109);
        DATE_PART.put("N", 109);
        DATE_PART.put("SQL_TSI_SECOND", 114);
        DATE_PART.put("SECOND", 114);
        DATE_PART.put("SS", 114);
        DATE_PART.put("S", 114);
        DATE_PART.put("MILLISECOND", 126);
        DATE_PART.put("MILLISECONDS", 126);
        DATE_PART.put("MS", 126);
        DATE_PART.put("EPOCH", 127);
        DATE_PART.put("MICROSECOND", 128);
        DATE_PART.put("MICROSECONDS", 128);
        DATE_PART.put("MCS", 128);
        DATE_PART.put("NANOSECOND", 129);
        DATE_PART.put("NS", 129);
        DATE_PART.put("TIMEZONE_HOUR", 130);
        DATE_PART.put("TIMEZONE_MINUTE", 131);
        DATE_PART.put("DECADE", 132);
        DATE_PART.put("CENTURY", 133);
        DATE_PART.put("MILLENNIUM", 134);
    }
}

