/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int NULL = 3;
    public static final int TRUE = 4;
    public static final int FALSE = 5;
    public static final int ROWNUM = 6;

    private ParserUtil() {
    }

    public static boolean isKeyword(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(s, false) != 2;
    }

    public static boolean isSimpleIdentifier(String s, boolean functionsAsKeywords) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return false;
        }
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            c = s.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(s, functionsAsKeywords) == 2;
    }

    public static int getSaveTokenType(String s, boolean functionsAsKeywords) {
        switch (s.charAt(0)) {
            case 'A': {
                return ParserUtil.getKeywordOrIdentifier(s, "ALL", 1);
            }
            case 'C': {
                if ("CHECK".equals(s)) {
                    return 1;
                }
                if ("CONSTRAINT".equals(s)) {
                    return 1;
                }
                if ("CROSS".equals(s)) {
                    return 1;
                }
                if (functionsAsKeywords && ("CURRENT_DATE".equals(s) || "CURRENT_TIME".equals(s) || "CURRENT_TIMESTAMP".equals(s))) {
                    return 1;
                }
                return 2;
            }
            case 'D': {
                return ParserUtil.getKeywordOrIdentifier(s, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "EXISTS", 1);
            }
            case 'F': {
                if ("FETCH".equals(s)) {
                    return 1;
                }
                if ("FROM".equals(s)) {
                    return 1;
                }
                if ("FOR".equals(s)) {
                    return 1;
                }
                if ("FOREIGN".equals(s)) {
                    return 1;
                }
                if ("FULL".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "FALSE", 5);
            }
            case 'G': {
                return ParserUtil.getKeywordOrIdentifier(s, "GROUP", 1);
            }
            case 'H': {
                return ParserUtil.getKeywordOrIdentifier(s, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(s)) {
                    return 1;
                }
                if ("INTERSECT".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "IS", 1);
            }
            case 'J': {
                return ParserUtil.getKeywordOrIdentifier(s, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "LIKE", 1);
            }
            case 'M': {
                return ParserUtil.getKeywordOrIdentifier(s, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(s)) {
                    return 1;
                }
                if ("NATURAL".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "NULL", 3);
            }
            case 'O': {
                if ("OFFSET".equals(s)) {
                    return 1;
                }
                if ("ON".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "ORDER", 1);
            }
            case 'P': {
                return ParserUtil.getKeywordOrIdentifier(s, "PRIMARY", 1);
            }
            case 'R': {
                return ParserUtil.getKeywordOrIdentifier(s, "ROWNUM", 6);
            }
            case 'S': {
                if ("SELECT".equals(s)) {
                    return 1;
                }
                if (functionsAsKeywords && ("SYSDATE".equals(s) || "SYSTIME".equals(s) || "SYSTIMESTAMP".equals(s))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if ("TRUE".equals(s)) {
                    return 4;
                }
                if (functionsAsKeywords && "TODAY".equals(s)) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if ("UNIQUE".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "UNION", 1);
            }
            case 'W': {
                if ("WITH".equals(s)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(s, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String s1, String s2, int keywordType) {
        if (s1.equals(s2)) {
            return keywordType;
        }
        return 2;
    }
}

