/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Locale;
import java.util.Objects;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CharsetCollator;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;

public class CompareMode {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;

    protected CompareMode(String name, int strength, boolean binaryUnsigned) {
        this.name = name;
        this.strength = strength;
        this.binaryUnsigned = binaryUnsigned;
    }

    public static CompareMode getInstance(String name, int strength) {
        return CompareMode.getInstance(name, strength, SysProperties.SORT_BINARY_UNSIGNED);
    }

    public static CompareMode getInstance(String name, int strength, boolean binaryUnsigned) {
        CompareMode last = lastUsed;
        if (last != null && Objects.equals(last.name, name) && last.strength == strength && last.binaryUnsigned == binaryUnsigned) {
            return last;
        }
        if (name == null || name.equals(OFF)) {
            last = new CompareMode(name, strength, binaryUnsigned);
        } else {
            boolean useICU4J;
            if (name.startsWith(ICU4J)) {
                useICU4J = true;
                name = name.substring(ICU4J.length());
            } else if (name.startsWith(DEFAULT)) {
                useICU4J = false;
                name = name.substring(DEFAULT.length());
            } else {
                useICU4J = CAN_USE_ICU4J;
            }
            last = useICU4J ? new CompareModeIcu4J(name, strength, binaryUnsigned) : new CompareModeDefault(name, strength, binaryUnsigned);
        }
        lastUsed = last;
        return last;
    }

    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        char ca = a.charAt(ai);
        char cb = b.charAt(bi);
        if (ignoreCase) {
            ca = Character.toUpperCase(ca);
            cb = Character.toUpperCase(cb);
        }
        return ca == cb;
    }

    public int compareString(String a, String b, boolean ignoreCase) {
        if (ignoreCase) {
            return a.compareToIgnoreCase(b);
        }
        return a.compareTo(b);
    }

    public static String getName(Locale l) {
        Locale english = Locale.ENGLISH;
        String name = l.getDisplayLanguage(english) + ' ' + l.getDisplayCountry(english) + ' ' + l.getVariant();
        name = StringUtils.toUpperEnglish(name.trim().replace(' ', '_'));
        return name;
    }

    static boolean compareLocaleNames(Locale locale, String name) {
        return name.equalsIgnoreCase(locale.toString()) || name.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String name) {
        String country;
        String language;
        Locale locale3;
        int idx;
        Collator result = null;
        if (name.startsWith(ICU4J)) {
            name = name.substring(ICU4J.length());
        } else if (name.startsWith(DEFAULT)) {
            name = name.substring(DEFAULT.length());
        } else if (name.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(name.substring(CHARSET.length())));
        }
        if (name.length() == 2) {
            Locale locale2 = new Locale(StringUtils.toLowerEnglish(name), "");
            if (CompareMode.compareLocaleNames(locale2, name)) {
                result = Collator.getInstance(locale2);
            }
        } else if (name.length() == 5 && (idx = name.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale3 = new Locale(language = StringUtils.toLowerEnglish(name.substring(0, idx)), country = name.substring(idx + 1)), name)) {
            result = Collator.getInstance(locale3);
        }
        if (result == null) {
            for (Locale locale3 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale3, name)) continue;
                result = Collator.getInstance(locale3);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompareMode)) {
            return false;
        }
        CompareMode o = (CompareMode)obj;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        if (this.strength != o.strength) {
            return false;
        }
        return this.binaryUnsigned == o.binaryUnsigned;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.strength ^ (this.binaryUnsigned ? -1 : 0);
    }

    static {
        boolean b = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            b = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = b;
    }
}

