/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Class<?> componentType;
    private final Value[] values;
    private int hash;

    private ValueArray(Class<?> componentType, Value[] list) {
        this.componentType = componentType;
        this.values = list;
    }

    private ValueArray(Value[] list) {
        this(Object.class, list);
    }

    public static ValueArray get(Value[] list) {
        return new ValueArray(list);
    }

    public static ValueArray get(Class<?> componentType, Value[] list) {
        return new ValueArray(componentType, list);
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = 1;
        for (Value v : this.values) {
            h = h * 31 + v.hashCode();
        }
        this.hash = h;
        return h;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int getType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public long getPrecision() {
        long p = 0L;
        for (Value v : this.values) {
            p += v.getPrecision();
        }
        return p;
    }

    @Override
    public String getString() {
        StatementBuilder buff = new StatementBuilder("(");
        for (Value v : this.values) {
            buff.appendExceptFirst(", ");
            buff.append(v.getString());
        }
        return buff.append(')').toString();
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueArray v = (ValueArray)o;
        if (this.values == v.values) {
            return 0;
        }
        int l = this.values.length;
        int ol = v.values.length;
        int len = Math.min(l, ol);
        for (int i = 0; i < len; ++i) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int comp = v1.compareTo(v2, mode);
            if (comp == 0) continue;
            return comp;
        }
        return Integer.compare(l, ol);
    }

    @Override
    public Object getObject() {
        int len = this.values.length;
        Object[] list = (Object[])Array.newInstance(this.componentType, len);
        for (int i = 0; i < len; ++i) {
            int type;
            Value value = this.values[i];
            list[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((type = value.getType()) == 2 || type == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return list;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder("(");
        for (Value v : this.values) {
            buff.appendExceptFirst(", ");
            buff.append(v.getSQL());
        }
        if (this.values.length == 1) {
            buff.append(',');
        }
        return buff.append(')').toString();
    }

    @Override
    public String getTraceSQL() {
        StatementBuilder buff = new StatementBuilder("(");
        for (Value v : this.values) {
            buff.appendExceptFirst(", ");
            buff.append(v == null ? "null" : v.getTraceSQL());
        }
        return buff.append(')').toString();
    }

    @Override
    public int getDisplaySize() {
        long size = 0L;
        for (Value v : this.values) {
            size += (long)v.getDisplaySize();
        }
        return MathUtils.convertLongToInt(size);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueArray)) {
            return false;
        }
        ValueArray v = (ValueArray)other;
        if (this.values == v.values) {
            return true;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.values[i].equals(v.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMemory() {
        int memory = 32;
        for (Value v : this.values) {
            memory += v.getMemory() + 8;
        }
        return memory;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (!force) {
            return this;
        }
        ArrayList<Value> list = New.arrayList();
        for (Value v : this.values) {
            if ((precision -= Math.max(1L, (v = v.convertPrecision(precision, true)).getPrecision())) < 0L) break;
            list.add(v);
        }
        return ValueArray.get(list.toArray(new Value[0]));
    }
}

