/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int value) {
        this.value = value;
    }

    public static ValueInt get(int i) {
        if (i >= 0 && i < 128) {
            return STATIC_CACHE[i];
        }
        ValueInt v = DYNAMIC_CACHE[i & 0xFF];
        if (v == null || v.value != i) {
            ValueInt.DYNAMIC_CACHE[i & 0xFF] = v = new ValueInt(i);
        }
        return v;
    }

    @Override
    public Value add(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value + (long)other.value);
    }

    private static ValueInt checkRange(long x) {
        if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
            throw DbException.get(22003, Long.toString(x));
        }
        return ValueInt.get((int)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInt.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value - (long)other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value * (long)other.value);
    }

    @Override
    public Value divide(Value v) {
        ValueInt other = (ValueInt)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueInt other = (ValueInt)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value % other.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueInt v = (ValueInt)o;
        return Integer.compare(this.value, v.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.value);
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueInt && this.value == ((ValueInt)other).value;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ValueInt.STATIC_CACHE[i] = new ValueInt(i);
        }
    }
}

