/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Arrays;
import org.h2.engine.Mode;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ValueStringFixed
extends ValueString {
    public static final int PRECISION_DO_NOT_TRIM = Integer.MIN_VALUE;
    public static final int PRECISION_TRIM = -1;
    private static final ValueStringFixed EMPTY = new ValueStringFixed("");

    protected ValueStringFixed(String value) {
        super(value);
    }

    private static String trimRight(String s) {
        return ValueStringFixed.trimRight(s, 0);
    }

    private static String trimRight(String s, int minLength) {
        int endIndex;
        int i;
        for (i = endIndex = s.length() - 1; i >= minLength && s.charAt(i) == ' '; --i) {
        }
        s = i == endIndex ? s : s.substring(0, i + 1);
        return s;
    }

    private static String rightPadWithSpaces(String s, int length) {
        int pad = length - s.length();
        if (pad <= 0) {
            return s;
        }
        char[] res = new char[length];
        s.getChars(0, s.length(), res, 0);
        Arrays.fill(res, s.length(), length, ' ');
        return new String(res);
    }

    @Override
    public int getType() {
        return 21;
    }

    public static ValueStringFixed get(String s) {
        return ValueStringFixed.get(s, -1, null);
    }

    public static ValueStringFixed get(String s, int precision, Mode mode) {
        if (mode != null && mode.padFixedLengthStrings) {
            if (precision == Integer.MAX_VALUE) {
                precision = 1;
            }
            s = s.length() < precision ? ValueStringFixed.rightPadWithSpaces(s, precision) : ValueStringFixed.trimRight(s, precision);
        } else if (precision != Integer.MIN_VALUE) {
            s = ValueStringFixed.trimRight(s);
        }
        if (s.length() == 0) {
            return EMPTY;
        }
        ValueStringFixed obj = new ValueStringFixed(StringUtils.cache(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueStringFixed)Value.cache(obj);
    }

    @Override
    protected ValueString getNew(String s) {
        return ValueStringFixed.get(s);
    }
}

