/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingException;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GFieldGroup;
import ai.platon.pulsar.persist.model.PageModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/index/GeneralIndexingFilter;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "addDocFields", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "fields", "", "", "filter", "getParams", "Lai/platon/pulsar/common/config/Params;", "setup", "Companion", "pulsar-index"})
public final class GeneralIndexingFilter
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableConfig conf;
    private static int maxContentLength = 20000;

    public GeneralIndexingFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        maxContentLength = conf.getInt("index.max.content.length", 100000);
        IndexingFilter.LOG.info(this.getParams().formatAsLine());
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"maxContentLength", maxContentLength};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"classNa\u2026axContentLength\n        )");
        return params;
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) throws IndexingException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        doc.addIfAbsent("id", (Object)doc.getKey());
        doc.addIfAbsent("url", (Object)url);
        String string = StringUtils.substringBefore((String)page.getArgs(), (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringBefore(page.args, \" \")");
        doc.addIfAbsent("seed_url", (Object)string);
        this.addDocFields(doc, url, page);
        return doc;
    }

    private final void addDocFields(IndexDocument doc, String url, WebPage page) {
        List list;
        PageModel pageModel = page.getPageModel();
        if (pageModel != null && (list = pageModel.getFieldGroups()) != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GFieldGroup it = (GFieldGroup)element$iv;
                boolean bl = false;
                Map map = it.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.fields");
                this.addDocFields(doc, map);
            }
        }
    }

    private final void addDocFields(IndexDocument doc, Map<CharSequence, ? extends CharSequence> fields) {
        Object $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Object $this$filter$iv = fields;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            it = item$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl3 = false;
            Pair pair = TuplesKt.to((Object)it.getKey().toString(), (Object)String.valueOf(it.getValue()));
            object2.add(pair);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean bl4 = false;
            if (!(((String)it2.getSecond()).length() < maxContentLength)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it3 = (Pair)element$iv;
            boolean bl5 = false;
            doc.addIfAbsent((String)it3.getFirst(), it3.getSecond());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/index/GeneralIndexingFilter$Companion;", "", "()V", "maxContentLength", "", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

