/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingException;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.WebPageExt;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lai/platon/pulsar/index/MetadataIndexer;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "addGeneralMetadata", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "addHost", "url0", "addPageMetadata", "addTime", "filter", "getParams", "Lai/platon/pulsar/common/config/Params;", "setup", "Companion", "pulsar-index"})
public final class MetadataIndexer
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableConfig conf;
    @NotNull
    private static final String PARSE_CONF_PROPERTY = "index.metadata";
    @NotNull
    private static final String INDEX_PREFIX = "meta_";
    @NotNull
    private static final String PARSE_META_PREFIX = "meta_";
    @NotNull
    private static final Map<String, String> parseFieldnames = new TreeMap();

    public MetadataIndexer(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        conf.getStringCollection(PARSE_CONF_PROPERTY).forEach(MetadataIndexer::setup$lambda-0);
    }

    @NotNull
    public Params getParams() {
        return new Params();
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) throws IndexingException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        try {
            this.addTime(doc, url, page);
            this.addHost(doc, url, page);
            this.addGeneralMetadata(doc, url, page);
            this.addPageMetadata(doc, url, page);
        }
        catch (IndexingException e) {
            IndexingFilter.LOG.error(e.toString());
        }
        return doc;
    }

    private final void addHost(IndexDocument doc, String url0, WebPage page) throws IndexingException {
        String url = url0;
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        try {
            URL u = new URL(url);
            String domain = URLUtil.INSTANCE.getDomainName(u);
            doc.add("url", (Object)url);
            doc.add("domain", (Object)domain);
            doc.addIfNotNull("host", (Object)u.getHost());
        }
        catch (MalformedURLException e) {
            throw new IndexingException((Throwable)e);
        }
    }

    private final void addTime(IndexDocument doc, String url, WebPage page) {
        WebPageExt pageExt = new WebPageExt(page);
        Instant now = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        String crawlTimeStr = DateTimes.isoInstantFormat((Instant)now);
        Instant instant = pageExt.getFirstFetchTime();
        Instant firstFetchTime = instant == null ? now : instant;
        String string = page.getFetchTimeHistory(crawlTimeStr);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.getFetchTimeHistory(crawlTimeStr)");
        String fetchTimeHistory = string;
        doc.add("first_crawl_time", (Object)DateTimes.isoInstantFormat((Instant)firstFetchTime));
        doc.add("last_crawl_time", (Object)crawlTimeStr);
        doc.add("fetch_time_history", (Object)fetchTimeHistory);
        String indexTimeStr = DateTimes.isoInstantFormat((Instant)now);
        Instant firstIndexTime = pageExt.getFirstIndexTime(now);
        String indexTimeHistory = page.getIndexTimeHistory(indexTimeStr);
        doc.add("first_index_time", (Object)DateTimes.isoInstantFormat((Instant)firstIndexTime));
        doc.add("last_index_time", (Object)indexTimeStr);
        doc.add("index_time_history", (Object)indexTimeHistory);
    }

    private final void addGeneralMetadata(IndexDocument doc, String url, WebPage page) throws IndexingException {
        String string = page.getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.contentType");
        String contentType = string;
        if (!StringsKt.contains$default((CharSequence)contentType, (CharSequence)"html", (boolean)false, (int)2, null)) {
            IndexingFilter.LOG.warn("Content type " + contentType + " is not fully supported");
        }
        doc.add("content_type", (Object)contentType);
    }

    /*
     * WARNING - void declaration
     */
    private final IndexDocument addPageMetadata(IndexDocument doc, String url, WebPage page) {
        if (doc == null || parseFieldnames.isEmpty()) {
            return doc;
        }
        for (Map.Entry<String, String> metatag : parseFieldnames.entrySet()) {
            void $this$forEach$iv;
            String string;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String k = null;
            k = metatag.getValue();
            String metadata = page.getMetadata().get(metatag.getKey());
            if (metadata == null) continue;
            Object $this$trim$iv = k;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            k = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $this$trim$iv = metadata;
            $i$f$trim = false;
            $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            metadata = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $this$trim$iv = k;
            $i$f$trim = false;
            if (!($this$trim$iv.length() > 0)) continue;
            $this$trim$iv = metadata;
            $i$f$trim = false;
            if (!($this$trim$iv.length() > 0)) continue;
            $this$trim$iv = metadata;
            String $i$f$trim22 = "\t";
            int n = 0;
            $i$f$trim22 = new Regex($i$f$trim22);
            n = 0;
            $i$f$trim2 = false;
            $this$trim$iv = $i$f$trim22.split((CharSequence)$this$trim$iv, n);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                doc.addIfAbsent(k, (Object)it2);
            }
        }
        return doc;
    }

    private static final void setup$lambda-0(String metatag) {
        Intrinsics.checkNotNullParameter((Object)metatag, (String)"metatag");
        String string = metatag;
        Object object = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase((Locale)object);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String key = "meta_" + string3;
        String value = "meta_" + metatag;
        object = parseFieldnames;
        bl = false;
        object.put(key, value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/index/MetadataIndexer$Companion;", "", "()V", "INDEX_PREFIX", "", "PARSE_CONF_PROPERTY", "PARSE_META_PREFIX", "parseFieldnames", "", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

