/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.solr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010J;\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lai/platon/pulsar/solr/SolrUtils;", "", "()V", "HTTP_CLIENT", "Lorg/apache/http/client/HttpClient;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "setLOG", "(Lorg/slf4j/Logger;)V", "getCloudSolrClient", "Lorg/apache/solr/client/solrj/impl/CloudSolrClient;", "zkHosts", "", "", "([Ljava/lang/String;)Lorg/apache/solr/client/solrj/impl/CloudSolrClient;", "getHttpSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "url", "getSolrClient", "solrUrl", "getSolrClients", "Ljava/util/ArrayList;", "solrUrls", "collection", "([Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Ljava/util/ArrayList;", "pulsar-index"})
public final class SolrUtils {
    @NotNull
    public static final SolrUtils INSTANCE = new SolrUtils();
    private static Logger LOG = LoggerFactory.getLogger(SolrUtils.class);
    @NotNull
    private static final HttpClient HTTP_CLIENT = (HttpClient)new SystemDefaultHttpClient();

    private SolrUtils() {
    }

    public final Logger getLOG() {
        return LOG;
    }

    public final void setLOG(Logger logger) {
        LOG = logger;
    }

    @NotNull
    public final ArrayList<SolrClient> getSolrClients(@NotNull String[] solrUrls, @NotNull String[] zkHosts, @Nullable String collection) {
        Intrinsics.checkNotNullParameter((Object)solrUrls, (String)"solrUrls");
        Intrinsics.checkNotNullParameter((Object)zkHosts, (String)"zkHosts");
        ArrayList<SolrClient> solrClients = new ArrayList<SolrClient>();
        for (String solrUrl : solrUrls) {
            HttpSolrClient httpSolrClient = new HttpSolrClient.Builder(solrUrl).withHttpClient(HTTP_CLIENT).build();
            Intrinsics.checkNotNullExpressionValue((Object)httpSolrClient, (String)"Builder(solrUrl)\n       \u2026\n                .build()");
            SolrClient client = (SolrClient)httpSolrClient;
            solrClients.add(client);
        }
        if (solrClients.isEmpty()) {
            CloudSolrClient client = this.getCloudSolrClient(Arrays.copyOf(zkHosts, zkHosts.length));
            client.setDefaultCollection(collection);
            solrClients.add((SolrClient)client);
        }
        return solrClients;
    }

    @NotNull
    public final SolrClient getSolrClient(@Nullable String solrUrl) {
        HttpSolrClient httpSolrClient = new HttpSolrClient.Builder(solrUrl).withHttpClient(HTTP_CLIENT).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpSolrClient, (String)"Builder(solrUrl)\n       \u2026ENT)\n            .build()");
        return (SolrClient)httpSolrClient;
    }

    @NotNull
    public final CloudSolrClient getCloudSolrClient(String ... zkHosts) {
        Intrinsics.checkNotNullParameter((Object)zkHosts, (String)"zkHosts");
        CloudSolrClient client = new CloudSolrClient.Builder().withZkHost((Collection)Lists.newArrayList((Object[])Arrays.copyOf(zkHosts, zkHosts.length))).withHttpClient(HTTP_CLIENT).build();
        client.setParallelUpdates(true);
        client.connect();
        Intrinsics.checkNotNullExpressionValue((Object)client, (String)"client");
        return client;
    }

    @NotNull
    public final SolrClient getHttpSolrClient(@Nullable String url) {
        HttpSolrClient httpSolrClient = new HttpSolrClient.Builder(url).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpSolrClient, (String)"Builder(url).build()");
        return (SolrClient)httpSolrClient;
    }
}

