/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.solr;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexField;
import ai.platon.pulsar.crawl.index.IndexWriter;
import ai.platon.pulsar.crawl.index.IndexerMapping;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.solr.SolrUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.avro.util.Utf8;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u0012\u0010\u000b\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\nJ\n\u00103\u001a\u0004\u0018\u00010\nH\u0016J\b\u00104\u001a\u000205H\u0016J\u0012\u00106\u001a\u00020+2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u00106\u001a\u00020+2\b\u00107\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u00108\u001a\u00020+J\u0016\u00109\u001a\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0010\u0010;\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010<\u001a\u00020+2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0012\u0010?\u001a\u00020+2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0019\u001a(\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\n0\n \u001b*\u0014\u0012\u000e\b\u0001\u0012\n \u001b*\u0004\u0018\u00010\n0\n\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R6\u0010)\u001a(\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\n0\n \u001b*\u0014\u0012\u000e\b\u0001\u0012\n \u001b*\u0004\u0018\u00010\n0\n\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u0006A"}, d2={"Lai/platon/pulsar/solr/SolrIndexWriter;", "Lai/platon/pulsar/crawl/index/IndexWriter;", "indexerMapping", "Lai/platon/pulsar/crawl/index/IndexerMapping;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/index/IndexerMapping;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "batchSize", "", "collection", "", "delete", "", "deleteIds", "", "inputDocs", "Lorg/apache/solr/common/SolrInputDocument;", "<set-?>", "isActive", "()Z", "numDeletes", "solrClients", "Lorg/apache/solr/client/solrj/SolrClient;", "solrParams", "Lorg/apache/solr/common/params/ModifiableSolrParams;", "solrUrls", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "totalAdds", "totalDeletes", "totalUpdates", "updateDocs", "", "webDb", "Lai/platon/pulsar/persist/WebDb;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "setWebDb", "(Lai/platon/pulsar/persist/WebDb;)V", "writeFile", "zkHosts", "close", "", "commit", "convertIndexField", "", "field", "key", "deleteByQuery", "query", "describe", "getParams", "Lai/platon/pulsar/common/config/Params;", "open", "solrUrl", "push", "reportFailure", "failedDocs", "setup", "update", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "write", "Companion", "pulsar-index"})
public final class SolrIndexWriter
implements IndexWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexerMapping indexerMapping;
    @NotNull
    private final List<SolrInputDocument> inputDocs;
    @NotNull
    private final List<SolrInputDocument> updateDocs;
    @NotNull
    private final List<String> deleteIds;
    @Nullable
    private ImmutableConfig conf;
    private String[] solrUrls;
    private String[] zkHosts;
    @Nullable
    private String collection;
    @Nullable
    private List<SolrClient> solrClients;
    @Nullable
    private ModifiableSolrParams solrParams;
    @Nullable
    private WebDb webDb;
    private boolean isActive;
    private int batchSize;
    private int numDeletes;
    private int totalAdds;
    private int totalDeletes;
    private final int totalUpdates;
    private boolean delete;
    private final boolean writeFile;
    private static final Logger LOG = LoggerFactory.getLogger(SolrIndexWriter.class);
    @NotNull
    public static final String INDEXER_PARAMS = "index.additional.params";
    @NotNull
    public static final String INDEXER_DELETE = "index.delete";
    @NotNull
    public static final String INDEXER_REPORT_PAGE_HOME = "http://pulsar.platon.ai/report/indexer";

    public SolrIndexWriter(@NotNull IndexerMapping indexerMapping, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)indexerMapping, (String)"indexerMapping");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.indexerMapping = indexerMapping;
        this.inputDocs = new ArrayList();
        this.updateDocs = new ArrayList();
        this.deleteIds = new ArrayList();
        this.solrUrls = ArrayUtils.EMPTY_STRING_ARRAY;
        this.zkHosts = ArrayUtils.EMPTY_STRING_ARRAY;
        this.setup(conf);
    }

    @Nullable
    public final WebDb getWebDb() {
        return this.webDb;
    }

    public final void setWebDb(@Nullable WebDb webDb) {
        this.webDb = webDb;
    }

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    public void setup(@NotNull ImmutableConfig conf) {
        void $this$forEach$iv;
        Object message;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        String[] stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"EMPTY_STRING_ARRAY");
        String[] stringArray2 = stringArray;
        this.solrUrls = conf.getStrings("indexer.url", Arrays.copyOf(stringArray2, stringArray2.length));
        stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"EMPTY_STRING_ARRAY");
        stringArray2 = stringArray;
        this.zkHosts = conf.getStrings("indexer.zookeeper.hosts", Arrays.copyOf(stringArray2, stringArray2.length));
        this.collection = conf.get("indexer.collection");
        if (this.solrUrls == null && this.zkHosts == null) {
            message = "Either Zookeeper URL or SOLR URL is required";
            message = (String)message + StringsKt.trimIndent((String)("\n                \n                " + this.describe() + "\n                "));
            LOG.error((String)message);
            throw new RuntimeException("Failed to init SolrIndexWriter");
        }
        this.batchSize = conf.getInt("indexer.write.commit.size", 250);
        this.delete = conf.getBoolean(INDEXER_DELETE, false);
        this.solrParams = new ModifiableSolrParams();
        message = conf.getKvs(INDEXER_PARAMS);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"conf.getKvs(INDEXER_PARAMS)");
        boolean $i$f$forEach = false;
        void var4_5 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = var4_5.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] element$iv;
            String[] $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            String[] stringArray3 = $dstr$key$value;
            boolean bl3 = false;
            String key = (String)stringArray3.getKey();
            String[] stringArray4 = $dstr$key$value;
            boolean bl4 = false;
            String value = (String)stringArray4.getValue();
            ModifiableSolrParams modifiableSolrParams = this.solrParams;
            Intrinsics.checkNotNull((Object)modifiableSolrParams);
            stringArray4 = new String[]{value};
            modifiableSolrParams.add(key, stringArray4);
        }
        LOG.info(this.getParams().format());
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"batchSize", this.batchSize, "delete", this.delete, "solrParams", this.solrParams, "zkHosts", StringUtils.join((Object[])this.zkHosts, (String)", "), "solrUrls", StringUtils.join((Object[])this.solrUrls, (String)", "), "collection", this.collection};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"classNa\u2026on\", collection\n        )");
        return params;
    }

    public void open(@Nullable ImmutableConfig conf) {
        String[] stringArray = this.solrUrls;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"solrUrls");
        String[] stringArray2 = stringArray;
        stringArray = this.zkHosts;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"zkHosts");
        this.solrClients = SolrUtils.INSTANCE.getSolrClients(stringArray2, stringArray, this.collection);
        this.isActive = true;
    }

    public void open(@Nullable String solrUrl) {
        Object[] objectArray = new SolrClient[]{SolrUtils.INSTANCE.getSolrClient(solrUrl)};
        this.solrClients = Lists.newArrayList((Object[])objectArray);
        this.isActive = true;
    }

    public final void deleteByQuery(@NotNull String query) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        try {
            LOG.info("SolrWriter: deleting " + query);
            List<SolrClient> list = this.solrClients;
            Intrinsics.checkNotNull(list);
            for (SolrClient solrClient : list) {
                solrClient.deleteByQuery(query);
            }
        }
        catch (SolrServerException e) {
            LOG.error("Error deleting: " + this.deleteIds);
            throw new IOException(e);
        }
    }

    public void delete(@Nullable String key) throws IOException {
        String key2 = key;
        try {
            key2 = URLDecoder.decode(key2, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error decoding: " + key2);
            throw new IOException("UnsupportedEncodingException for " + key2);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not decode: " + key2 + ", it probably wasn't encoded in the first place..");
        }
        String string = key2;
        Intrinsics.checkNotNull((Object)string);
        Object object = string;
        String string2 = "!";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "\\!";
        boolean bl2 = false;
        key2 = string2.replace((CharSequence)object, string3);
        if (this.delete) {
            this.deleteIds.add(key2);
            object = this;
            int n = ((SolrIndexWriter)object).totalDeletes;
            ((SolrIndexWriter)object).totalDeletes = n + 1;
        }
        if (this.deleteIds.size() >= this.batchSize) {
            this.push();
        }
    }

    public void update(@Nullable IndexDocument doc) throws IOException {
        this.write(doc);
    }

    public void write(@Nullable IndexDocument doc) throws IOException {
        SolrInputDocument inputDoc = new SolrInputDocument(new String[0]);
        IndexDocument indexDocument = doc;
        Intrinsics.checkNotNull((Object)indexDocument);
        Object object = indexDocument.getFields();
        boolean bl = false;
        Object object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            boolean bl2 = false;
            String key1 = (String)object3.getKey();
            Object object4 = object;
            boolean bl3 = false;
            IndexField value = (IndexField)object4.getValue();
            String string = this.indexerMapping.mapKeyIfExists(key1);
            if (string == null) continue;
            String key = string;
            float weight = value.getWeight();
            for (Object field : value.getValues()) {
                Object val2 = this.convertIndexField(field);
                boolean isMultiValued = this.indexerMapping.isMultiValued(key1);
                if (!isMultiValued) {
                    if (inputDoc.getField(key) != null) continue;
                    inputDoc.addField(key, val2, weight);
                    continue;
                }
                inputDoc.addField(key, val2, weight);
            }
        }
        inputDoc.setDocumentBoost(doc.getWeight());
        this.inputDocs.add(inputDoc);
        object2 = this;
        int n = ((SolrIndexWriter)object2).totalAdds;
        ((SolrIndexWriter)object2).totalAdds = n + 1;
        if (this.inputDocs.size() + this.numDeletes >= this.batchSize) {
            this.push();
        }
    }

    private final Object convertIndexField(Object field) {
        String field2 = null;
        if (field instanceof Date) {
            field2 = DateTimes.INSTANCE.isoInstantFormat((Date)field);
        } else if (field instanceof Instant) {
            field2 = DateTimes.isoInstantFormat((Instant)((Instant)field));
        } else if (field instanceof Utf8) {
            field2 = field.toString();
        }
        return field;
    }

    public void close() throws IOException {
        if (!this.isActive()) {
            return;
        }
        this.commit();
        List<SolrClient> list = this.solrClients;
        Intrinsics.checkNotNull(list);
        for (SolrClient solrClient : list) {
            solrClient.close();
        }
        List<SolrClient> list2 = this.solrClients;
        Intrinsics.checkNotNull(list2);
        list2.clear();
        this.isActive = false;
    }

    public void commit() throws IOException {
        if (!this.isActive() || this.inputDocs.isEmpty()) {
            return;
        }
        this.push();
        try {
            List<SolrClient> list = this.solrClients;
            Intrinsics.checkNotNull(list);
            for (SolrClient solrClient : list) {
                solrClient.commit();
            }
        }
        catch (SolrServerException e) {
            LOG.error("Failed to write to solr " + e);
            LOG.info(this.describe());
            throw new IOException(e);
        }
        catch (SolrException e) {
            LOG.error("Failed to write to solr " + e);
            LOG.info(this.describe());
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push() throws IOException {
        if (this.inputDocs.size() > 0) {
            Object message = "Indexing " + this.inputDocs.size() + "/" + this.totalAdds + " documents";
            if (this.numDeletes > 0) {
                message = (String)message + ", deleting " + this.numDeletes + " ones";
            }
            LOG.info((String)message);
            this.numDeletes = 0;
            UpdateRequest req = new UpdateRequest();
            req.add((Collection)this.inputDocs);
            req.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, false, false);
            req.setParams(this.solrParams);
            try {
                List<SolrClient> list = this.solrClients;
                Intrinsics.checkNotNull(list);
                for (SolrClient solrClient : list) {
                    solrClient.request((SolrRequest)req);
                }
            }
            catch (SolrServerException e) {
                LOG.error("Failed to write to solr " + e);
                LOG.info(this.describe());
                throw new IOException(e);
            }
            catch (SolrException e) {
                LOG.error("Failed to write to solr " + e);
                LOG.info(this.describe());
                throw new IOException(e);
            }
            finally {
                this.reportFailure(this.inputDocs);
                this.inputDocs.clear();
            }
        }
        if (this.deleteIds.size() > 0) {
            try {
                LOG.info("SolrIndexer: deleting " + this.deleteIds.size() + "/" + this.totalDeletes + " documents");
                List<SolrClient> list = this.solrClients;
                Intrinsics.checkNotNull(list);
                for (SolrClient solrClient : list) {
                    solrClient.deleteById(this.deleteIds);
                }
            }
            catch (SolrServerException e) {
                LOG.error("Error deleting: " + this.deleteIds);
                throw new IOException(e);
            }
            catch (SolrException e) {
                LOG.error("Error deleting: " + this.deleteIds);
                throw new IOException(e);
            }
            finally {
                this.deleteIds.clear();
            }
        }
    }

    private final void reportFailure(List<? extends SolrInputDocument> failedDocs) {
        if (this.webDb == null) {
            return;
        }
        WebPage webPage = WebPage.newInternalPage((String)"http://pulsar.platon.ai/report/indexer/solr/failure", (String)"Failed solr indexing pages");
        Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"newInternalPage(INDEXER_\u2026led solr indexing pages\")");
        WebPage page = webPage;
        failedDocs.stream().map(SolrIndexWriter::reportFailure$lambda-1).map(SolrIndexWriter::reportFailure$lambda-2).forEach(arg_0 -> SolrIndexWriter.reportFailure$lambda-3(page, arg_0));
        WebDb webDb = this.webDb;
        Intrinsics.checkNotNull((Object)webDb);
        WebDb.put$default((WebDb)webDb, (WebPage)page, (boolean)false, (int)2, null);
        WebDb webDb2 = this.webDb;
        Intrinsics.checkNotNull((Object)webDb2);
        webDb2.flush();
    }

    @Nullable
    public String describe() {
        StringBuilder sb = new StringBuilder("SOLRIndexWriter\n");
        sb.append("\t").append("indexer.url").append(" : URL of the indexer instance\n");
        sb.append("\t").append("indexer.zookeeper.hosts").append(" : URL of the Zookeeper quorum\n");
        sb.append("\t").append("indexer.collection").append(" : indexer collection\n");
        sb.append("\t").append("indexer.write.commit.size").append(" : buffer size when sending to SOLR (default 1000)\n");
        sb.append("\t").append("indexer.mapping.file").append(" : name of the mapping file for fields (default solrindex-mapping.xml)\n");
        sb.append("\t").append("solr.auth").append(" : use authentication (default false)\n");
        sb.append("\t").append("solr.auth.username").append(" : username for authentication\n");
        sb.append("\t").append("solr.auth.password").append(" : password for authentication\n");
        return sb.toString();
    }

    @NotNull
    public String getName() {
        return IndexWriter.DefaultImpls.getName((IndexWriter)this);
    }

    private static final String reportFailure$lambda-1(SolrInputDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = doc.get((Object)"url");
        Intrinsics.checkNotNull((Object)object);
        return ((SolrInputField)object).getValue().toString();
    }

    private static final HyperlinkPersistable reportFailure$lambda-2(String url) {
        String string = url;
        Intrinsics.checkNotNull((Object)string);
        return new HyperlinkPersistable(string);
    }

    private static final void reportFailure$lambda-3(WebPage $page, HyperlinkPersistable l) {
        Intrinsics.checkNotNullParameter((Object)$page, (String)"$page");
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Map map = $page.getVividLinks();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"page.vividLinks");
        String string = l.getUrl();
        String string2 = "";
        boolean bl = false;
        map.put(string, string2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/solr/SolrIndexWriter$Companion;", "", "()V", "INDEXER_DELETE", "", "INDEXER_PARAMS", "INDEXER_REPORT_PAGE_HOME", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

