/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/index/AnchorIndexingFilter;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "deduplicate", "", "filter", "Lai/platon/pulsar/crawl/index/IndexDocument;", "doc", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "getParams", "Lai/platon/pulsar/common/config/Params;", "setup", "", "Companion", "pulsar-index"})
public final class AnchorIndexingFilter
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableConfig conf;
    private boolean deduplicate;
    private static final Logger LOG = LoggerFactory.getLogger(AnchorIndexingFilter.class);

    public AnchorIndexingFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        this.deduplicate = conf.getBoolean("anchorIndexingFilter.deduplicate", true);
    }

    @NotNull
    public Params getParams() {
        Params params = Params.of((String)"anchor.indexing.filter.deduplicate", (Object)this.deduplicate, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\"anchor.indexing.filt\u2026eduplicate\", deduplicate)");
        return params;
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        HashSet<String> set = null;
        Object object = page.getInlinks();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.inlinks");
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            CharSequence value = (CharSequence)object2.getValue();
            String anchor = ((Object)value).toString();
            if (Intrinsics.areEqual((Object)anchor, (Object)"")) continue;
            if (this.deduplicate) {
                String lcAnchor;
                if (set == null) {
                    set = new HashSet<String>();
                }
                String string = anchor;
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                if (set.contains(lcAnchor)) continue;
                doc.add("anchor", (Object)anchor);
                set.add(lcAnchor);
                continue;
            }
            doc.add("anchor", (Object)anchor);
        }
        return doc;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/index/AnchorIndexingFilter$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

