/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingException;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GFieldGroup;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/index/GeneralIndexingFilter;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "addDocFields", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "fields", "", "", "filter", "getParams", "Lai/platon/pulsar/common/config/Params;", "setup", "Companion", "pulsar-index"})
public final class GeneralIndexingFilter
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableConfig conf;
    private static int maxContentLength;

    public GeneralIndexingFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        maxContentLength = conf.getInt("index.max.content.length", 100000);
        IndexingFilter.LOG.info(this.getParams().formatAsLine());
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"maxContentLength", maxContentLength};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"classNa\u2026axContentLength\n        )");
        return params;
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) throws IndexingException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        doc.addIfAbsent("id", (Object)doc.getKey());
        doc.addIfAbsent("url", (Object)url);
        String string = StringUtils.substringBefore((String)page.getArgs(), (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringBefore(page.args, \" \")");
        doc.addIfAbsent("seed_url", (Object)string);
        this.addDocFields(doc, url, page);
        return doc;
    }

    private final void addDocFields(IndexDocument doc, String url, WebPage page) {
        page.getPageModel().unbox().forEach(arg_0 -> GeneralIndexingFilter.addDocFields$lambda-0(this, doc, arg_0));
    }

    private final void addDocFields(IndexDocument doc, Map<CharSequence, ? extends CharSequence> fields) {
        fields.entrySet().stream().filter(GeneralIndexingFilter::addDocFields$lambda-1).forEach(arg_0 -> GeneralIndexingFilter.addDocFields$lambda-2(doc, arg_0));
    }

    private static final void addDocFields$lambda-0(GeneralIndexingFilter this$0, IndexDocument $doc, GFieldGroup p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$doc, (String)"$doc");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Map map = p.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"p.fields");
        this$0.addDocFields($doc, map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean addDocFields$lambda-1(Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getValue() == null) return false;
        Object v = e.getValue();
        Intrinsics.checkNotNull(v);
        if (((CharSequence)v).length() >= maxContentLength) return false;
        return true;
    }

    private static final void addDocFields$lambda-2(IndexDocument $doc, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)$doc, (String)"$doc");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getKey().toString();
        Object v = e.getValue();
        Intrinsics.checkNotNull(v);
        $doc.addIfAbsent(string, v);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/index/GeneralIndexingFilter$Companion;", "", "()V", "maxContentLength", "", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

