/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.MimeTypeResolver;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/platon/pulsar/index/MoreIndexingFilter;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "MIME", "Lai/platon/pulsar/common/MimeTypeResolver;", "(Lai/platon/pulsar/common/MimeTypeResolver;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getMIME", "()Lai/platon/pulsar/common/MimeTypeResolver;", "setMIME", "(Lai/platon/pulsar/common/MimeTypeResolver;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "matcher", "Lorg/apache/oro/text/regex/PatternMatcher;", "addLength", "Lai/platon/pulsar/crawl/index/IndexDocument;", "doc", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "", "addTime", "addType", "filter", "setup", "", "toString", "Companion", "pulsar-index"})
public final class MoreIndexingFilter
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MimeTypeResolver MIME;
    @NotNull
    private ImmutableConfig conf;
    @NotNull
    private final PatternMatcher matcher;

    public MoreIndexingFilter(@NotNull MimeTypeResolver MIME, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)MIME, (String)"MIME");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.MIME = MIME;
        this.conf = conf;
        this.matcher = (PatternMatcher)new Perl5Matcher();
        this.setup(this.getConf());
    }

    @NotNull
    public final MimeTypeResolver getMIME() {
        return this.MIME;
    }

    public final void setMIME(@NotNull MimeTypeResolver mimeTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)mimeTypeResolver, (String)"<set-?>");
        this.MIME = mimeTypeResolver;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public MoreIndexingFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new MimeTypeResolver(conf), conf);
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        this.MIME = new MimeTypeResolver(conf);
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.addTime(doc, page, url);
        this.addLength(doc, page, url);
        this.addType(doc, page, url);
        String filename = page.getHeaders().getDispositionFilename();
        if (filename != null) {
            doc.removeField((CharSequence)"meta_title");
            doc.add("meta_title", (Object)filename);
        }
        return doc;
    }

    private final IndexDocument addTime(IndexDocument doc, WebPage page, String url) {
        Instant instant;
        Instant time = Instant.EPOCH;
        String lastModified = page.getHeaders().get("Last-Modified");
        if (lastModified != null) {
            instant = Instant.EPOCH;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
            time = DateTimes.parseHttpDateTime((String)lastModified, (Instant)instant);
        }
        if (time.toEpochMilli() > 0L) {
            time = page.getModifiedTime();
        }
        if (time.toEpochMilli() > 0L) {
            instant = time;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"time");
            doc.add("header_last_modified", (Object)DateTimes.isoInstantFormat((Instant)instant));
            instant = time;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"time");
            doc.add("last_modified_s", (Object)DateTimes.isoInstantFormat((Instant)instant));
        }
        return doc;
    }

    private final IndexDocument addLength(IndexDocument doc, WebPage page, String url) {
        CharSequence contentLength = page.getHeaders().get("Content-Length");
        if (contentLength != null) {
            String $this$trim$iv = ((Object)contentLength).toString();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            CharSequence charSequence = trimmed;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                doc.add("content_length", (Object)trimmed);
            }
        }
        return doc;
    }

    private final IndexDocument addType(IndexDocument doc, WebPage page, String url) {
        String mimeType = null;
        CharSequence charSequence = page.getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"page.contentType");
        CharSequence contentType = charSequence;
        charSequence = contentType;
        boolean bl = false;
        if (charSequence.length() == 0) {
            charSequence = page.getHeaders().getOrDefault("Content-Type", "");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"page.headers.getOrDefaul\u2026Headers.CONTENT_TYPE, \"\")");
            contentType = charSequence;
        }
        charSequence = contentType;
        bl = false;
        String string = mimeType = charSequence.length() == 0 ? this.MIME.getMimeType(url) : this.MIME.forName(MimeTypeResolver.cleanMimeType((String)contentType));
        if (mimeType == null) {
            return doc;
        }
        doc.add("mime_type", (Object)mimeType);
        ImmutableConfig immutableConfig = this.getConf();
        Intrinsics.checkNotNull((Object)immutableConfig);
        if (immutableConfig.getBoolean("moreIndexingFilter.indexMimeTypeParts", true)) {
            String[] parts;
            for (String part : parts = Companion.getParts(mimeType)) {
                doc.add("mime_type", (Object)part);
            }
        }
        return doc;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/index/MoreIndexingFilter$Companion;", "", "()V", "getParts", "", "", "mimeType", "(Ljava/lang/String;)[Ljava/lang/String;", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getParts(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            String string = "/";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            Collection $this$toTypedArray$iv = string.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

