/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.index;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingException;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.persist.WebPage;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/index/MetadataIndexer;", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "addGeneralMetadata", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "addHost", "addPageMetadata", "addTime", "filter", "getParams", "Lai/platon/pulsar/common/config/Params;", "setup", "Companion", "pulsar-index"})
public final class MetadataIndexer
implements IndexingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableConfig conf;
    @NotNull
    private static final String PARSE_CONF_PROPERTY = "index.metadata";
    @NotNull
    private static final String INDEX_PREFIX = "meta_";
    @NotNull
    private static final String PARSE_META_PREFIX = "meta_";
    @NotNull
    private static final Map<String, String> parseFieldnames = new TreeMap();

    public MetadataIndexer(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    public void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public void setup(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
        conf.getStringCollection(PARSE_CONF_PROPERTY).forEach(MetadataIndexer::setup$lambda-0);
    }

    @NotNull
    public Params getParams() {
        return new Params();
    }

    @Nullable
    public IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) throws IndexingException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        try {
            this.addTime(doc, url, page);
            this.addHost(doc, url, page);
            this.addGeneralMetadata(doc, url, page);
            this.addPageMetadata(doc, url, page);
        }
        catch (IndexingException e) {
            IndexingFilter.LOG.error(e.toString());
        }
        return doc;
    }

    private final void addHost(IndexDocument doc, String url, WebPage page) throws IndexingException {
        String url2;
        block5: {
            block4: {
                url2 = url;
                CharSequence charSequence = page.getReprUrl();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"page.reprUrl");
                String reprUrlString = charSequence;
                charSequence = reprUrlString;
                boolean bl = false;
                String string = url2 = charSequence.length() == 0 ? url2 : reprUrlString;
                if (url2 == null) break block4;
                charSequence = url2;
                bl = false;
                if (!(charSequence.length() == 0)) break block5;
            }
            return;
        }
        try {
            URL u = new URL(url2);
            String domain = URLUtil.INSTANCE.getDomainName(u);
            doc.add("url", (Object)url2);
            doc.add("domain", (Object)domain);
            doc.addIfNotNull("host", (Object)u.getHost());
        }
        catch (MalformedURLException e) {
            throw new IndexingException((Throwable)e);
        }
    }

    private final void addTime(IndexDocument doc, String url, WebPage page) {
        Instant now = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        String crawlTimeStr = DateTimes.isoInstantFormat((Instant)now);
        Instant instant = page.getFirstFetchTime();
        Instant firstFetchTime = instant == null ? now : instant;
        String string = page.getFetchTimeHistory(crawlTimeStr);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.getFetchTimeHistory(crawlTimeStr)");
        String fetchTimeHistory = string;
        doc.add("first_crawl_time", (Object)DateTimes.isoInstantFormat((Instant)firstFetchTime));
        doc.add("last_crawl_time", (Object)crawlTimeStr);
        doc.add("fetch_time_history", (Object)fetchTimeHistory);
        String indexTimeStr = DateTimes.isoInstantFormat((Instant)now);
        Instant firstIndexTime = page.getFirstIndexTime(now);
        String indexTimeHistory = page.getIndexTimeHistory(indexTimeStr);
        Intrinsics.checkNotNullExpressionValue((Object)firstIndexTime, (String)"firstIndexTime");
        doc.add("first_index_time", (Object)DateTimes.isoInstantFormat((Instant)firstIndexTime));
        doc.add("last_index_time", (Object)indexTimeStr);
        doc.add("index_time_history", (Object)indexTimeHistory);
    }

    private final void addGeneralMetadata(IndexDocument doc, String url, WebPage page) throws IndexingException {
        String string = page.getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.contentType");
        String contentType = string;
        if (!StringsKt.contains$default((CharSequence)contentType, (CharSequence)"html", (boolean)false, (int)2, null)) {
            IndexingFilter.LOG.warn("Content type " + contentType + " is not fully supported");
        }
        doc.add("content_type", (Object)contentType);
    }

    /*
     * WARNING - void declaration
     */
    private final IndexDocument addPageMetadata(IndexDocument doc, String url, WebPage page) {
        if (doc == null || parseFieldnames.isEmpty()) {
            return doc;
        }
        for (Map.Entry<String, String> metatag : parseFieldnames.entrySet()) {
            boolean bl;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String k = metatag.getValue();
            String metadata = page.getMetadata().get(metatag.getKey());
            if (k == null || metadata == null) continue;
            CharSequence $this$trim$iv = k;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            int $i$f$trim2 = 0;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            k = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $this$trim$iv = metadata;
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = 0;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl4 = false;
                boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            metadata = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $this$trim$iv = k;
            $i$f$trim = false;
            if ($this$trim$iv.length() == 0) continue;
            $this$trim$iv = metadata;
            Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv, (String)"metadata");
            $i$f$trim = false;
            if ($this$trim$iv.length() == 0) continue;
            String finalK = k;
            if (StringsKt.equals((String)finalK, (String)"meta_description", (boolean)true)) {
                void $this$toTypedArray$iv;
                Object $i$f$trim3 = metadata;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim3, (String)"metadata");
                $i$f$trim3 = (CharSequence)$i$f$trim3;
                $this$trim$iv$iv = "\t";
                $i$f$trim2 = 0;
                $this$trim$iv$iv = new Regex((String)$this$trim$iv$iv);
                $i$f$trim2 = 0;
                bl = false;
                $i$f$trim3 = $this$trim$iv$iv.split((CharSequence)$i$f$trim3, $i$f$trim2);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Arrays.stream(stringArray).forEach(arg_0 -> MetadataIndexer.addPageMetadata$lambda-3(doc, finalK, arg_0));
                continue;
            }
            Object $this$toTypedArray$iv = metadata;
            Intrinsics.checkNotNullExpressionValue((Object)$this$toTypedArray$iv, (String)"metadata");
            $this$toTypedArray$iv = (CharSequence)$this$toTypedArray$iv;
            String $i$f$toTypedArray = "\t";
            int thisCollection$iv = 0;
            $i$f$toTypedArray = new Regex($i$f$toTypedArray);
            thisCollection$iv = 0;
            bl = false;
            $this$toTypedArray$iv = $i$f$toTypedArray.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv);
            boolean $i$f$toTypedArray2 = false;
            Object thisCollection$iv2 = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv2.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Arrays.stream(stringArray).forEach(arg_0 -> MetadataIndexer.addPageMetadata$lambda-4(doc, finalK, arg_0));
        }
        return doc;
    }

    private static final void setup$lambda-0(String metatag) {
        Intrinsics.checkNotNullParameter((Object)metatag, (String)"metatag");
        String string = metatag;
        Object object = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase((Locale)object);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String key = "meta_" + string3;
        String value = "meta_" + metatag;
        object = parseFieldnames;
        bl = false;
        object.put(key, value);
    }

    private static final void addPageMetadata$lambda-3(IndexDocument $doc, String $finalK, String v) {
        Intrinsics.checkNotNullParameter((Object)$finalK, (String)"$finalK");
        String string = v;
        Intrinsics.checkNotNull((Object)string);
        $doc.addIfAbsent($finalK, (Object)string);
    }

    private static final void addPageMetadata$lambda-4(IndexDocument $doc, String $finalK, String v) {
        Intrinsics.checkNotNullParameter((Object)$finalK, (String)"$finalK");
        $doc.add($finalK, (Object)v);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/index/MetadataIndexer$Companion;", "", "()V", "INDEX_PREFIX", "", "PARSE_CONF_PROPERTY", "PARSE_META_PREFIX", "parseFieldnames", "", "pulsar-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

