/**
 * Autogenerated by Avro
 * <p>
 * DO NOT EDIT DIRECTLY
 */
package ai.platon.pulsar.persist;

import ai.platon.pulsar.persist.gora.generated.GParseStatus;
import ai.platon.pulsar.persist.metadata.ParseStatusCodes;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ParseStatus implements ParseStatusCodes {

    public static final String REFRESH_HREF = "refreshHref";

    public static final String REFRESH_TIME = "refreshTime";


    public static final HashMap<Short, String> majorCodes = new HashMap<>();

    public static final HashMap<Integer, String> minorCodes = new HashMap<>();

    static {
        majorCodes.put(NOTPARSED, "notparsed");
        majorCodes.put(SUCCESS, "success");
        majorCodes.put(FAILED, "failed");

        minorCodes.put(SUCCESS_OK, "ok");
        minorCodes.put(SUCCESS_REDIRECT, "redirect");

        minorCodes.put(FAILED_EXCEPTION, "exception");
        minorCodes.put(FAILED_NOT_SPECIFIED, "not_specified");
        minorCodes.put(FAILED_TRUNCATED, "truncated");
        minorCodes.put(FAILED_INVALID_FORMAT, "invalid_format");
        minorCodes.put(FAILED_MISSING_PARTS, "missing_parts");
        minorCodes.put(FAILED_MISSING_CONTENT, "missing_content");
        minorCodes.put(FAILED_NO_PARSER, "no_parser");
        minorCodes.put(FAILED_MALFORMED_URL, "malformed_url");
        minorCodes.put(FAILED_UNKNOWN_ENCODING, "unknown_encoding");
    }

    private final GParseStatus parseStatus;

    public ParseStatus(short majorCode, int minorCode) {
        this.parseStatus = GParseStatus.newBuilder().build();
        setMajorCode(majorCode);
        setMinorCode(minorCode);
    }

    public ParseStatus(short majorCode, int minorCode, String message) {
        this.parseStatus = GParseStatus.newBuilder().build();
        setMajorCode(majorCode);
        setMinorCode(minorCode);
        getArgs().put(getMinorName(minorCode), message == null ? "(unknown)" : message);
    }

    private ParseStatus(GParseStatus parseStatus) {
        this.parseStatus = parseStatus;
    }

    @Nonnull
    public static ParseStatus box(GParseStatus parseStatus) {
        Objects.requireNonNull(parseStatus);
        return new ParseStatus(parseStatus);
    }

    public static String getMajorName(short code) {
        return majorCodes.getOrDefault(code, "unknown");
    }

    public static String getMinorName(int code) {
        return minorCodes.getOrDefault(code, "unknown");
    }

    public GParseStatus unbox() {
        return parseStatus;
    }

    public void setCode(short majorCode, int minorCode) {
        setMajorCode(majorCode);
        setMinorCode(minorCode);
    }

    public String getMajorName() {
        return getMajorName(getMajorCode());
    }

    public short getMajorCode() {
        return parseStatus.getMajorCode().shortValue();
    }

    public void setMajorCode(short majorCode) {
        parseStatus.setMajorCode((int) majorCode);
    }

    public String getMinorName() {
        return getMinorName(getMinorCode());
    }

    public int getMinorCode() {
        return parseStatus.getMinorCode();
    }

    public void setMinorCode(int minorCode) {
        parseStatus.setMinorCode(minorCode);
    }

    public void setMinorCode(int minorCode, String message) {
        setMinorCode(minorCode);
        getArgs().put(getMinorName(), message);
    }

    public Map<CharSequence, CharSequence> getArgs() {
        return parseStatus.getArgs();
    }

    public void setArgs(Map<CharSequence, CharSequence> args) {
        parseStatus.setArgs(args);
    }

    public void setSuccessOK() {
        setCode(ParseStatus.SUCCESS, ParseStatus.SUCCESS_OK);
    }

    public void setFailed(int minorCode, String message) {
        setMajorCode(FAILED);
        setMinorCode(minorCode, message);
    }

    public boolean isParsed() {
        return getMajorCode() != NOTPARSED;
    }

    public boolean isSuccess() {
        return getMajorCode() == SUCCESS;
    }

    public boolean isFailed() {
        return getMajorCode() == FAILED;
    }

    public boolean isRedirect() {
        return isSuccess() && getMinorCode() == SUCCESS_REDIRECT;
    }

    public String getName() {
        return majorCodes.getOrDefault(getMajorCode(), "unknown") + "/"
                + minorCodes.getOrDefault(getMinorCode(), "unknown");
    }

    public String getArgOrDefault(String name, String defaultValue) {
        return getArgs().getOrDefault(name, defaultValue).toString();
    }

    @Override
    public String toString() {
        String args = getArgs().entrySet().stream()
                .map(e -> Pair.of(e.getKey().toString(), e.getValue() == null ? "(null)" : e.getValue().toString()))
                .map(e -> e.getKey() + ": " + e.getValue())
                .collect(Collectors.joining(", "));

        return getName() +
                " (" + getMajorCode() + "/" + getMinorCode() + ")" +
                ", args=[" + args + "]";
    }
}
