/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.driver.chrome.common.ChromeOptions;
import ai.platon.pulsar.browser.driver.chrome.common.LauncherOptions;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.fetch.driver.Browser;
import ai.platon.pulsar.crawl.fetch.driver.BrowserEvents;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import ai.platon.pulsar.protocol.browser.BrowserLaunchException;
import ai.platon.pulsar.protocol.browser.driver.BrowserFactory;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u0019J\u0010\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0007J\b\u0010$\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010$\u001a\u0004\u0018\u00010\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002J*\u0010'\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0\fJ \u0010-\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0006\u00102\u001a\u00020\u0019R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_browsers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "Lai/platon/pulsar/crawl/fetch/driver/Browser;", "browserFactory", "Lai/platon/pulsar/protocol/browser/driver/BrowserFactory;", "browsers", "", "getBrowsers", "()Ljava/util/Map;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closedBrowsers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "createdBrowsers", "logger", "Lorg/slf4j/Logger;", "close", "", "closeBrowser", "browser", "browserId", "closeDriver", "driver", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "closeLeastValuableDriver", "destroyBrowserForcibly", "destroyZombieBrowsersForcibly", "findBrowser", "findLeastValuableDriver", "drivers", "", "launch", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "capabilities", "", "", "launchIfAbsent", "launcherOptions", "Lai/platon/pulsar/browser/driver/chrome/common/LauncherOptions;", "launchOptions", "Lai/platon/pulsar/browser/driver/chrome/common/ChromeOptions;", "maintain", "pulsar-protocol"})
public class BrowserManager
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final BrowserFactory browserFactory;
    @NotNull
    private final ConcurrentHashMap<BrowserId, Browser> _browsers;
    @NotNull
    private final ConcurrentLinkedDeque<Browser> createdBrowsers;
    @NotNull
    private final ConcurrentLinkedDeque<Browser> closedBrowsers;
    @NotNull
    private final Map<BrowserId, Browser> browsers;

    public BrowserManager(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.logger = LogsKt.getLogger((Object)this);
        this.closed = new AtomicBoolean();
        this.browserFactory = new BrowserFactory();
        this._browsers = new ConcurrentHashMap();
        this.createdBrowsers = new ConcurrentLinkedDeque();
        this.closedBrowsers = new ConcurrentLinkedDeque();
        this.browsers = this._browsers;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final Map<BrowserId, Browser> getBrowsers() {
        return this.browsers;
    }

    @NotNull
    public final Browser launch(@NotNull BrowserId browserId, @NotNull WebDriverSettings driverSettings, @NotNull Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        LauncherOptions launcherOptions = new LauncherOptions((BrowserSettings)driverSettings, null, null, 6, null);
        if (driverSettings.isSupervised()) {
            launcherOptions.setSupervisorProcess(driverSettings.getSupervisorProcess());
            List list = launcherOptions.getSupervisorProcessArgs();
            Collection collection = driverSettings.getSupervisorProcessArgs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"driverSettings.supervisorProcessArgs");
            list.addAll(collection);
        }
        ChromeOptions launchOptions = driverSettings.createChromeOptions(capabilities);
        return this.launchIfAbsent(browserId, launcherOptions, launchOptions);
    }

    @Nullable
    public final synchronized Browser findBrowser(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        return this.browsers.get(browserId);
    }

    public final synchronized void closeBrowser(@NotNull BrowserId browserId) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Browser browser = this._browsers.remove(browserId);
        if (browser != null) {
            boolean bl;
            boolean bl2;
            Object object;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                browser.close();
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                bl2 = false;
                bl = false;
                Throwable throwable3 = throwable2;
                boolean bl7 = false;
                Throwable it = throwable3;
                boolean bl8 = false;
                this.logger.warn(ExceptionsKt.brief$default((Throwable)it, (String)"Failed to close browser\n", null, (int)2, null));
            }
            this.closedBrowsers.add(browser);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void destroyBrowserForcibly(@NotNull BrowserId browserId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Iterable $this$filter$iv = this.createdBrowsers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Browser it = (Browser)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)browserId, (Object)it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            boolean bl2;
            Object object;
            Browser browser = (Browser)element$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                object = Result.Companion;
                boolean bl5 = false;
                browser.destroyForcibly();
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl6 = false;
            boolean bl7 = false;
            if (Result.exceptionOrNull-impl((Object)object2) != null) {
                Throwable throwable;
                bl2 = false;
                bl = false;
                Throwable throwable2 = throwable;
                boolean bl8 = false;
                Throwable it = throwable2;
                boolean bl9 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, (String)"Failed to close browser\n", null, (int)2, null));
            }
            this.closedBrowsers.add(browser);
        }
    }

    public final synchronized void closeBrowser(@NotNull Browser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.closeBrowser(browser.getId());
    }

    public final synchronized void closeDriver(@NotNull WebDriver driver) {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                driver.close();
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn(ExceptionsKt.brief$default((Throwable)it, (String)"Failed to close driver\n", null, (int)2, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized WebDriver findLeastValuableDriver() {
        Object v0;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.browsers.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WebDriver webDriver;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Browser it = (Browser)element$iv$iv;
            boolean bl2 = false;
            if (this.findLeastValuableDriver(it.getDrivers().values()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            WebDriver it$iv$iv = webDriver;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                WebDriver it = (WebDriver)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getLastActiveTime();
                do {
                    Object e$iv = iterator$iv.next();
                    WebDriver it2 = (WebDriver)e$iv;
                    $i$a$-minByOrNull-BrowserManager$findLeastValuableDriver$2 = false;
                    Comparable v$iv = it2.getLastActiveTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final synchronized void closeLeastValuableDriver() {
        WebDriver driver = this.findLeastValuableDriver();
        if (driver != null) {
            this.closeDriver(driver);
        }
    }

    public final synchronized void destroyZombieBrowsersForcibly() {
        List zombieBrowsers = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)this.createdBrowsers, (Iterable)CollectionsKt.toSet((Iterable)this.browsers.values())), (Iterable)this.closedBrowsers);
        Collection collection = zombieBrowsers;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.logger.warn("There are {} zombie browsers, cleaning them ...", (Object)zombieBrowsers.size());
            Iterable $this$forEach$iv = zombieBrowsers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable throwable;
                boolean bl2;
                boolean bl3;
                Object object;
                Browser browser = (Browser)element$iv;
                boolean bl4 = false;
                this.logger.info("Closing zombie browser {} ...", (Object)browser.getId());
                boolean bl5 = false;
                try {
                    object = Result.Companion;
                    boolean bl6 = false;
                    browser.destroyForcibly();
                    Unit unit = Unit.INSTANCE;
                    bl3 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    bl2 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                Object object2 = object;
                boolean bl7 = false;
                boolean bl8 = false;
                if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
                bl3 = false;
                bl2 = false;
                Throwable throwable3 = throwable;
                boolean bl9 = false;
                Throwable it = throwable3;
                boolean bl10 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WebDriver findLeastValuableDriver(Iterable<? extends WebDriver> drivers) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable<? extends WebDriver> $this$filter$iv = drivers;
        boolean $i$f$filter = false;
        Iterable<? extends WebDriver> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebDriver it = (WebDriver)element$iv$iv;
            boolean bl = false;
            if (!(!it.isReady() && !it.isWorking())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                WebDriver it = (WebDriver)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getLastActiveTime();
                do {
                    Object e$iv = iterator$iv.next();
                    WebDriver it2 = (WebDriver)e$iv;
                    $i$a$-minByOrNull-BrowserManager$findLeastValuableDriver$4 = false;
                    Comparable v$iv = it2.getLastActiveTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void maintain() {
        Iterable $this$forEach$iv = this.browsers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Browser it = (Browser)element$iv;
            boolean bl = false;
            it.emit((Object)BrowserEvents.willMaintain);
            it.emit((Object)BrowserEvents.maintain);
            it.emit((Object)BrowserEvents.didMaintain);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<Browser> collection = this._browsers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"_browsers.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable throwable;
                boolean bl;
                boolean bl2;
                Object object;
                Browser browser = (Browser)element$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                try {
                    object = Result.Companion;
                    boolean bl5 = false;
                    browser.close();
                    Unit unit = Unit.INSTANCE;
                    bl2 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    bl = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                Object object2 = object;
                boolean bl6 = false;
                boolean bl7 = false;
                if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
                bl2 = false;
                bl = false;
                Throwable throwable3 = throwable;
                boolean bl8 = false;
                Throwable it = throwable3;
                boolean bl9 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
            }
            this._browsers.clear();
        }
    }

    private final synchronized Browser launchIfAbsent(BrowserId browserId, LauncherOptions launcherOptions, ChromeOptions launchOptions) throws BrowserLaunchException {
        Browser browser = this._browsers.computeIfAbsent(browserId, arg_0 -> BrowserManager.launchIfAbsent$lambda-19(this, browserId, launcherOptions, launchOptions, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)browser, (String)"_browsers.computeIfAbsen\u2026 launchOptions)\n        }");
        Browser browser2 = browser;
        this.createdBrowsers.add(browser2);
        return browser2;
    }

    private static final Browser launchIfAbsent$lambda-19(BrowserManager this$0, BrowserId $browserId, LauncherOptions $launcherOptions, ChromeOptions $launchOptions, BrowserId it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$browserId, (String)"$browserId");
        Intrinsics.checkNotNullParameter((Object)$launcherOptions, (String)"$launcherOptions");
        Intrinsics.checkNotNullParameter((Object)$launchOptions, (String)"$launchOptions");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.browserFactory.launch($browserId, $launcherOptions, $launchOptions);
    }
}

