/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.protocol.browser.driver.BrowserManager;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\tJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006%"}, d2={"Lai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool;", "", "browserManager", "Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "capacity", "", "(Lai/platon/pulsar/protocol/browser/driver/BrowserManager;I)V", "_closedDrivers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "_retiredDrivers", "_standbyDrivers", "Ljava/util/concurrent/ArrayBlockingQueue;", "_workingDrivers", "closedDrivers", "Ljava/util/Queue;", "getClosedDrivers", "()Ljava/util/Queue;", "logger", "Lorg/slf4j/Logger;", "retiredDrivers", "getRetiredDrivers", "standbyDrivers", "getStandbyDrivers", "workingDrivers", "getWorkingDrivers", "cancelAll", "", "close", "driver", "offer", "poll", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "retire", "pulsar-protocol"})
public final class ConcurrentStatefulDriverPool {
    @NotNull
    private final BrowserManager browserManager;
    private final int capacity;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayBlockingQueue<WebDriver> _standbyDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _workingDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _retiredDrivers;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _closedDrivers;

    public ConcurrentStatefulDriverPool(@NotNull BrowserManager browserManager, int capacity) {
        Intrinsics.checkNotNullParameter((Object)browserManager, (String)"browserManager");
        this.browserManager = browserManager;
        this.capacity = capacity;
        this.logger = LogsKt.getLogger((Object)this);
        this._standbyDrivers = new ArrayBlockingQueue(2 * this.capacity);
        this._workingDrivers = new ConcurrentLinkedQueue();
        this._retiredDrivers = new ConcurrentLinkedQueue();
        this._closedDrivers = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final Queue<WebDriver> getStandbyDrivers() {
        return this._standbyDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getWorkingDrivers() {
        return this._workingDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getRetiredDrivers() {
        return this._retiredDrivers;
    }

    @NotNull
    public final Queue<WebDriver> getClosedDrivers() {
        return this._closedDrivers;
    }

    @Nullable
    public final synchronized WebDriver poll(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        WebDriver driver = this._standbyDrivers.poll(timeout, unit);
        if (driver != null) {
            driver.startWork();
            this._workingDrivers.add(driver);
        }
        return driver;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void offer(@NotNull WebDriver driver) {
        void $this$offer_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this._workingDrivers.remove(driver);
        WebDriver webDriver = driver;
        boolean bl = false;
        boolean bl2 = false;
        WebDriver webDriver2 = webDriver;
        ArrayBlockingQueue<WebDriver> arrayBlockingQueue = this._standbyDrivers;
        boolean bl3 = false;
        $this$offer_u24lambda_u2d0.free();
        Unit unit = Unit.INSTANCE;
        arrayBlockingQueue.offer(webDriver);
    }

    public final synchronized void close(@NotNull WebDriver driver) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            this._standbyDrivers.remove(driver);
            this._workingDrivers.remove(driver);
            this._retiredDrivers.remove(driver);
            this._closedDrivers.add(driver);
            ConcurrentStatefulDriverPool concurrentStatefulDriverPool = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                ConcurrentStatefulDriverPool $this$close_u24lambda_u2d1 = concurrentStatefulDriverPool;
                boolean bl2 = false;
                $this$close_u24lambda_u2d1.browserManager.closeDriver(driver);
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            concurrentStatefulDriverPool = object;
            bl = false;
            boolean bl5 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)concurrentStatefulDriverPool);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn(ExceptionsKt.brief$default((Throwable)it, (String)("[Unexpected] Closing " + driver), null, (int)2, null));
        }
    }

    public final synchronized void retire() {
        List drivers = CollectionsKt.plus((Collection)this._standbyDrivers, (Iterable)this._workingDrivers);
        this._standbyDrivers.clear();
        this._workingDrivers.clear();
        this._retiredDrivers.addAll(drivers);
        Iterable $this$forEach$iv = drivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            WebDriver driver = (WebDriver)element$iv;
            boolean bl = false;
            driver.cancel();
            driver.retire();
            boolean bl2 = false;
            try {
                object = Result.Companion;
                boolean bl3 = false;
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(driver, null){
                    int label;
                    final /* synthetic */ WebDriver $driver;
                    {
                        this.$driver = $driver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$driver.stop((Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                Unit unit = Unit.INSTANCE;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    public final synchronized void cancelAll() {
        Iterable $this$forEach$iv = this._workingDrivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebDriver it = (WebDriver)element$iv;
            boolean bl = false;
            it.cancel();
        }
    }

    public final synchronized void close() {
    }
}

