/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppSystemInfo;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.driver.Browser;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import ai.platon.pulsar.protocol.browser.BrowserLaunchException;
import ai.platon.pulsar.protocol.browser.driver.ConcurrentStatefulDriverPool;
import ai.platon.pulsar.protocol.browser.driver.WebDriverFactory;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.emulator.WebDriverPoolExhaustedException;
import com.codahale.metrics.Meter;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 y2\u00020\u0001:\u0002yzB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[J\u0010\u0010\\\u001a\u0004\u0018\u00010\u00142\u0006\u0010]\u001a\u00020^J\u0006\u0010_\u001a\u00020YJ\u0006\u0010`\u001a\u00020YJ\u0018\u0010a\u001a\u00020Y2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020[H\u0002J\u0010\u0010c\u001a\u00020Y2\u0006\u0010b\u001a\u00020[H\u0002J\u001c\u0010d\u001a\u0004\u0018\u00010\u00142\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020,0fJ\u001a\u0010g\u001a\u00020Y2\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020Y0fJ\u0010\u0010i\u001a\u00020Y2\u0006\u0010j\u001a\u00020\u0014H\u0002J\u0010\u0010k\u001a\u00020Y2\u0006\u0010j\u001a\u00020\u0014H\u0002J\u0006\u0010l\u001a\u00020\u0014J\u000e\u0010l\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020[J\u001e\u0010l\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020[2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pJ\u001e\u0010l\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010m\u001a\u00020#J&\u0010l\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pJ*\u0010q\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pH\u0002J\u000e\u0010r\u001a\u00020Y2\u0006\u0010j\u001a\u00020\u0014J\u0018\u0010s\u001a\u00020Y2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020[H\u0002J\u0006\u0010t\u001a\u00020YJ\b\u0010u\u001a\u00020,H\u0002J\u0006\u0010v\u001a\u00020wJ\b\u0010x\u001a\u00020^H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0019\u0010\"\u001a\n $*\u0004\u0018\u00010#0#8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\n $*\u0004\u0018\u00010#0#8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010-R\u0011\u0010.\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u000e\u0010/\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0002012\u0006\u00100\u001a\u000201@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0016\u00109\u001a\n $*\u0004\u0018\u00010:0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010>R\u0011\u0010A\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001bR\u0011\u0010C\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001bR\u0011\u0010E\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001bR\u0011\u0010G\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001bR\u0011\u0010I\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001bR\u0011\u0010K\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001bR\u0011\u0010M\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001bR\u0011\u0010O\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u001bR\u0011\u0010Q\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u001bR\u000e\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020WX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool;", "", "browserId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "priority", "", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "driverFactory", "Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;ILai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_browser", "Lai/platon/pulsar/crawl/fetch/driver/Browser;", "_numCreatedDrivers", "Ljava/util/concurrent/atomic/AtomicInteger;", "_numWaitingTasks", "activeDrivers", "", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "getActiveDrivers", "()Ljava/util/Collection;", "getBrowserId", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "capacity", "getCapacity", "()I", "getDriverFactory", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "id", "getId", "idleTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getIdleTime", "()Ljava/time/Duration;", "idleTimeout", "getIdleTimeout", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "isIdle", "isRetired", "<set-?>", "Ljava/time/Instant;", "lastActiveTime", "getLastActiveTime", "()Ljava/time/Instant;", "launched", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getLaunched", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lorg/slf4j/Logger;", "meterClosed", "Lcom/codahale/metrics/Meter;", "getMeterClosed", "()Lcom/codahale/metrics/Meter;", "meterOffer", "getMeterOffer", "numActive", "getNumActive", "numAvailable", "getNumAvailable", "numClosed", "getNumClosed", "numCreated", "getNumCreated", "numDriverSlots", "getNumDriverSlots", "numRetired", "getNumRetired", "numStandby", "getNumStandby", "numWaiting", "getNumWaiting", "numWorking", "getNumWorking", "getPriority", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "statefulDriverPool", "Lai/platon/pulsar/protocol/browser/driver/ConcurrentStatefulDriverPool;", "allocate", "", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "cancel", "url", "", "cancelAll", "close", "createDriver", "volatileConfig", "doCreateDriver", "firstOrNull", "predicate", "Lkotlin/Function1;", "forEach", "action", "logDriverOnline", "driver", "offerOrDismiss", "poll", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "pollWebDriver", "put", "resourceSafeCreateDriverIfNecessary", "retire", "shouldCreateWebDriver", "takeSnapshot", "Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Snapshot;", "toString", "Companion", "Snapshot", "pulsar-protocol"})
public final class LoadingWebDriverPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserId browserId;
    private final int priority;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final WebDriverFactory driverFactory;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    private final int id;
    @NotNull
    private final AppMetricRegistry registry;
    @Nullable
    private Browser _browser;
    @NotNull
    private final ConcurrentStatefulDriverPool statefulDriverPool;
    @NotNull
    private final Meter meterClosed;
    @NotNull
    private final Meter meterOffer;
    private boolean isRetired;
    @NotNull
    private final AtomicBoolean launched;
    @NotNull
    private final AtomicInteger _numCreatedDrivers;
    @NotNull
    private final AtomicInteger _numWaitingTasks;
    @NotNull
    private Instant lastActiveTime;
    private static Duration CLOSE_ALL_TIMEOUT = Duration.ofSeconds(60L);
    private static Duration POLLING_TIMEOUT = Duration.ofSeconds(60L);
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();

    public LoadingWebDriverPool(@NotNull BrowserId browserId, int priority, @NotNull WebDriverPoolManager driverPoolManager, @NotNull WebDriverFactory driverFactory, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)driverFactory, (String)"driverFactory");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.browserId = browserId;
        this.priority = priority;
        this.driverPoolManager = driverPoolManager;
        this.driverFactory = driverFactory;
        this.immutableConfig = immutableConfig;
        this.logger = LoggerFactory.getLogger(LoadingWebDriverPool.class);
        this.id = instanceSequencer.incrementAndGet();
        this.registry = AppMetrics.Companion.getDefaultMetricRegistry();
        this.statefulDriverPool = new ConcurrentStatefulDriverPool(this.driverPoolManager.getBrowserManager(), this.getCapacity());
        this.meterClosed = this.registry.meter((Object)this, "closed");
        this.meterOffer = this.registry.meter((Object)this, "offer");
        this.launched = new AtomicBoolean();
        this._numCreatedDrivers = new AtomicInteger();
        this._numWaitingTasks = new AtomicInteger();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastActiveTime = instant;
    }

    public /* synthetic */ LoadingWebDriverPool(BrowserId browserId, int n, WebDriverPoolManager webDriverPoolManager, WebDriverFactory webDriverFactory, ImmutableConfig immutableConfig, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(browserId, n, webDriverPoolManager, webDriverFactory, immutableConfig);
    }

    @NotNull
    public final BrowserId getBrowserId() {
        return this.browserId;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @NotNull
    public final WebDriverFactory getDriverFactory() {
        return this.driverFactory;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    public final int getId() {
        return this.id;
    }

    public final int getCapacity() {
        return this.immutableConfig.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
    }

    private final Collection<WebDriver> getActiveDrivers() {
        return CollectionsKt.plus((Collection)this.statefulDriverPool.getStandbyDrivers(), (Iterable)this.statefulDriverPool.getWorkingDrivers());
    }

    @NotNull
    public final Meter getMeterClosed() {
        return this.meterClosed;
    }

    @NotNull
    public final Meter getMeterOffer() {
        return this.meterOffer;
    }

    public final boolean isActive() {
        return !this.isRetired && AppContext.INSTANCE.isActive();
    }

    @NotNull
    public final AtomicBoolean getLaunched() {
        return this.launched;
    }

    public final int getNumCreated() {
        return this._numCreatedDrivers.get();
    }

    public final int getNumWaiting() {
        return this._numWaitingTasks.get();
    }

    public final int getNumStandby() {
        return this.statefulDriverPool.getStandbyDrivers().size();
    }

    public final int getNumAvailable() {
        return this.getNumStandby() + this.getNumDriverSlots();
    }

    public final int getNumWorking() {
        return this.statefulDriverPool.getWorkingDrivers().size();
    }

    public final int getNumRetired() {
        return this.statefulDriverPool.getRetiredDrivers().size();
    }

    public final int getNumClosed() {
        return this.statefulDriverPool.getClosedDrivers().size();
    }

    public final int getNumActive() {
        return this.getNumWorking() + this.getNumStandby();
    }

    public final int getNumDriverSlots() {
        return this.getCapacity() - this.getNumActive();
    }

    @NotNull
    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final Duration getIdleTimeout() {
        Duration duration = Duration.ofMinutes(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(20)");
        return this.immutableConfig.getDuration("browser.driver.pool.idle.timeout", duration);
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.getNumWorking() == 0 && this.getIdleTime().compareTo(this.getIdleTimeout()) > 0;
    }

    public final void allocate(@NotNull VolatileConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        int n = this.getCapacity();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            Throwable throwable;
            Object object;
            int it = n2;
            boolean bl2 = false;
            LoadingWebDriverPool loadingWebDriverPool = this;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                LoadingWebDriverPool $this$allocate_u24lambda_u2d2_u24lambda_u2d0 = loadingWebDriverPool;
                boolean bl4 = false;
                $this$allocate_u24lambda_u2d2_u24lambda_u2d0.put($this$allocate_u24lambda_u2d2_u24lambda_u2d0.poll($this$allocate_u24lambda_u2d2_u24lambda_u2d0.getPriority(), conf, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS));
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            loadingWebDriverPool = object;
            bl3 = false;
            boolean bl7 = false;
            if (Result.exceptionOrNull-impl((Object)loadingWebDriverPool) == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            Throwable throwable3 = throwable;
            boolean bl10 = false;
            Throwable it2 = throwable3;
            boolean bl11 = false;
            this.logger.warn("Unexpected exception", it2);
        }
    }

    @NotNull
    public final WebDriver poll() {
        return this.poll(VolatileConfig.Companion.getUNSAFE());
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.poll(0, conf, POLLING_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(@NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.poll(0, conf, timeout, unit);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, @NotNull Duration timeout) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.poll(0, conf, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @NotNull
    public final WebDriver poll(int priority, @NotNull VolatileConfig conf, long timeout, @NotNull TimeUnit unit) throws BrowserLaunchException, WebDriverPoolExhaustedException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        WebDriver driver = this.pollWebDriver(priority, conf, timeout, unit);
        if (driver == null) {
            Snapshot snapshot = this.takeSnapshot();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Driver pool is exhausted | %s";
            Object[] objectArray = new Object[]{snapshot.format(true)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message = string2;
            this.logger.warn(message);
            throw new WebDriverPoolExhaustedException("Driver pool is exhausted (" + snapshot + ")");
        }
        return driver;
    }

    public final void put(@NotNull WebDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastActiveTime = instant;
        this.offerOrDismiss(driver);
    }

    private final void offerOrDismiss(WebDriver driver) {
        if (driver.isWorking()) {
            this.statefulDriverPool.offer(driver);
            this.meterOffer.mark();
        } else {
            this.statefulDriverPool.close(driver);
            this.meterClosed.mark();
        }
    }

    public final void retire() {
        this.isRetired = true;
        this.statefulDriverPool.retire();
    }

    public final void close() {
        this.statefulDriverPool.close();
    }

    public final void forEach(@NotNull Function1<? super WebDriver, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.getActiveDrivers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    @Nullable
    public final WebDriver firstOrNull(@NotNull Function1<? super WebDriver, Boolean> predicate) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$firstOrNull$iv = this.getActiveDrivers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final WebDriver cancel(@NotNull String url) {
        WebDriver webDriver;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Iterable $this$lastOrNull$iv = this.getActiveDrivers();
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            WebDriver it = (WebDriver)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNavigateEntry().getPageUrl(), (Object)url)) continue;
            last$iv = element$iv;
        }
        WebDriver webDriver2 = last$iv;
        if (webDriver2 == null) {
            webDriver = null;
        } else {
            WebDriver webDriver3 = webDriver2;
            boolean bl = false;
            boolean bl2 = false;
            WebDriver it = webDriver3;
            boolean bl3 = false;
            it.cancel();
            webDriver = webDriver3;
        }
        return webDriver;
    }

    public final void cancelAll() {
        this.statefulDriverPool.cancelAll();
    }

    @NotNull
    public String toString() {
        return this.takeSnapshot().format(false);
    }

    @NotNull
    public final Snapshot takeSnapshot() {
        int n = this.getNumActive();
        int n2 = this.getNumStandby();
        int n3 = this.getNumWaiting();
        int n4 = this.getNumWorking();
        int n5 = this.getNumDriverSlots();
        int n6 = this.getNumRetired();
        int n7 = this.getNumClosed();
        boolean bl = this.isIdle();
        Duration duration = this.getIdleTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"idleTime");
        return new Snapshot(n, n2, n3, n4, n5, n6, n7, this.isRetired, bl, duration, false, 1024, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WebDriver pollWebDriver(int priority, VolatileConfig conf, long timeout, TimeUnit unit) throws BrowserLaunchException {
        WebDriver webDriver;
        this._numWaitingTasks.incrementAndGet();
        try {
            this.resourceSafeCreateDriverIfNecessary(priority, conf);
            webDriver = this.statefulDriverPool.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            webDriver = null;
        }
        finally {
            this._numWaitingTasks.decrementAndGet();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            this.lastActiveTime = instant;
        }
        WebDriver driver = webDriver;
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resourceSafeCreateDriverIfNecessary(int priority, VolatileConfig volatileConfig) throws BrowserLaunchException {
        WebDriverFactory webDriverFactory = this.driverFactory;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (webDriverFactory) {
            boolean bl3 = false;
            if (!this.shouldCreateWebDriver()) {
                return;
            }
            this.createDriver(priority, volatileConfig);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void createDriver(int priority, VolatileConfig volatileConfig) throws BrowserLaunchException {
        block2: {
            try {
                this.doCreateDriver(volatileConfig);
            }
            catch (BrowserLaunchException e) {
                this.logger.debug("[Unexpected]", (Throwable)((Object)e));
                if (!this.isActive()) break block2;
                throw e;
            }
        }
    }

    private final boolean shouldCreateWebDriver() {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        Browser browser = this._browser;
        if (browser == null) {
            n = 0;
        } else {
            objectArray2 = browser.getDrivers();
            if (objectArray2 == null) {
                n = 0;
            } else {
                objectArray = objectArray2.values();
                if (objectArray == null) {
                    n = 0;
                } else {
                    int n2;
                    int n3;
                    Iterable $this$count$iv = (Iterable)objectArray;
                    boolean $i$f$count = false;
                    if (((Collection)$this$count$iv).isEmpty()) {
                        n3 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            WebDriver it = (WebDriver)element$iv;
                            boolean bl = false;
                            if (!(!it.isQuit())) continue;
                            int n4 = ++count$iv;
                            boolean bl2 = false;
                            if (n4 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n3 = count$iv;
                    }
                    n = n2 = n3;
                }
            }
        }
        int activeDriversInBrowser = n;
        int activeDriversInPool = this.statefulDriverPool.getWorkingDrivers().size() + this.statefulDriverPool.getStandbyDrivers().size();
        if (activeDriversInBrowser != activeDriversInPool) {
            objectArray2 = new Object[]{this.getNumDriverSlots(), activeDriversInPool, activeDriversInBrowser};
            this.logger.warn("Inconsistent online driver status: {}/{}/{} (slots/activeP/activeB)", objectArray2);
        }
        boolean isCriticalResources = AppSystemInfo.Companion.isCriticalResources();
        if (activeDriversInPool >= this.getCapacity()) {
            objectArray = new Object[]{this.getNumDriverSlots(), activeDriversInPool, activeDriversInBrowser};
            this.logger.debug("Enough online drivers: {}/{}/{} (slots/activeP/activeB), will not create new one", objectArray);
        } else if (AppSystemInfo.Companion.isCriticalMemory()) {
            objectArray = new Object[]{Strings.compactFormat((long)AppSystemInfo.Companion.getAvailableMemory()), this.getNumDriverSlots(), activeDriversInPool, activeDriversInBrowser};
            this.logger.info("Critical memory: {}, {}/{}/{} (slots/activeP/activeB), will not create new driver", objectArray);
        }
        return this.isActive() && !isCriticalResources && activeDriversInPool < this.getCapacity();
    }

    private final void doCreateDriver(VolatileConfig volatileConfig) throws BrowserLaunchException {
        WebDriver driver = this.driverFactory.create(this.browserId, this.priority, volatileConfig, false);
        this._browser = driver.getBrowser();
        this._numCreatedDrivers.incrementAndGet();
        this.statefulDriverPool.offer(driver);
        if (this.logger.isDebugEnabled()) {
            this.logDriverOnline(driver);
        }
    }

    private final void logDriverOnline(WebDriver driver) {
        WebDriverSettings driverSettings = this.driverFactory.getDriverSettings();
        Object[] objectArray = new Object[]{this.getNumActive(), driver.getName(), driverSettings.getPageLoadStrategy(), this.getCapacity()};
        this.logger.trace("The {}th web driver is active, browser: {} pageLoadStrategy: {} capacity: {}", objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Companion;", "", "()V", "CLOSE_ALL_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCLOSE_ALL_TIMEOUT", "()Ljava/time/Duration;", "setCLOSE_ALL_TIMEOUT", "(Ljava/time/Duration;)V", "POLLING_TIMEOUT", "getPOLLING_TIMEOUT", "setPOLLING_TIMEOUT", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstanceSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getCLOSE_ALL_TIMEOUT() {
            return CLOSE_ALL_TIMEOUT;
        }

        public final void setCLOSE_ALL_TIMEOUT(Duration duration) {
            CLOSE_ALL_TIMEOUT = duration;
        }

        public final Duration getPOLLING_TIMEOUT() {
            return POLLING_TIMEOUT;
        }

        public final void setPOLLING_TIMEOUT(Duration duration) {
            POLLING_TIMEOUT = duration;
        }

        @NotNull
        public final AtomicInteger getInstanceSequencer() {
            return instanceSequencer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\b\u0010 \u001a\u00020\u001eH\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006!"}, d2={"Lai/platon/pulsar/protocol/browser/driver/LoadingWebDriverPool$Snapshot;", "", "numActive", "", "numStandby", "numWaiting", "numWorking", "numDriverSlots", "numRetired", "numClosed", "isRetired", "", "isIdle", "idleTime", "Ljava/time/Duration;", "lackOfResources", "(IIIIIIIZZLjava/time/Duration;Z)V", "getIdleTime", "()Ljava/time/Duration;", "()Z", "getLackOfResources", "getNumActive", "()I", "getNumClosed", "getNumDriverSlots", "getNumRetired", "getNumStandby", "getNumWaiting", "getNumWorking", "format", "", "verbose", "toString", "pulsar-protocol"})
    public static final class Snapshot {
        private final int numActive;
        private final int numStandby;
        private final int numWaiting;
        private final int numWorking;
        private final int numDriverSlots;
        private final int numRetired;
        private final int numClosed;
        private final boolean isRetired;
        private final boolean isIdle;
        @NotNull
        private final Duration idleTime;
        private final boolean lackOfResources;

        public Snapshot(int numActive, int numStandby, int numWaiting, int numWorking, int numDriverSlots, int numRetired, int numClosed, boolean isRetired, boolean isIdle2, @NotNull Duration idleTime, boolean lackOfResources) {
            Intrinsics.checkNotNullParameter((Object)idleTime, (String)"idleTime");
            this.numActive = numActive;
            this.numStandby = numStandby;
            this.numWaiting = numWaiting;
            this.numWorking = numWorking;
            this.numDriverSlots = numDriverSlots;
            this.numRetired = numRetired;
            this.numClosed = numClosed;
            this.isRetired = isRetired;
            this.isIdle = isIdle2;
            this.idleTime = idleTime;
            this.lackOfResources = lackOfResources;
        }

        public /* synthetic */ Snapshot(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Duration duration, boolean bl3, int n8, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n8 & 0x400) != 0) {
                bl3 = AppSystemInfo.Companion.isCriticalResources();
            }
            this(n, n2, n3, n4, n5, n6, n7, bl, bl2, duration, bl3);
        }

        public final int getNumActive() {
            return this.numActive;
        }

        public final int getNumStandby() {
            return this.numStandby;
        }

        public final int getNumWaiting() {
            return this.numWaiting;
        }

        public final int getNumWorking() {
            return this.numWorking;
        }

        public final int getNumDriverSlots() {
            return this.numDriverSlots;
        }

        public final int getNumRetired() {
            return this.numRetired;
        }

        public final int getNumClosed() {
            return this.numClosed;
        }

        public final boolean isRetired() {
            return this.isRetired;
        }

        public final boolean isIdle() {
            return this.isIdle;
        }

        @NotNull
        public final Duration getIdleTime() {
            return this.idleTime;
        }

        public final boolean getLackOfResources() {
            return this.lackOfResources;
        }

        @NotNull
        public final String format(boolean verbose) {
            String string;
            boolean bl;
            Object[] objectArray;
            String string2;
            StringCompanionObject stringCompanionObject;
            if (verbose) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "active: %d, standby: %d, waiting: %d, working: %d, slots: %d, retired: %d, closed: %d";
                objectArray = new Object[]{this.numActive, this.numStandby, this.numWaiting, this.numWorking, this.numDriverSlots, this.numRetired, this.numClosed};
                bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            } else {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "%d/%d/%d/%d/%d/%d/%d (active/standby/waiting/working/slots/retired/closed)";
                objectArray = new Object[]{this.numActive, this.numStandby, this.numWaiting, this.numWorking, this.numDriverSlots, this.numRetired, this.numClosed};
                bl = false;
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            }
            String status = string;
            String time = DateTimesKt.readable((Duration)this.idleTime);
            return this.lackOfResources ? "[Lack of resource] | " + status : (this.isIdle ? "[Idle] " + time + " | " + status : (this.isRetired ? "[Retired] | " + status : status));
        }

        @NotNull
        public String toString() {
            return this.format(false);
        }
    }
}

