/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.driver;

import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.crawl.fetch.driver.AbstractBrowser;
import ai.platon.pulsar.crawl.fetch.driver.AbstractWebDriver;
import ai.platon.pulsar.crawl.fetch.driver.Browser;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import ai.platon.pulsar.protocol.browser.BrowserLaunchException;
import ai.platon.pulsar.protocol.browser.UnsupportedWebDriverException;
import ai.platon.pulsar.protocol.browser.driver.BrowserManager;
import ai.platon.pulsar.protocol.browser.driver.WebDriverAdapter;
import ai.platon.pulsar.protocol.browser.driver.WebDriverSettings;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsBrowser;
import ai.platon.pulsar.protocol.browser.driver.cdt.ChromeDevtoolsDriver;
import ai.platon.pulsar.protocol.browser.driver.test.MockBrowser;
import ai.platon.pulsar.protocol.browser.driver.test.MockWebDriver;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019J4\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J0\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%H\u0002J0\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0\u001f2\u0006\u0010*\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%H\u0002J$\u0010+\u001a\u00020,2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010-2\u0006\u0010.\u001a\u00020&H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lai/platon/pulsar/protocol/browser/driver/WebDriverFactory;", "", "driverSettings", "Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "browserManager", "Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;Lai/platon/pulsar/protocol/browser/driver/BrowserManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserManager", "()Lai/platon/pulsar/protocol/browser/driver/BrowserManager;", "getDriverSettings", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverSettings;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numDrivers", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "start", "", "browserId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "priority", "", "createBrowserAndDriver", "Lkotlin/Pair;", "Lai/platon/pulsar/crawl/fetch/driver/Browser;", "createChromeDevtoolsDriver", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsBrowser;", "Lai/platon/pulsar/protocol/browser/driver/cdt/ChromeDevtoolsDriver;", "capabilities", "", "", "createMockChromeDevtoolsDriver", "Lai/platon/pulsar/protocol/browser/driver/test/MockBrowser;", "Lai/platon/pulsar/protocol/browser/driver/test/MockWebDriver;", "instanceId", "setProxy", "", "", "proxyServer", "pulsar-protocol"})
public class WebDriverFactory {
    @NotNull
    private final WebDriverSettings driverSettings;
    @NotNull
    private final BrowserManager browserManager;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    @NotNull
    private final AtomicInteger numDrivers;

    public WebDriverFactory(@NotNull WebDriverSettings driverSettings, @NotNull BrowserManager browserManager, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)driverSettings), (String)"driverSettings");
        Intrinsics.checkNotNullParameter((Object)browserManager, (String)"browserManager");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.driverSettings = driverSettings;
        this.browserManager = browserManager;
        this.immutableConfig = immutableConfig;
        this.logger = LoggerFactory.getLogger(WebDriverFactory.class);
        this.numDrivers = new AtomicInteger();
    }

    @NotNull
    public final WebDriverSettings getDriverSettings() {
        return this.driverSettings;
    }

    @NotNull
    public final BrowserManager getBrowserManager() {
        return this.browserManager;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    @NotNull
    public final WebDriver create(boolean start) throws BrowserLaunchException {
        return this.create(this.immutableConfig.toVolatileConfig(), start);
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, boolean bl, int n, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return webDriverFactory.create(bl);
    }

    @NotNull
    public final WebDriver create(@NotNull VolatileConfig conf, boolean start) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return this.create(BrowserId.Companion.getDEFAULT(), 0, conf, start);
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, VolatileConfig volatileConfig, boolean bl, int n, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return webDriverFactory.create(volatileConfig, bl);
    }

    @NotNull
    public final synchronized WebDriver create(@NotNull BrowserId browserId, int priority, @NotNull VolatileConfig conf, boolean start) throws BrowserLaunchException {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return (WebDriver)this.createBrowserAndDriver(browserId, priority, conf, start).getSecond();
    }

    public static /* synthetic */ WebDriver create$default(WebDriverFactory webDriverFactory, BrowserId browserId, int n, VolatileConfig volatileConfig, boolean bl, int n2, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return webDriverFactory.create(browserId, n, volatileConfig, bl);
    }

    @NotNull
    public final synchronized Pair<Browser, WebDriver> createBrowserAndDriver(@NotNull BrowserId browserId, int priority, @NotNull VolatileConfig conf, boolean start) throws BrowserLaunchException {
        int n;
        Object object;
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.logger.debug("Creating web driver #{} | {}", (Object)this.numDrivers.incrementAndGet(), (Object)browserId);
        Map<String, Object> capabilities = this.driverSettings.createGeneralOptions();
        Object object2 = browserId.getProxyServer();
        if (object2 != null) {
            object = object2;
            boolean bl = false;
            n = 0;
            Object it = object;
            boolean bl2 = false;
            this.setProxy(capabilities, (String)it);
        }
        BrowserType browserType = browserId.getBrowserType();
        try {
            Object object3;
            BrowserType browserType2 = browserType;
            n = WhenMappings.$EnumSwitchMapping$0[browserType2.ordinal()];
            switch (n) {
                case 1: {
                    object3 = this.createChromeDevtoolsDriver(browserId, capabilities);
                    break;
                }
                case 2: {
                    object3 = this.createMockChromeDevtoolsDriver(browserId, capabilities);
                    break;
                }
                default: {
                    throw new UnsupportedWebDriverException("Unsupported WebDriver: " + browserType);
                }
            }
            object = object3;
            AbstractBrowser browser = (AbstractBrowser)object.component1();
            AbstractWebDriver driver = (AbstractWebDriver)object.component2();
            if (start) {
                driver.startWork();
            }
            return TuplesKt.to((Object)browser, (Object)((Object)new WebDriverAdapter((WebDriver)driver, priority)));
        }
        catch (BrowserLaunchException e) {
            this.logger.error("Can not launch browser " + browserType + " | {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static /* synthetic */ Pair createBrowserAndDriver$default(WebDriverFactory webDriverFactory, BrowserId browserId, int n, VolatileConfig volatileConfig, boolean bl, int n2, Object object) throws BrowserLaunchException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBrowserAndDriver");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return webDriverFactory.createBrowserAndDriver(browserId, n, volatileConfig, bl);
    }

    private final Pair<ChromeDevtoolsBrowser, ChromeDevtoolsDriver> createChromeDevtoolsDriver(BrowserId browserId, Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        boolean bl = browserId.getBrowserType() == BrowserType.PULSAR_CHROME;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ChromeDevtoolsBrowser browser = (ChromeDevtoolsBrowser)this.browserManager.launch(browserId, this.driverSettings, capabilities);
        return TuplesKt.to((Object)((Object)browser), (Object)((Object)browser.newDriver()));
    }

    private final Pair<MockBrowser, MockWebDriver> createMockChromeDevtoolsDriver(BrowserId instanceId, Map<String, ? extends Object> capabilities) throws BrowserLaunchException {
        boolean bl = instanceId.getBrowserType() == BrowserType.MOCK_CHROME;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        MockBrowser browser = (MockBrowser)this.browserManager.launch(instanceId, this.driverSettings, capabilities);
        Fingerprint fingerprint = Fingerprint.copy$default((Fingerprint)instanceId.getFingerprint(), (BrowserType)BrowserType.PULSAR_CHROME, null, null, null, null, (int)30, null);
        BrowserId backupInstanceId = new BrowserId(instanceId.getContextDir(), fingerprint);
        Function0 backupDriverCreator2 = (Function0)new Function0<ChromeDevtoolsDriver>(this, backupInstanceId, capabilities){
            final /* synthetic */ WebDriverFactory this$0;
            final /* synthetic */ BrowserId $backupInstanceId;
            final /* synthetic */ Map<String, Object> $capabilities;
            {
                this.this$0 = $receiver;
                this.$backupInstanceId = $backupInstanceId;
                this.$capabilities = $capabilities;
                super(0);
            }

            @NotNull
            public final ChromeDevtoolsDriver invoke() {
                return (ChromeDevtoolsDriver)((Object)WebDriverFactory.access$createChromeDevtoolsDriver(this.this$0, this.$backupInstanceId, this.$capabilities).getSecond());
            }
        };
        return TuplesKt.to((Object)((Object)browser), (Object)((Object)new MockWebDriver(browser, (Function0<? extends WebDriver>)backupDriverCreator2)));
    }

    private final void setProxy(Map<String, Object> capabilities, String proxyServer) {
        Map<String, Object> map = capabilities;
        String string = "proxy";
        boolean bl = false;
        map.put(string, proxyServer);
    }

    public static final /* synthetic */ Pair access$createChromeDevtoolsDriver(WebDriverFactory $this, BrowserId browserId, Map capabilities) {
        return $this.createChromeDevtoolsDriver(browserId, capabilities);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserType.values().length];
            nArray[BrowserType.PULSAR_CHROME.ordinal()] = 1;
            nArray[BrowserType.MOCK_CHROME.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

