/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.fetch.FetchResult;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyAgent;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.BrowserPrivacyContext;
import ai.platon.pulsar.protocol.browser.emulator.context.ProxyContext;
import ai.platon.pulsar.protocol.browser.emulator.context.WebDriverContext;
import com.codahale.metrics.Meter;
import com.google.common.annotations.Beta;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B9\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010+\u001a\u00020)H\u0002JC\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'2(\u0010-\u001a$\b\u0001\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020%00\u0012\u0006\u0012\u0004\u0018\u0001010.H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020)H\u0016J\n\u00108\u001a\u0004\u0018\u00010/H\u0017R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/BrowserPrivacyContext;", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContext;", "proxyPoolManager", "Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "id", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyAgent;", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "(Lai/platon/pulsar/common/proxy/ProxyPoolManager;Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/crawl/CoreMetrics;Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/crawl/fetch/privacy/PrivacyAgent;)V", "browserId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "getCoreMetrics", "()Lai/platon/pulsar/crawl/CoreMetrics;", "driverContext", "Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext;", "getDriverPoolManager", "()Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "isFullCapacity", "", "()Z", "isReady", "isRetired", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "proxyContext", "Lai/platon/pulsar/protocol/browser/emulator/context/ProxyContext;", "proxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getProxyPoolManager", "()Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "checkAbnormalResult", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "close", "", "createProxyContext", "createProxyContextIfEnabled", "doRun", "fetchFun", "Lkotlin/Function3;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initialize", "maintain", "promisedWebDriverCount", "", "report", "subscribeWebDriver", "pulsar-protocol"})
public class BrowserPrivacyContext
extends PrivacyContext {
    @Nullable
    private final ProxyPoolManager proxyPoolManager;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @Nullable
    private final CoreMetrics coreMetrics;
    private final Logger logger;
    @Nullable
    private ProxyEntry proxyEntry;
    @NotNull
    private final BrowserId browserId;
    @NotNull
    private final WebDriverContext driverContext;
    @Nullable
    private ProxyContext proxyContext;

    public BrowserPrivacyContext(@Nullable ProxyPoolManager proxyPoolManager, @NotNull WebDriverPoolManager driverPoolManager, @Nullable CoreMetrics coreMetrics, @NotNull ImmutableConfig conf, @NotNull PrivacyAgent id) {
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, conf);
        this.proxyPoolManager = proxyPoolManager;
        this.driverPoolManager = driverPoolManager;
        this.coreMetrics = coreMetrics;
        this.logger = LoggerFactory.getLogger(BrowserPrivacyContext.class);
        this.browserId = new BrowserId(id.getContextDir(), id.getFingerprint());
        this.driverContext = new WebDriverContext(this.browserId, this.driverPoolManager, conf);
    }

    public /* synthetic */ BrowserPrivacyContext(ProxyPoolManager proxyPoolManager, WebDriverPoolManager webDriverPoolManager, CoreMetrics coreMetrics, ImmutableConfig immutableConfig, PrivacyAgent privacyAgent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            proxyPoolManager = null;
        }
        if ((n & 4) != 0) {
            coreMetrics = null;
        }
        this(proxyPoolManager, webDriverPoolManager, coreMetrics, immutableConfig, privacyAgent);
    }

    @Nullable
    public final ProxyPoolManager getProxyPoolManager() {
        return this.proxyPoolManager;
    }

    @NotNull
    public final WebDriverPoolManager getDriverPoolManager() {
        return this.driverPoolManager;
    }

    @Nullable
    public final CoreMetrics getCoreMetrics() {
        return this.coreMetrics;
    }

    public boolean isRetired() {
        ProxyContext proxyContext = this.proxyContext;
        return (proxyContext == null ? false : proxyContext.isRetired()) || this.driverContext.isRetired();
    }

    public boolean isReady() {
        ProxyContext proxyContext;
        boolean isProxyContextReady = this.proxyContext == null || ((proxyContext = this.proxyContext) == null ? false : proxyContext.isReady());
        boolean isDriverContextReady = this.driverContext.isReady();
        return isProxyContextReady && isDriverContextReady && super.isReady();
    }

    public boolean isFullCapacity() {
        return this.driverPoolManager.isFullCapacity(this.browserId);
    }

    @Nullable
    public Object doRun(@NotNull FetchTask task, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> fetchFun, @NotNull Continuation<? super FetchResult> $completion) throws ProxyException {
        return BrowserPrivacyContext.doRun$suspendImpl(this, task, fetchFun, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object doRun$suspendImpl(BrowserPrivacyContext var0, FetchTask var1_1, Function3 var2_2, Continuation var3_3) throws ProxyException {
        block10: {
            block9: {
                if (!(var3_3 instanceof doRun.1)) ** GOTO lbl-1000
                var8_4 = var3_3;
                if ((var8_4.label & -2147483648) != 0) {
                    var8_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, (Continuation<? super doRun.1>)var3_3){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ BrowserPrivacyContext this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return BrowserPrivacyContext.doRun$suspendImpl(this.this$0, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.initialize(task);
                        var4_7 = this.checkAbnormalResult(task);
                        if (var4_7 != null) break block9;
                        var6_8 = this.proxyContext;
                        if (var6_8 != null) ** GOTO lbl19
                        v0 = null;
                        ** GOTO lbl34
lbl19:
                        // 1 sources

                        $continuation.L$0 = this;
                        $continuation.L$1 = task;
                        $continuation.L$2 = fetchFun;
                        $continuation.label = 1;
                        v1 = var6_8.run(task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$continuation);
                        if (v1 == var9_6) {
                            return var9_6;
                        }
                        ** GOTO lbl33
                    }
                    case 1: {
                        fetchFun = (Function3)$continuation.L$2;
                        task = (FetchTask)$continuation.L$1;
                        this = (BrowserPrivacyContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl33:
                        // 2 sources

                        v0 = var5_9 = (FetchResult)v1;
lbl34:
                        // 2 sources

                        if (var5_9 != null) break;
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.label = 2;
                        v2 = this.driverContext.run(task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)fetchFun, (Continuation<? super FetchResult>)$continuation);
                        if (v2 == var9_6) {
                            return var9_6;
                        }
                        ** GOTO lbl46
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl46:
                        // 2 sources

                        return v2;
                    }
                }
                v3 = var5_9;
                break block10;
            }
            v3 = var4_7;
        }
        return v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void maintain() {
        ProxyContext proxyContext = this.proxyContext;
        if (proxyContext != null) {
            proxyContext.maintain();
        }
        this.driverContext.maintain();
    }

    public int promisedWebDriverCount() {
        return this.driverPoolManager.promisedDriverCount(this.browserId);
    }

    @Beta
    @Nullable
    public WebDriver subscribeWebDriver() {
        return this.driverPoolManager.subscribeDriver(this.browserId);
    }

    public void report() {
        ProxyEntry proxyEntry;
        long l;
        long l2;
        Object[] objectArray = new Object[13];
        objectArray[0] = this.getDisplay();
        objectArray[1] = this.isIdle() ? "(idle)" : "";
        objectArray[2] = this.isLeaked() ? "(leaked)" : "";
        Object object = this.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"elapsedTime");
        objectArray[3] = DateTimesKt.readable((Duration)object);
        objectArray[4] = this.getMeterSuccesses().getCount();
        object = StringCompanionObject.INSTANCE;
        String string = "%.2f";
        Object[] objectArray2 = new Object[]{this.getMeterSuccesses().getMeanRate()};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        objectArray[6] = this.getMeterSmallPages().getCount();
        object = StringCompanionObject.INSTANCE;
        string = "%.1f%%";
        objectArray2 = new Object[]{(double)100 * this.getSmallPageRate()};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        object = this.coreMetrics;
        objectArray[8] = Strings.compactFormat((long)(object == null ? 0L : (l2 = object.getTotalNetworkIFsRecvBytes())));
        object = this.coreMetrics;
        objectArray[9] = Strings.compactFormat((long)(object == null ? 0L : (l = object.getNetworkIFsRecvBytesPerSecond())));
        objectArray[10] = this.getMeterTasks().getCount();
        objectArray[11] = this.getMeterFinishes().getCount();
        object = this.proxyContext;
        objectArray[12] = object == null ? null : ((proxyEntry = ((ProxyContext)object).getProxyEntry()) == null ? null : proxyEntry.toString());
        this.logger.info("Privacy context #{}{}{} has lived for {} | success: {}({} pages/s) | small: {}({}) | traffic: {}({}/s) | tasks: {} total run: {} | {}", objectArray);
        if (this.getSmallPageRate() > 0.5) {
            objectArray = new Object[3];
            objectArray[0] = this.getSequence();
            objectArray[1] = this.getMeterSmallPages().getCount();
            object = StringCompanionObject.INSTANCE;
            String string2 = "%.1f%%";
            objectArray2 = new Object[]{(double)100 * this.getSmallPageRate()};
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
            this.logger.warn("Privacy context #{} is disqualified, too many small pages: {}({})", objectArray);
        }
        if (this.getMeterSuccesses().getMeanRate() < 0.0) {
            this.logger.warn("Privacy context #{} is disqualified, it's expected 120 pages in 120 seconds at least", (Object)this.getSequence());
        }
    }

    public void close() {
        this.logger.debug("Closing browser privacy context ...");
        if (this.getClosed().compareAndSet(false, true)) {
            try {
                this.report();
                this.driverContext.close();
                ProxyContext proxyContext = this.proxyContext;
                if (proxyContext != null) {
                    proxyContext.close();
                }
            }
            catch (Exception e) {
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    private final FetchResult checkAbnormalResult(FetchTask task) {
        return !this.isActive() ? FetchResult.Companion.canceled(task, "PRIVACY CX INACTIVE") : null;
    }

    private final synchronized void initialize(FetchTask task) throws ProxyException {
        this.createProxyContextIfEnabled();
        task.getPage().getVariables().set("privacy_context_name", (Object)this.getDisplay());
    }

    private final void createProxyContextIfEnabled() {
        if (this.proxyEntry == null && this.proxyPoolManager != null && this.proxyPoolManager.isEnabled()) {
            this.createProxyContext(this.proxyPoolManager);
        }
    }

    private final void createProxyContext(ProxyPoolManager proxyPoolManager) {
        try {
            Meter meter;
            ProxyContext pc = ProxyContext.Companion.create(this.getId(), this.driverContext, proxyPoolManager, this.getConf());
            this.proxyEntry = pc.getProxyEntry();
            ProxyEntry proxyEntry = this.proxyEntry;
            this.browserId.getFingerprint().setProxyServer(proxyEntry == null ? null : proxyEntry.getHostPort());
            this.proxyContext = pc;
            proxyEntry = this.coreMetrics;
            if (proxyEntry != null && (meter = proxyEntry.getProxies()) != null) {
                meter.mark();
            }
        }
        catch (ProxyException e) {
            this.logger.warn(ExceptionsKt.brief$default((Throwable)e, (String)"Failed to create proxy context - ", null, (int)2, null));
        }
    }
}

