/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.context;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppSystemInfo;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.measure.ByteUnit;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.FetchResult;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import ai.platon.pulsar.protocol.browser.driver.WebDriverPoolManager;
import ai.platon.pulsar.protocol.browser.emulator.context.WebDriverContext;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020 H\u0016JC\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2(\u0010%\u001a$\b\u0001\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0(\u0012\u0006\u0012\u0004\u0018\u00010)0&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020 H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext;", "Ljava/lang/AutoCloseable;", "browserId", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "driverPoolManager", "Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;", "unmodifiedConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;Lai/platon/pulsar/protocol/browser/driver/WebDriverPoolManager;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getBrowserId", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isActive", "", "()Z", "isReady", "isRetired", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "notBusy", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "runningTasks", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "checkAbnormalResult", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "task", "close", "", "closeContext", "closeUnderlyingLayerGracefully", "maintain", "run", "browseFun", "Lkotlin/Function3;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdownUnderlyingLayerImmediately", "waitUntilAllDoneNormally", "timeout", "Ljava/time/Duration;", "waitUntilIdle", "waitUntilNoRunningTasks", "Companion", "pulsar-protocol"})
public class WebDriverContext
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserId browserId;
    @NotNull
    private final WebDriverPoolManager driverPoolManager;
    @NotNull
    private final ImmutableConfig unmodifiedConfig;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentLinkedDeque<FetchTask> runningTasks;
    @NotNull
    private final ReentrantLock lock;
    private final Condition notBusy;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AtomicInteger numGlobalRunningTasks = new AtomicInteger();
    @NotNull
    private static final Meter globalTasks = AppMetrics.Companion.getReg().meter((Object)Companion, "globalTasks");
    @NotNull
    private static final Meter globalFinishedTasks = AppMetrics.Companion.getReg().meter((Object)Companion, "globalFinishedTasks");

    public WebDriverContext(@NotNull BrowserId browserId, @NotNull WebDriverPoolManager driverPoolManager, @NotNull ImmutableConfig unmodifiedConfig) {
        Intrinsics.checkNotNullParameter((Object)browserId, (String)"browserId");
        Intrinsics.checkNotNullParameter((Object)driverPoolManager, (String)"driverPoolManager");
        Intrinsics.checkNotNullParameter((Object)unmodifiedConfig, (String)"unmodifiedConfig");
        this.browserId = browserId;
        this.driverPoolManager = driverPoolManager;
        this.unmodifiedConfig = unmodifiedConfig;
        Logger logger = LoggerFactory.getLogger(WebDriverContext.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.runningTasks = new ConcurrentLinkedDeque();
        this.lock = new ReentrantLock();
        this.notBusy = this.lock.newCondition();
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final BrowserId getBrowserId() {
        return this.browserId;
    }

    public boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    public boolean isRetired() {
        return this.driverPoolManager.isRetiredPool(this.browserId);
    }

    public boolean isReady() {
        boolean isDriverPoolReady = this.driverPoolManager.isReady() && this.driverPoolManager.hasDriverPromise(this.browserId);
        return this.isActive() && isDriverPoolReady;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object run(@NotNull FetchTask var1_1, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2_2, @NotNull Continuation<? super FetchResult> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void maintain() throws Exception {
    }

    @Override
    public void close() {
        block4: {
            boolean bl;
            Object object;
            block5: {
                boolean bl2;
                boolean bl3;
                Object object2;
                if (!this.closed.compareAndSet(false, true)) break block4;
                if (AppContext.INSTANCE.isActive()) break block5;
                boolean bl4 = false;
                try {
                    object2 = Result.Companion;
                    boolean $i$a$-runCatching-WebDriverContext$close$422 = false;
                    this.shutdownUnderlyingLayerImmediately();
                    Unit $i$a$-runCatching-WebDriverContext$close$422 = Unit.INSTANCE;
                    bl3 = false;
                    object2 = Result.constructor-impl((Object)$i$a$-runCatching-WebDriverContext$close$422);
                }
                catch (Throwable $i$a$-runCatching-WebDriverContext$close$422) {
                    Result.Companion companion = Result.Companion;
                    bl2 = false;
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-WebDriverContext$close$422));
                }
                Object object3 = object2;
                boolean bl5 = false;
                boolean $i$a$-runCatching-WebDriverContext$close$422 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable == null) break block4;
                Throwable $i$a$-runCatching-WebDriverContext$close$422 = throwable;
                bl3 = false;
                bl2 = false;
                Throwable throwable2 = $i$a$-runCatching-WebDriverContext$close$422;
                boolean bl6 = false;
                Throwable it = throwable2;
                boolean bl7 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
                break block4;
            }
            boolean bl8 = false;
            try {
                object = Result.Companion;
                boolean bl9 = false;
                this.closeContext();
                Unit unit = Unit.INSTANCE;
                boolean bl10 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object4 = object;
            boolean bl11 = false;
            boolean bl12 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
            if (throwable == null) break block4;
            Throwable throwable3 = throwable;
            boolean bl13 = false;
            bl = false;
            Throwable throwable4 = throwable3;
            boolean bl14 = false;
            Throwable it = throwable4;
            boolean bl15 = false;
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
        }
    }

    private final void closeContext() {
        Duration duration;
        boolean asap = !AppContext.INSTANCE.isActive() || AppSystemInfo.Companion.isCriticalResources();
        this.logger.debug("Closing web driver context, asap: " + asap);
        if (asap) {
            this.closeUnderlyingLayerGracefully();
        } else {
            duration = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
            this.waitUntilAllDoneNormally(duration);
            this.closeUnderlyingLayerGracefully();
        }
        duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(10)");
        this.waitUntilNoRunningTasks(duration);
        String isShutdown = AppContext.INSTANCE.isActive() ? "" : " (shutdown)";
        String display = this.browserId.getDisplay();
        Object[] objectArray = (Object[])this.runningTasks;
        boolean bl = false;
        if (!objectArray.isEmpty()) {
            objectArray = new Object[]{this.runningTasks.size(), CollectionsKt.joinToString$default((Iterable)this.runningTasks, null, null, null, (int)0, null, (Function1)closeContext.1.INSTANCE, (int)31, null), display};
            this.logger.info("Still {} running tasks after context close" + isShutdown + " | {} | {}", objectArray);
        } else {
            this.logger.info("Web driver context is closed successfully" + isShutdown + " | {} | {}", (Object)display, (Object)this.browserId);
        }
    }

    private final void closeUnderlyingLayerGracefully() {
        Iterable $this$forEach$iv = this.runningTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FetchTask it = (FetchTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.driverPoolManager.cancelAll(this.browserId);
        Duration duration = WebDriverPoolManager.Companion.getDRIVER_CLOSE_TIME_OUT();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DRIVER_CLOSE_TIME_OUT");
        this.driverPoolManager.closeDriverPoolGracefully(this.browserId, duration);
    }

    private final void shutdownUnderlyingLayerImmediately() {
        this.logger.info("Shutdown the underlying layer immediately");
        Iterable $this$forEach$iv = this.runningTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FetchTask it = (FetchTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.driverPoolManager.cancelAll();
        this.driverPoolManager.close();
    }

    private final void waitUntilAllDoneNormally(Duration timeout) {
        this.waitUntilIdle(timeout);
    }

    private final void waitUntilNoRunningTasks(Duration timeout) {
        this.waitUntilIdle(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitUntilIdle(Duration timeout) throws InterruptedException {
        String string;
        boolean bl;
        Object[] objectArray;
        String string2;
        Object object;
        long n = timeout.getSeconds();
        this.lock.lockInterruptibly();
        try {
            while (true) {
                Collection collection = this.runningTasks;
                boolean bl2 = false;
                if (!collection.isEmpty() && !AppSystemInfo.Companion.isCriticalResources()) {
                    long l = n;
                    n = l + -1L;
                    if (l > 0L) {
                        this.notBusy.await(1L, TimeUnit.SECONDS);
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        String isShutdown = AppContext.INSTANCE.isActive() ? "" : " (shutdown)";
        String display = this.browserId.getDisplay();
        if (AppSystemInfo.Companion.isCriticalMemory()) {
            object = StringCompanionObject.INSTANCE;
            string2 = "Low memory (%.2fGiB), close %d retired browsers immediately" + isShutdown + " | " + display;
            objectArray = new Object[]{ByteUnit.BYTE.toGiB((double)AppSystemInfo.Companion.getAvailableMemory()), this.runningTasks.size()};
            bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else if (n <= 0L) {
            object = StringCompanionObject.INSTANCE;
            string2 = "Timeout (still %d running tasks)" + isShutdown + " | " + display;
            objectArray = new Object[]{this.runningTasks.size()};
            bl = false;
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        } else if (n > 0L) {
            object = StringCompanionObject.INSTANCE;
            string2 = "All tasks return in %d seconds" + isShutdown + " | " + display;
            objectArray = new Object[]{timeout.getSeconds() - n};
            bl = false;
            String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            string = "";
        }
        String message = string;
        object = message;
        boolean bl3 = false;
        if (!StringsKt.isBlank((CharSequence)object)) {
            this.logger.info(message);
        }
    }

    private final FetchResult checkAbnormalResult(FetchTask task) {
        if (!this.isActive()) {
            return FetchResult.Companion.canceled(task, "Inactive web driver context");
        }
        if (this.driverPoolManager.isRetiredPool(this.browserId)) {
            return FetchResult.Companion.canceled(task, "Retired driver pool");
        }
        return null;
    }

    private static final Integer _init_$lambda-7() {
        return numGlobalRunningTasks.get();
    }

    static {
        AppMetrics.Companion.getReg().register((Object)Companion, "globalRunningTasks", (Metric)((Gauge)WebDriverContext::_init_$lambda-7));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/context/WebDriverContext$Companion;", "", "()V", "globalFinishedTasks", "Lcom/codahale/metrics/Meter;", "globalTasks", "numGlobalRunningTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

