/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.protocol.browser.emulator.impl;

import ai.platon.pulsar.browser.common.InteractSettings;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.HtmlUtils;
import ai.platon.pulsar.common.HtmlsKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.browser.BrowserErrorCode;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.event.AbstractEventEmitter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.BrowserErrorPageException;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.ActiveDOMMessage;
import ai.platon.pulsar.persist.model.ActiveDOMStatTrace;
import ai.platon.pulsar.persist.model.ActiveDOMStatus;
import ai.platon.pulsar.protocol.browser.emulator.BrowserErrorResponse;
import ai.platon.pulsar.protocol.browser.emulator.BrowserResponseEvents;
import ai.platon.pulsar.protocol.browser.emulator.BrowserResponseHandler;
import ai.platon.pulsar.protocol.browser.emulator.NavigateTask;
import ai.platon.pulsar.protocol.browser.emulator.util.ChainedHtmlIntegrityChecker;
import ai.platon.pulsar.protocol.browser.emulator.util.ChainedPageCategorySniffer;
import ai.platon.pulsar.protocol.browser.emulator.util.DefaultHtmlIntegrityChecker;
import ai.platon.pulsar.protocol.browser.emulator.util.DefaultPageCategorySniffer;
import ai.platon.pulsar.protocol.browser.emulator.util.HtmlIntegrityChecker;
import ai.platon.pulsar.protocol.browser.emulator.util.PageCategorySniffer;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020GH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020G2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020EH\u0002J\u001c\u0010U\u001a\u00060Vj\u0002`W2\u0006\u0010X\u001a\u00020N2\u0006\u0010Y\u001a\u00020NH\u0016J\u0010\u0010Z\u001a\u00020E2\u0006\u0010P\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020E2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020E2\u0006\u0010`\u001a\u00020aH\u0016J \u0010b\u001a\u00020E2\u0006\u0010P\u001a\u00020Q2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fH\u0016J\u0018\u0010g\u001a\u00020E2\u0006\u0010P\u001a\u00020Q2\u0006\u0010c\u001a\u00020dH\u0016R\u001b\u0010\u0007\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001d\u0010\nR\u001b\u0010\u001f\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\f\u001a\u0004\b \u0010\nR\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\f\u001a\u0004\b+\u0010\nR\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001b\u00103\u001a\u0002048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\f\u001a\u0004\b5\u00106R\u001b\u00108\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\f\u001a\u0004\b9\u0010\nR\u0014\u0010;\u001a\u00020<8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0016\u0010?\u001a\u0004\u0018\u00010\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001bR\u001b\u0010A\u001a\u00020\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\f\u001a\u0004\bB\u0010\n\u00a8\u0006h"}, d2={"Lai/platon/pulsar/protocol/browser/emulator/impl/BrowserResponseHandlerImpl;", "Lai/platon/pulsar/protocol/browser/emulator/BrowserResponseHandler;", "Lai/platon/pulsar/common/event/AbstractEventEmitter;", "Lai/platon/pulsar/protocol/browser/emulator/BrowserResponseEvents;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bannedPages", "Lcom/codahale/metrics/Meter;", "getBannedPages", "()Lcom/codahale/metrics/Meter;", "bannedPages$delegate", "Lkotlin/Lazy;", "charsetPattern", "Ljava/util/regex/Pattern;", "getCharsetPattern", "()Ljava/util/regex/Pattern;", "emptyPages", "getEmptyPages", "emptyPages$delegate", "htmlIntegrityChecker", "Lai/platon/pulsar/protocol/browser/emulator/util/ChainedHtmlIntegrityChecker;", "getHtmlIntegrityChecker", "()Lai/platon/pulsar/protocol/browser/emulator/util/ChainedHtmlIntegrityChecker;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "missingFieldPages", "getMissingFieldPages", "missingFieldPages$delegate", "notFoundPages", "getNotFoundPages", "notFoundPages$delegate", "numNavigates", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumNavigates", "()Ljava/util/concurrent/atomic/AtomicInteger;", "pageCategorySniffer", "Lai/platon/pulsar/protocol/browser/emulator/util/ChainedPageCategorySniffer;", "getPageCategorySniffer", "()Lai/platon/pulsar/protocol/browser/emulator/util/ChainedPageCategorySniffer;", "pageSourceBytes", "getPageSourceBytes", "pageSourceBytes$delegate", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "smallPageRate", "", "getSmallPageRate", "()J", "smallPageRateHistogram", "Lcom/codahale/metrics/Histogram;", "getSmallPageRateHistogram", "()Lcom/codahale/metrics/Histogram;", "smallPageRateHistogram$delegate", "smallPages", "getSmallPages", "smallPages$delegate", "supportAllCharsets", "", "getSupportAllCharsets", "()Z", "tracer", "getTracer", "wrongProfile", "getWrongProfile", "wrongProfile$delegate", "attach", "", "checkErrorPage", "Lai/platon/pulsar/persist/ProtocolStatus;", "page", "Lai/platon/pulsar/persist/WebPage;", "status", "createBrowserErrorResponse", "Lai/platon/pulsar/protocol/browser/emulator/BrowserErrorResponse;", "message", "", "createProtocolStatusForBrokenContent", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "htmlIntegrity", "Lai/platon/pulsar/common/HtmlIntegrity;", "detach", "normalizePageSource", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "url", "pageSource", "onBrowseTimeout", "Lai/platon/pulsar/protocol/browser/emulator/NavigateTask;", "onInitHTMLIntegrityChecker", "checker", "Lai/platon/pulsar/protocol/browser/emulator/util/HtmlIntegrityChecker;", "onInitPageCategorySniffer", "sniffer", "Lai/platon/pulsar/protocol/browser/emulator/util/PageCategorySniffer;", "onResponseCreated", "driver", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "response", "Lai/platon/pulsar/crawl/protocol/Response;", "onWillCreateResponse", "pulsar-protocol"})
public class BrowserResponseHandlerImpl
extends AbstractEventEmitter<BrowserResponseEvents>
implements BrowserResponseHandler {
    @NotNull
    private final ImmutableConfig immutableConfig;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final Pattern charsetPattern;
    @NotNull
    private final AppMetricRegistry registry;
    @NotNull
    private final Lazy pageSourceBytes$delegate;
    @NotNull
    private final Lazy wrongProfile$delegate;
    @NotNull
    private final Lazy bannedPages$delegate;
    @NotNull
    private final Lazy notFoundPages$delegate;
    @NotNull
    private final Lazy missingFieldPages$delegate;
    @NotNull
    private final AtomicInteger numNavigates;
    @NotNull
    private final Lazy smallPages$delegate;
    @NotNull
    private final Lazy smallPageRateHistogram$delegate;
    @NotNull
    private final Lazy emptyPages$delegate;
    @NotNull
    private final ChainedPageCategorySniffer pageCategorySniffer;
    @NotNull
    private final ChainedHtmlIntegrityChecker htmlIntegrityChecker;

    /*
     * WARNING - void declaration
     */
    public BrowserResponseHandlerImpl(@NotNull ImmutableConfig immutableConfig) {
        void $this$htmlIntegrityChecker_u24lambda_u2d2;
        Object $this$pageCategorySniffer_u24lambda_u2d1;
        Object it;
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.immutableConfig = immutableConfig;
        Logger logger = LoggerFactory.getLogger(BrowserResponseHandlerImpl.class);
        Intrinsics.checkNotNull((Object)logger);
        Object object = this.logger = logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = object;
        BrowserResponseHandlerImpl browserResponseHandlerImpl = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        browserResponseHandlerImpl.tracer = bl4 ? object : null;
        this.charsetPattern = this.getSupportAllCharsets() ? HtmlsKt.getSYSTEM_AVAILABLE_CHARSET_PATTERN() : HtmlsKt.getDEFAULT_CHARSET_PATTERN();
        this.registry = AppMetrics.Companion.getDefaultMetricRegistry();
        this.pageSourceBytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "pageSourceBytes");
            }
        }));
        this.wrongProfile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "wrongProfile");
            }
        }));
        this.bannedPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "bannedPages");
            }
        }));
        this.notFoundPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "notFoundPages");
            }
        }));
        this.missingFieldPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "missingFieldPages");
            }
        }));
        this.numNavigates = new AtomicInteger();
        this.smallPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "smallPages");
            }
        }));
        this.smallPageRateHistogram$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Histogram>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Histogram invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).histogram((Object)this.this$0, "smallPageRate");
            }
        }));
        this.emptyPages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Meter>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Meter invoke() {
                return BrowserResponseHandlerImpl.access$getRegistry$p(this.this$0).meter((Object)this.this$0, "emptyPages");
            }
        }));
        object = new ChainedPageCategorySniffer(this.immutableConfig);
        bl = false;
        bl2 = false;
        it = object;
        browserResponseHandlerImpl = this;
        boolean bl5 = false;
        $this$pageCategorySniffer_u24lambda_u2d1.addLast(new DefaultPageCategorySniffer(this.immutableConfig));
        Unit unit = Unit.INSTANCE;
        browserResponseHandlerImpl.pageCategorySniffer = object;
        object = new ChainedHtmlIntegrityChecker(this.immutableConfig);
        bl = false;
        bl2 = false;
        $this$pageCategorySniffer_u24lambda_u2d1 = object;
        browserResponseHandlerImpl = this;
        boolean bl6 = false;
        $this$htmlIntegrityChecker_u24lambda_u2d2.addLast(new DefaultHtmlIntegrityChecker(this.immutableConfig));
        unit = Unit.INSTANCE;
        browserResponseHandlerImpl.htmlIntegrityChecker = object;
        this.attach();
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Logger getTracer() {
        return this.tracer;
    }

    protected final boolean getSupportAllCharsets() {
        return this.immutableConfig.getBoolean("parser.support.all.charsets", true);
    }

    @NotNull
    protected final Pattern getCharsetPattern() {
        return this.charsetPattern;
    }

    @NotNull
    protected final Meter getPageSourceBytes() {
        Lazy lazy = this.pageSourceBytes$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getWrongProfile() {
        Lazy lazy = this.wrongProfile$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getBannedPages() {
        Lazy lazy = this.bannedPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getNotFoundPages() {
        Lazy lazy = this.notFoundPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final Meter getMissingFieldPages() {
        Lazy lazy = this.missingFieldPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @NotNull
    protected final AtomicInteger getNumNavigates() {
        return this.numNavigates;
    }

    @NotNull
    protected final Meter getSmallPages() {
        Lazy lazy = this.smallPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    protected final long getSmallPageRate() {
        return (long)100 * this.getSmallPages().getCount() / (long)this.numNavigates.get();
    }

    @NotNull
    protected final Histogram getSmallPageRateHistogram() {
        Lazy lazy = this.smallPageRateHistogram$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Histogram)lazy.getValue();
    }

    @NotNull
    protected final Meter getEmptyPages() {
        Lazy lazy = this.emptyPages$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    @Override
    @NotNull
    public ChainedPageCategorySniffer getPageCategorySniffer() {
        return this.pageCategorySniffer;
    }

    @Override
    @NotNull
    public ChainedHtmlIntegrityChecker getHtmlIntegrityChecker() {
        return this.htmlIntegrityChecker;
    }

    @Override
    public void onInitPageCategorySniffer(@NotNull PageCategorySniffer sniffer) {
        Intrinsics.checkNotNullParameter((Object)sniffer, (String)"sniffer");
        this.getPageCategorySniffer().addLast(sniffer);
    }

    @Override
    public void onInitHTMLIntegrityChecker(@NotNull HtmlIntegrityChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        this.getHtmlIntegrityChecker().addLast(checker);
    }

    @Override
    public void onWillCreateResponse(@NotNull FetchTask task, @NotNull WebDriver driver) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.numNavigates.incrementAndGet();
    }

    @Override
    public void onResponseCreated(@NotNull FetchTask task, @NotNull WebDriver driver, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    @Override
    @NotNull
    public ProtocolStatus checkErrorPage(@NotNull WebPage page, @NotNull ProtocolStatus status) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return status;
    }

    @Override
    @NotNull
    public StringBuilder normalizePageSource(@NotNull String url, @NotNull String pageSource2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)pageSource2, (String)"pageSource");
        return HtmlUtils.INSTANCE.replaceHTMLCharset(pageSource2, this.charsetPattern, "UTF-8");
    }

    @Override
    public void onBrowseTimeout(@NotNull NavigateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.logger.isInfoEnabled()) {
            Duration elapsed = Duration.between(task.getStartTime(), Instant.now());
            int length = task.getPageSource().length();
            String string = task.getPage().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.page.url");
            Path link = AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)string, null, (int)2, null);
            InteractSettings settings = new InteractSettings((ImmutableConfig)task.getFetchTask().getVolatileConfig());
            Object[] objectArray = new Object[]{task.getPageDatum().getProtocolStatus().getMinorName(), elapsed, Strings.compactFormat((int)length), settings.getPageLoadTimeout(), settings.getScriptTimeout(), settings.getScrollInterval(), link};
            this.logger.info("Timeout ({}) after {} with {} timeouts: {}/{}/{} | file://{}", objectArray);
        }
    }

    @Override
    @NotNull
    public BrowserErrorResponse createBrowserErrorResponse(@NotNull String message) {
        ActiveDOMStatus activeDOMStatus;
        String ec;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ActiveDOMMessage activeDomMessage = ActiveDOMMessage.Companion.fromJson(message);
        ActiveDOMStatTrace activeDOMStatTrace = activeDomMessage.getTrace();
        String string = activeDOMStatTrace == null ? null : (ec = (activeDOMStatus = activeDOMStatTrace.getStatus()) == null ? null : activeDOMStatus.getEc());
        if (ec == null) {
            activeDOMStatus = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)"Unknown error, no message");
            Intrinsics.checkNotNullExpressionValue((Object)activeDOMStatus, (String)"retry(RetryScope.PRIVACY\u2026known error, no message\")");
            ActiveDOMStatus status = activeDOMStatus;
            return new BrowserErrorResponse((ProtocolStatus)status, activeDomMessage);
        }
        BrowserErrorCode error = BrowserErrorCode.Companion.valueOfOrUnknown(ec);
        BrowserErrorPageException exception = new BrowserErrorPageException(error, null, null, null, 14, null);
        ProtocolStatus protocolStatus = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)exception);
        Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"retry(RetryScope.PRIVACY, exception)");
        ProtocolStatus status = protocolStatus;
        if (error.isUnknown()) {
            this.logger.info("Undocumented browser error " + ec);
        }
        return new BrowserErrorResponse(status, activeDomMessage);
    }

    @Override
    @NotNull
    public ProtocolStatus createProtocolStatusForBrokenContent(@NotNull FetchTask task, @NotNull HtmlIntegrity htmlIntegrity) {
        ProtocolStatus protocolStatus;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)htmlIntegrity, (String)"htmlIntegrity");
        if (htmlIntegrity.isRobotCheck() || htmlIntegrity.isRobotCheck2() || htmlIntegrity.isRobotCheck3()) {
            ProtocolStatus protocolStatus2 = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl2 = false;
            ProtocolStatus it = protocolStatus2;
            boolean bl3 = false;
            this.getBannedPages().mark();
            ProtocolStatus protocolStatus3 = protocolStatus2;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus3, (String)"retry(RetryScope.PRIVACY\u2026so { bannedPages.mark() }");
            protocolStatus = protocolStatus3;
        } else if (htmlIntegrity.isWrongProfile()) {
            ProtocolStatus protocolStatus4 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl4 = false;
            ProtocolStatus it = protocolStatus4;
            boolean bl5 = false;
            this.getWrongProfile().mark();
            ProtocolStatus protocolStatus5 = protocolStatus4;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus5, (String)"retry(RetryScope.CRAWL, \u2026o { wrongProfile.mark() }");
            protocolStatus = protocolStatus5;
        } else if (htmlIntegrity.isForbidden()) {
            ProtocolStatus protocolStatus6 = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl6 = false;
            ProtocolStatus it = protocolStatus6;
            boolean bl7 = false;
            this.getBannedPages().mark();
            ProtocolStatus protocolStatus7 = protocolStatus6;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus7, (String)"retry(RetryScope.PRIVACY\u2026so { bannedPages.mark() }");
            protocolStatus = protocolStatus7;
        } else if (htmlIntegrity.isNotFound()) {
            ProtocolStatus protocolStatus8 = ProtocolStatus.failed((int)404);
            boolean bl = false;
            boolean bl8 = false;
            ProtocolStatus it = protocolStatus8;
            boolean bl9 = false;
            this.getNotFoundPages().mark();
            ProtocolStatus protocolStatus9 = protocolStatus8;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus9, (String)"failed(ProtocolStatus.NO\u2026 { notFoundPages.mark() }");
            protocolStatus = protocolStatus9;
        } else if (htmlIntegrity.isEmpty()) {
            ProtocolStatus protocolStatus10 = ProtocolStatus.retry((RetryScope)RetryScope.PRIVACY, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl10 = false;
            ProtocolStatus it = protocolStatus10;
            boolean bl11 = false;
            this.getEmptyPages().mark();
            ProtocolStatus protocolStatus11 = protocolStatus10;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus11, (String)"retry(RetryScope.PRIVACY\u2026lso { emptyPages.mark() }");
            protocolStatus = protocolStatus11;
        } else if (htmlIntegrity.isSmall()) {
            ProtocolStatus protocolStatus12 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl12 = false;
            ProtocolStatus it = protocolStatus12;
            boolean bl13 = false;
            this.getSmallPages().mark();
            this.getSmallPageRateHistogram().update(this.getSmallPageRate());
            ProtocolStatus protocolStatus13 = protocolStatus12;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus13, (String)"retry(RetryScope.CRAWL, \u2026llPageRate)\n            }");
            protocolStatus = protocolStatus13;
        } else if (htmlIntegrity.getHasMissingField()) {
            ProtocolStatus protocolStatus14 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            boolean bl = false;
            boolean bl14 = false;
            ProtocolStatus it = protocolStatus14;
            boolean bl15 = false;
            this.getMissingFieldPages().mark();
            ProtocolStatus protocolStatus15 = protocolStatus14;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus15, (String)"retry(RetryScope.CRAWL, \u2026issingFieldPages.mark() }");
            protocolStatus = protocolStatus15;
        } else {
            ProtocolStatus protocolStatus16 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL, (Object)htmlIntegrity);
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus16, (String)"retry(RetryScope.CRAWL, htmlIntegrity)");
            protocolStatus = protocolStatus16;
        }
        return protocolStatus;
    }

    private final void attach() {
        this.on((Object)BrowserResponseEvents.initPageCategorySniffer, (Function1)new Function1<PageCategorySniffer, Unit>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PageCategorySniffer sniffer) {
                Intrinsics.checkNotNullParameter((Object)sniffer, (String)"sniffer");
                this.this$0.onInitPageCategorySniffer(sniffer);
            }
        });
        this.on((Object)BrowserResponseEvents.initHTMLIntegrityChecker, (Function1)new Function1<HtmlIntegrityChecker, Unit>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HtmlIntegrityChecker checker) {
                Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
                this.this$0.onInitHTMLIntegrityChecker(checker);
            }
        });
        this.on((Object)BrowserResponseEvents.willCreateResponse, (Function2)new Function2<FetchTask, WebDriver, Unit>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull FetchTask task, @NotNull WebDriver driver) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                this.this$0.onWillCreateResponse(task, driver);
            }
        });
        this.on((Object)BrowserResponseEvents.responseCreated, (Function3)new Function3<FetchTask, WebDriver, Response, Unit>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull FetchTask task, @NotNull WebDriver driver, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.this$0.onResponseCreated(task, driver, response);
            }
        });
        this.on((Object)BrowserResponseEvents.browseTimeout, (Function1)new Function1<NavigateTask, Unit>(this){
            final /* synthetic */ BrowserResponseHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull NavigateTask task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                this.this$0.onBrowseTimeout(task);
            }
        });
    }

    private final void detach() {
        BrowserResponseEvents[] $this$forEach$iv = BrowserResponseEvents.values();
        boolean $i$f$forEach = false;
        BrowserResponseEvents[] browserResponseEventsArray = $this$forEach$iv;
        int n = browserResponseEventsArray.length;
        for (int i = 0; i < n; ++i) {
            BrowserResponseEvents element$iv;
            BrowserResponseEvents it = element$iv = browserResponseEventsArray[i];
            boolean bl = false;
            this.off((Object)it);
        }
    }

    public static final /* synthetic */ AppMetricRegistry access$getRegistry$p(BrowserResponseHandlerImpl $this) {
        return $this.registry;
    }
}

